/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;

public interface AttributeManager
extends AttributeContainer {
    public void setAttributesNotDirty();

    public void deleteAttributesByArtifact();

    public void unDeleteAttributesByArtifact();

    public <T> T getSoleAttributeValue(AttributeTypeToken var1);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, DeletionFlag var2, T var3);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, T var2);

    public <T> Attribute<T> getSoleAttribute(AttributeTypeToken var1);

    public <T> Attribute<T> getSoleAttribute(AttributeTypeToken var1, DeletionFlag var2);

    public String getSoleAttributeAsString(AttributeTypeToken var1);

    public String getSoleAttributeAsString(AttributeTypeToken var1, String var2);

    public <T> List<T> getAttributeValues(AttributeTypeToken var1);

    public <T> List<T> getAttributeValues(AttributeTypeToken var1, DeletionFlag var2);

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable();

    default public <T extends EnumToken> boolean attributeMatches(AttributeTypeEnum<T> attributeType, T ... values) {
        EnumToken enumValue = (EnumToken)this.getSoleAttributeValue((AttributeTypeToken)attributeType);
        return enumValue.matches(values);
    }

    public <T> void setSoleAttributeValue(AttributeTypeToken var1, T var2);

    public void setSoleAttributeFromStream(AttributeTypeToken var1, InputStream var2);

    public void setSoleAttributeFromString(AttributeTypeToken var1, String var2);

    public <T> void setAttributesFromValues(AttributeTypeToken var1, Collection<T> var2);

    public void setAttributesFromStrings(AttributeTypeToken var1, String ... var2);

    public <T> void setAttributesFromStrings(AttributeTypeToken var1, Collection<String> var2);

    public void deleteSoleAttribute(AttributeTypeToken var1);

    public void deleteAttributes(AttributeTypeToken var1);

    public void deleteAttributesWithValue(AttributeTypeToken var1, Object var2);

    public <T> Attribute<T> createAttribute(AttributeTypeToken var1);

    public <T> Attribute<T> createAttribute(AttributeTypeToken var1, T var2);

    public <T> List<Attribute<T>> getAttributes();

    public <T> List<Attribute<T>> getAttributes(AttributeTypeToken var1);

    public <T> List<Attribute<T>> getAttributes(DeletionFlag var1);

    public <T> List<Attribute<T>> getAttributes(AttributeTypeToken var1, DeletionFlag var2);

    public <T> Attribute<T> getAttributeById(AttributeId var1);

    public <T> Attribute<T> getAttributeById(AttributeId var1, DeletionFlag var2);
}

