/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.cache.admin.internal;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.osee.cache.admin.Cache;

public class CacheProxy<K, V>
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> proxied;

    public CacheProxy(com.google.common.cache.Cache<K, V> proxied) {
        this.proxied = proxied;
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.proxied.getIfPresent(key);
    }

    @Override
    public Iterable<V> getAllPresent() {
        Iterable<K> keys = this.getAllKeysPresent();
        return this.getIfPresent(keys).values();
    }

    @Override
    public Iterable<? extends K> getAllKeysPresent() {
        return Iterables.unmodifiableIterable(this.proxied.asMap().keySet());
    }

    @Override
    public Iterable<? extends K> getAllKeys() {
        return this.getAllKeysPresent();
    }

    @Override
    public Map<K, V> getIfPresent(Iterable<? extends K> keys) {
        return this.proxied.getAllPresent(keys);
    }

    @Override
    public Map<K, V> get(Iterable<? extends K> keys) throws Exception {
        ImmutableMap items = null;
        try {
            items = this.proxied.getAllPresent(keys);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return items;
    }

    @Override
    public Iterable<V> getAll() throws Exception {
        Iterable<K> allKeys = this.getAllKeys();
        return this.get((K)allKeys).values();
    }

    @Override
    public V get(K key) throws Exception {
        Object toReturn = null;
        try {
            toReturn = this.proxied.getIfPresent(key);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return (V)toReturn;
    }

    @Override
    public void refresh(K key) {
    }

    @Override
    public void invalidateAll() {
        this.proxied.invalidateAll();
    }

    @Override
    public void invalidate(Iterable<? extends K> keys) {
        this.proxied.invalidateAll(keys);
    }

    @Override
    public void invalidate(K key) {
        this.proxied.invalidate(key);
    }

    @Override
    public long size() {
        return this.proxied.size();
    }

    @Override
    public V get(K key, Callable<? extends V> callable) throws Exception {
        Object toReturn = null;
        try {
            toReturn = this.proxied.get(key, callable);
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            throw new Exception(ex);
        }
        catch (UncheckedExecutionException ex) {
            throw new Exception(ex);
        }
        catch (ExecutionError ex) {
            throw new Exception(ex);
        }
        return (V)toReturn;
    }

    @Override
    public boolean isEmpty() {
        return this.proxied.size() == 0L;
    }
}

