/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class FilenameFactory {
    private static String FILENAME_CLEAN_CHAR_REPLACEMENT = " ";
    private static final Pattern FILENAME_CLEANER_PATTERN = Pattern.compile("[/<>(){}\\[\\].:;\\\"'\\\\|?*+]+");
    private static final String FILENAME_DATE_TIME_FORMAT = "yyyyMMdd-HHmmss-SSS";
    private static String FILENAME_SAFE_CHAR_REPLACEMENT = "-";
    private static char FILENAME_EXTENSION_SEPARATOR = (char)46;
    private static String FILENAME_SEGMENT_SEPARATOR = "-";
    private static final Random generator = new Random();
    private static final Pattern WHITESPACE_CLEANER_PATTERN = Pattern.compile("\\s+");
    private static final int WINDOWS_FILENAME_LIMIT = 215;

    public static String create(CharSequence extension, CharSequence ... segments) {
        String dateSegment = FilenameFactory.getDateSegment();
        String randomSegment = FilenameFactory.getRandomSegment();
        String safeExtension = FilenameFactory.makeNameSafer(extension);
        StringBuilder name = new StringBuilder(430);
        if (Objects.nonNull(segments) && segments.length > 0) {
            Arrays.stream(segments).map(FilenameFactory::makeNameSafer).filter(Strings::isValidAndNonBlank).forEach(segment -> {
                name.append((String)segment);
                name.append(FILENAME_SEGMENT_SEPARATOR);
            });
        }
        if (Objects.nonNull(dateSegment)) {
            name.append(dateSegment);
            name.append(FILENAME_SEGMENT_SEPARATOR);
        }
        if (Objects.nonNull(randomSegment)) {
            name.append(randomSegment);
        }
        if (Strings.isValidAndNonBlank((String)safeExtension)) {
            if (safeExtension.charAt(0) != FILENAME_EXTENSION_SEPARATOR) {
                name.append(FILENAME_EXTENSION_SEPARATOR);
            }
            name.append(safeExtension);
        }
        return name.toString();
    }

    private static String getDateSegment() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FILENAME_DATE_TIME_FORMAT);
        String dateSegment = dateFormat.format(new Date());
        return dateSegment;
    }

    private static String getRandomSegment() {
        int randomValue = generator.nextInt(99999) + 1;
        String randomSegment = String.format("%05d", randomValue);
        return randomSegment;
    }

    public static boolean isInLimit(CharSequence filename) {
        return Lib.isWindows() ? Objects.isNull(filename) || filename.length() <= 215 : true;
    }

    public static String makeNameSafer(CharSequence name) {
        String characterCleanName = Strings.totallySaferReplace((CharSequence)name, (Pattern)FILENAME_CLEANER_PATTERN, (String)FILENAME_CLEAN_CHAR_REPLACEMENT);
        if (Strings.isInvalidOrBlank((String)characterCleanName)) {
            return Strings.emptyString();
        }
        String trimCharacterCleanName = characterCleanName.trim();
        String whiteSpaceCleanTrimCharacterCleanName = Strings.totallySaferReplace((CharSequence)trimCharacterCleanName, (Pattern)WHITESPACE_CLEANER_PATTERN, (String)FILENAME_SAFE_CHAR_REPLACEMENT);
        return whiteSpaceCleanTrimCharacterCleanName;
    }

    private FilenameFactory() {
    }
}

