/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;

public class AttributeTypeAccessType
implements AccessType {
    private AllowDeny allowDeny;
    private AttributeTypeToken attributeType;
    private ArtifactTypeToken artifactType;

    public AttributeTypeAccessType(AllowDeny allowDeny, AttributeTypeToken attributeType, ArtifactTypeToken artifactType) {
        this.allowDeny = allowDeny;
        this.attributeType = attributeType;
        this.artifactType = artifactType;
    }

    public AllowDeny getAllowDeny() {
        return this.allowDeny;
    }

    public void setAllowDeny(AllowDeny allowDeny) {
        this.allowDeny = allowDeny;
    }

    @Override
    public boolean isArtifactType() {
        return true;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeTypeToken attributeType) {
        this.attributeType = attributeType;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    public String toString() {
        return "AttrType [allow=" + (Object)((Object)this.allowDeny) + ", attrType=" + this.attributeType + ", artType=" + this.artifactType + "]";
    }

    @Override
    public AccessTypeMatch computeMatch(ArtifactToken otherArt, AttributeTypeToken attrType, RelationTypeToken relType, IParentProvider parentProvider) {
        if (otherArt.getArtifactType().inheritsFrom(this.artifactType) && this.attributeType.equals(attrType)) {
            if (this.allowDeny == AllowDeny.Allow) {
                return AccessTypeMatch.Allow;
            }
            if (this.allowDeny == AllowDeny.Deny) {
                return AccessTypeMatch.Deny;
            }
        }
        return AccessTypeMatch.NoMatch;
    }
}

