/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing.datarights;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.api.publishing.datarights.DataRight;
import org.eclipse.osee.define.api.publishing.datarights.DataRightAnchor;
import org.eclipse.osee.define.api.publishing.datarights.DataRightResult;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.util.WordCoreUtil;

public class DataRightContentBuilder {
    private final Map<ArtifactId, DataRightAnchor> dataRightAnchors;

    public DataRightContentBuilder(DataRightResult dataRightResult) {
        Objects.requireNonNull(dataRightResult, "DataRightContentBuilder::new, the parameter \"dataRightAnchorsResult\" cannot be null.");
        Map<ArtifactId, DataRightAnchor> map = dataRightResult.getDataRightAnchors();
        assert (Objects.nonNull(map)) : "DataRightContentBuilder::new, \"dataRightAnchorsResult.getDataRightAnchors()\" returned null.";
        this.dataRightAnchors = Collections.unmodifiableMap(map);
    }

    public String getContent(ArtifactId artifactId, WordCoreUtil.pageType orientation) {
        WordCoreUtil.pageType pageType2;
        if (Objects.isNull(artifactId) || ArtifactId.SENTINEL.equals(artifactId)) {
            return "";
        }
        DataRightAnchor dataRightAnchor = this.dataRightAnchors.get(artifactId);
        if (Objects.isNull(dataRightAnchor)) {
            return "";
        }
        WordCoreUtil.pageType pageType3 = pageType2 = orientation.isLandscape() ? WordCoreUtil.pageType.LANDSCAPE : WordCoreUtil.pageType.PORTRAIT;
        if (dataRightAnchor.getNewFooter().booleanValue()) {
            DataRight dataRight = dataRightAnchor.getDataRight();
            assert (Objects.nonNull(dataRight)) : "DataRightContentBuilder::getContent, \"DataRightAnchor\" has null \"DataRight\" and should never.";
            String footer = dataRight.getContent();
            StringBuilder newPage = pageType2.getNewPage((CharSequence)footer);
            return newPage.toString();
        }
        if (!dataRightAnchor.getIsContinuous().booleanValue()) {
            StringBuilder newPage = pageType2.getNewPage((CharSequence)"");
            return newPage.toString();
        }
        return "";
    }
}

