/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.ExportImportSql;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractSqlExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public class DbTableSqlExportItem
extends AbstractSqlExportItem {
    private final String query;
    private final Object[] bindData;
    private final IResourceManager resourceManager;

    public DbTableSqlExportItem(Log logger, JdbcClient jdbcClient, IResourceManager resourceManager, ExportItem id, String query, Object[] bindData) {
        super(logger, id, jdbcClient);
        this.resourceManager = resourceManager;
        this.query = query;
        this.bindData = bindData;
    }

    protected String exportBinaryDataTo(File tempFolder, String uriTarget) throws IOException {
        if (!(tempFolder = new File(tempFolder + File.separator + "resources")).exists()) {
            tempFolder.mkdirs();
        }
        IResourceLocator locator = this.resourceManager.getResourceLocator(uriTarget);
        IResource resource = this.resourceManager.acquire(locator, new PropertyStore());
        File target = new File(tempFolder, locator.getRawPath());
        if (target.getParentFile() != null) {
            target.getParentFile().mkdirs();
        }
        InputStream sourceStream = null;
        FileOutputStream outputStream = null;
        try {
            if (resource != null) {
                sourceStream = resource.getContent();
                outputStream = new FileOutputStream(target);
                Lib.inputStreamToOutputStream((InputStream)sourceStream, (OutputStream)outputStream);
            }
        }
        finally {
            Lib.close(sourceStream);
            Lib.close(outputStream);
        }
        return uriTarget;
    }

    @Override
    protected void doWork(Appendable appendable) {
        this.jdbcClient.runQueryWithMaxFetchSize(stmt -> this.processData(appendable, (JdbcStatement)stmt), this.query, this.bindData);
    }

    private void processData(Appendable appendable, JdbcStatement chStmt) {
        try {
            try {
                boolean firstAttribute = false;
                ExportImportSql.openSqlValue(appendable);
                int numberOfColumns = chStmt.getColumnCount();
                int columnIndex = 1;
                while (columnIndex <= numberOfColumns) {
                    firstAttribute = columnIndex == 1;
                    String columnName = chStmt.getColumnName(columnIndex).toLowerCase();
                    Object value = chStmt.getObject(columnIndex);
                    if (columnName.equals("uri")) {
                        this.handleBinaryContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("value")) {
                        this.handleStringContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("osee_comment")) {
                        this.handleStringContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("branch_name")) {
                        this.handleStringContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("rationale")) {
                        this.handleStringContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("guid")) {
                        this.handleStringContent(appendable, value, firstAttribute);
                    } else if (columnName.equals("art_type_id")) {
                        this.handleTypeId(appendable, value, firstAttribute);
                    } else if (columnName.equals("attr_type_id")) {
                        this.handleTypeId(appendable, value, firstAttribute);
                    } else if (columnName.equals("rel_link_type_id")) {
                        this.handleTypeId(appendable, value, firstAttribute);
                    } else if (columnName.equals("build_id")) {
                        this.handleTypeId(appendable, value, firstAttribute);
                    } else if (columnName.equals("tx_type")) {
                        this.handleTypeId(appendable, value, firstAttribute);
                    } else {
                        Timestamp timestamp = this.asTimestamp(value);
                        if (timestamp != null && firstAttribute) {
                            ExportImportSql.addFirstSqlStringAttribute(appendable, timestamp);
                        } else if (timestamp != null && !firstAttribute) {
                            ExportImportSql.addSqlStringAttribute(appendable, timestamp);
                        } else {
                            try {
                                if (firstAttribute) {
                                    ExportImportSql.addFirstSqlAttribute(appendable, value);
                                } else {
                                    ExportImportSql.addSqlAttribute(appendable, value);
                                }
                            }
                            catch (Exception ex) {
                                throw new OseeCoreException((Throwable)ex, "Unable to convert [%s] of raw type [%s] to string.", new Object[]{columnName, chStmt.getColumnTypeName(columnIndex)});
                            }
                        }
                    }
                    ++columnIndex;
                }
            }
            finally {
                ExportImportSql.closeSqlValue(appendable);
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex, "Failure during %s processData", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
    }

    private Timestamp asTimestamp(Object value) {
        Timestamp toReturn = null;
        if (value instanceof Timestamp) {
            toReturn = (Timestamp)value;
        } else if (value != null) {
            try {
                Class<?> clazz = value.getClass();
                Method method = clazz.getMethod("timestampValue", new Class[0]);
                Object object = method.invoke(value, new Object[0]);
                if (object instanceof Timestamp) {
                    toReturn = (Timestamp)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception ex) {
                this.getLogger().warn((Throwable)ex, "Error converting [%s] to timestamp", new Object[]{value});
            }
        }
        return toReturn;
    }

    private void handleBinaryContent(Appendable appendable, Object value, boolean firstAttribute) throws IOException {
        String uriData = (String)value;
        if (Strings.isValid((String)uriData)) {
            uriData = this.exportBinaryDataTo(this.getWriteLocation(), uriData);
            if (firstAttribute) {
                ExportImportSql.addFirstSqlStringAttribute(appendable, uriData);
            } else {
                ExportImportSql.addSqlStringAttribute(appendable, uriData);
            }
        } else if (firstAttribute) {
            appendable.append("''");
        } else {
            appendable.append(",''");
        }
    }

    private void handleTypeId(Appendable appendable, Object value, boolean firstAttribute) throws IOException {
        long typeId = -1L;
        if (value instanceof Short) {
            Short xShort = (Short)value;
            typeId = xShort.longValue();
        } else if (value instanceof Integer) {
            typeId = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            typeId = (Long)value;
        } else if (value instanceof BigInteger) {
            typeId = ((BigInteger)value).longValue();
        } else if (value instanceof BigDecimal) {
            typeId = ((BigDecimal)value).longValue();
        } else {
            throw new OseeCoreException("Undefined Type [%s]", new Object[]{value != null ? value.getClass().getSimpleName() : value});
        }
        String uuidString = String.valueOf(typeId);
        if (firstAttribute) {
            ExportImportSql.addFirstSqlAttribute(appendable, uuidString);
        } else {
            ExportImportSql.addSqlAttribute(appendable, uuidString);
        }
    }

    private void handleStringContent(Appendable appendable, Object value, boolean firstAttribute) throws IOException {
        String stringValue = (String)value;
        if (Strings.isValid((String)stringValue)) {
            if (firstAttribute) {
                ExportImportSql.addFirstSqlStringAttribute(appendable, stringValue);
            } else {
                ExportImportSql.addSqlStringAttribute(appendable, stringValue);
            }
        } else if (firstAttribute) {
            appendable.append("''");
        } else {
            appendable.append(",''");
        }
    }

    public static String escapeSql(String value) {
        if (!Strings.isValid((String)value)) {
            throw new OseeArgumentException("Invalid String given to escapeSql", new Object[0]);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("''");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

