/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.sync.jira;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.jira.JiraEndpoint;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class JiraEndpointImpl
implements JiraEndpoint {
    private final AtsApi atsApi;
    static final String JIRA_SEARCH = "/rest/api/2/search";
    static final String JIRA_ISSUE = "/rest/api/2/issue";

    public JiraEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String searchJira(String jsonPayload) {
        return this.sendJiraRequest(jsonPayload, JIRA_SEARCH, "POST");
    }

    public String createJiraIssue(String jsonPayload) {
        return this.sendJiraRequest(jsonPayload, JIRA_ISSUE, "POST");
    }

    public String editJira(String jsonPayload, String issueId) {
        String urlExtension = "/rest/api/2/issue/" + issueId;
        return this.sendJiraRequest(jsonPayload, urlExtension, "PUT");
    }

    private String sendJiraRequest(String jsonPayload, String urlExtension, String requestMethod) {
        StringBuilder response = new StringBuilder();
        String personalAccessToken = this.getPersonalAccessToken();
        String jiraUrl = this.getJiraUrl();
        String websiteURL = String.valueOf(jiraUrl) + urlExtension;
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL("https://" + websiteURL);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setRequestMethod(requestMethod);
                conn.setRequestProperty("Authorization", personalAccessToken);
                conn.setRequestProperty("Connection", "keep-alive");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                Throwable throwable = null;
                Object var11_14 = null;
                try (OutputStream os = conn.getOutputStream();){
                    byte[] input = jsonPayload.getBytes();
                    os.write(input, 0, input.length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var11_14 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
                    String responseLine = null;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    br.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                conn.getContent();
                conn.disconnect();
            }
            catch (Exception ex) {
                throw new OseeCoreException("JIRA Operation Failed", (Throwable)ex);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response.toString();
    }

    private String getPersonalAccessToken() {
        ArtifactToken jiraConfig = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.JiraConfig, (BranchId)this.atsApi.getAtsBranch());
        return "Bearer " + (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)jiraConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)"");
    }

    private String getJiraUrl() {
        ArtifactToken jiraConfig = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.JiraConfig, (BranchId)this.atsApi.getAtsBranch());
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)jiraConfig, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"");
    }

    public int getNumberOfResults(String searchResults) {
        searchResults = searchResults.replaceAll("[^0-9]+", " ");
        return Integer.parseInt(Arrays.asList(searchResults.trim().split(" ")).get(2));
    }
}

