/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ConvertAtsAisAndTeamDefsOperation {
    private final AtsApi atsApi;
    private final boolean persist = false;
    Map<String, ArtifactToken> keepAiArts = new HashMap<String, ArtifactToken>();
    Map<String, ArtifactToken> keepAiTeamDefArts = new HashMap<String, ArtifactToken>();

    public ConvertAtsAisAndTeamDefsOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        List<String> keepNames = Arrays.asList("PROG1 Change Request", "PROG1 PL ARB", "PROG1 Integration Test", "PROG1", "PROG1 Requirements", "PROG1 Software Test", "PROG1 Code", "");
        XResultData rd = new XResultData();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Cleanup AIs and TeamDefs");
        List ais = this.atsApi.getQueryService().getArtifacts(AtsArtifactTypes.ActionableItem);
        for (ArtifactToken ai : ais) {
            if (!keepNames.contains(ai.getName())) continue;
            this.keepAiArts.put(ai.getName(), ai);
        }
        for (ArtifactToken ai : ais) {
            if (ai.getName().startsWith("PROG1")) {
                if (keepNames.contains(ai.getName())) {
                    rd.logf("KEEP AI: %s\n", new Object[]{ai.toStringWithId()});
                    continue;
                }
                Collection<ArtifactToken> referencedArts = this.getReferencedAiArts(ai);
                if (referencedArts.isEmpty()) {
                    rd.logf("Processing AI: %s - NO REFRENCES, JUST DELETE\n", new Object[]{ai.toStringWithId()});
                    continue;
                }
                rd.logf("Processing AI: %s - ====> CLEANUP [%s] REFRENCES AND DELETE\n", new Object[]{ai.toStringWithId(), referencedArts.size()});
                this.cleanupAndDeleteArt("AI", ai, referencedArts, this.keepAiArts, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, rd, changes);
                continue;
            }
            rd.warningf("Skipping AI: %s\n", new Object[]{ai.toStringWithId()});
        }
        List teamDefs = this.atsApi.getQueryService().getArtifacts(AtsArtifactTypes.TeamDefinition);
        for (ArtifactToken teamDef : teamDefs) {
            if (!keepNames.contains(teamDef.getName())) continue;
            this.keepAiTeamDefArts.put(teamDef.getName(), teamDef);
        }
        for (ArtifactToken teamDef : teamDefs) {
            if (teamDef.getName().startsWith("PROG1")) {
                if (keepNames.contains(teamDef.getName())) {
                    rd.logf("KEEP TeamDef: %s\n", new Object[]{teamDef.toStringWithId()});
                    continue;
                }
                Collection<ArtifactToken> referencedArts = this.getReferencedTeamDefArts(teamDef);
                if (referencedArts.isEmpty()) {
                    rd.logf("Processing TeamDef: %s - NO REFRENCES, JUST DELETE\n", new Object[]{teamDef.toStringWithId()});
                    continue;
                }
                rd.logf("Processing TeamDef: %s - ====> CLEANUP [%s] REFRENCES AND DELETE\n", new Object[]{teamDef.toStringWithId(), referencedArts.size()});
                this.cleanupAndDeleteArt("TeamDef", teamDef, referencedArts, this.keepAiTeamDefArts, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, rd, changes);
                continue;
            }
            rd.warningf("Skipping TeamDef: %s\n", new Object[]{teamDef.toStringWithId()});
        }
        changes.executeIfNeeded();
        return rd;
    }

    private void cleanupAndDeleteArt(String typeName, ArtifactToken artToDelete, Collection<ArtifactToken> referencedArts, Map<String, ArtifactToken> keepArtsMap, AttributeTypeToken attrType, XResultData rd, IAtsChangeSet changes) {
        ArtifactToken topArt = null;
        for (Map.Entry<String, ArtifactToken> entry : keepArtsMap.entrySet()) {
            String topArtName = entry.getKey();
            if (!artToDelete.getName().startsWith(topArtName)) continue;
            topArt = entry.getValue();
            break;
        }
        if (topArt == null) {
            rd.errorf("Can't get top %s for %s\n", new Object[]{typeName, artToDelete.toStringWithId()});
        } else {
            for (ArtifactToken artifactToken : referencedArts) {
            }
        }
    }

    private Collection<ArtifactToken> getReferencedAiArts(ArtifactToken ai) {
        Collection artifacts = this.atsApi.getQueryService().getArtifacts((AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, ai.getIdString(), this.atsApi.getAtsBranch());
        return artifacts;
    }

    private Collection<ArtifactToken> getReferencedTeamDefArts(ArtifactToken teamDef) {
        Collection artifacts = this.atsApi.getQueryService().getArtifacts((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, teamDef.getIdString(), this.atsApi.getAtsBranch());
        return artifacts;
    }
}

