/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.net.URI;
import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.internal.RequestInfo;
import org.eclipse.osee.account.rest.model.AccountLoginData;
import org.eclipse.osee.account.rest.model.AccountSessionData;

public class AccountLoginResource {
    private final AccountOps accountOps;

    public AccountLoginResource(AccountOps accountOps) {
        this.accountOps = accountOps;
    }

    @POST
    @PermitAll
    @Consumes(value={"application/json", "application/xml"})
    public Response login(@Context HttpServletRequest request, @Context UriInfo uriInfo, AccountLoginData data) {
        RequestInfo remoteInfo = this.accountOps.asRequestInfo(request);
        AccountSessionData token = this.accountOps.doLogin(remoteInfo, data);
        String accountId = String.valueOf(token.getAccountId());
        URI location = UriBuilder.fromPath((String)uriInfo.getBaseUri().toASCIIString()).path(accountId).build(new Object[0]);
        return Response.ok().entity((Object)token).contentLocation(location).build();
    }
}

