/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.operations;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ValidateWorkDefinitionsOperation {
    private final AtsApi atsApi;

    public ValidateWorkDefinitionsOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        XResultData results = new XResultData();
        for (WorkDefinition workDef : this.atsApi.getWorkDefinitionService().getAllWorkDefinitions()) {
            results.logf("Validating workDef [%s]\n", new Object[]{workDef.getName()});
            results.logf("--- Validating header\n", new Object[0]);
            for (LayoutItem layoutItem : workDef.getHeaderDef().getLayoutItems()) {
                this.validateLayoutItem(layoutItem, results);
            }
            for (StateDefinition stateDef : workDef.getStates()) {
                results.logf("--- Validating state [%s]\n", new Object[]{stateDef.getName()});
                for (LayoutItem layoutItem : stateDef.getLayoutItems()) {
                    this.validateLayoutItem(layoutItem, results);
                }
            }
        }
        return results;
    }

    private void validateLayoutItem(LayoutItem layoutItem, XResultData results) {
        if (layoutItem instanceof WidgetDefinition) {
            WidgetDefinition widgetDef = (WidgetDefinition)layoutItem;
            AttributeTypeToken attrTypeTok = widgetDef.getAttributeType();
            if (attrTypeTok != null) {
                AttributeTypeGeneric attrType = this.atsApi.tokenService().getAttributeType(attrTypeTok.getId());
                if (attrType == null) {
                    results.errorf("------ Type %s for widget %s is not valid.\n", new Object[]{attrTypeTok.toStringWithId(), widgetDef.toStringWithId()});
                } else {
                    results.logf("------ Type %s for widget %s\n", new Object[]{attrTypeTok.isValid() ? attrTypeTok.toStringWithId() : "N/A", widgetDef.toStringWithId()});
                }
            }
        } else if (layoutItem instanceof CompositeLayoutItem) {
            CompositeLayoutItem comp = (CompositeLayoutItem)layoutItem;
            for (LayoutItem compLayoutItem : comp.getLayoutItems()) {
                this.validateLayoutItem(compLayoutItem, results);
            }
        }
    }
}

