/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionProvider;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionProviderService;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.core.workdef.internal.AtsWorkDefinitionProvider;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AtsWorkDefinitionProviderService
implements IAtsWorkDefinitionProviderService {
    private static Map<Long, WorkDefinition> idToWorkDef = new HashMap<Long, WorkDefinition>();
    private final Collection<IAtsWorkDefinitionProvider> workDefProviders = new ArrayList<IAtsWorkDefinitionProvider>();
    private final Collection<IAtsWorkDefinitionProvider> workDefProviderProcessed = new ArrayList<IAtsWorkDefinitionProvider>();
    private AtsWorkDefinitionProvider atsWorkDefProv;

    public void addWorkDefinitionProvider(final IAtsWorkDefinitionProvider workDefProvider) {
        this.workDefProviders.add(workDefProvider);
        Thread load = new Thread("Load Work Defs"){

            @Override
            public void run() {
                AtsWorkDefinitionProviderService.this.handleProvider(workDefProvider);
            }
        };
        load.start();
    }

    public void ensureLoaded() {
        if (!this.workDefProviderProcessed.contains(this.atsWorkDefProv)) {
            this.atsWorkDefProv = new AtsWorkDefinitionProvider();
            this.workDefProviders.add(this.atsWorkDefProv);
        }
        int cacheSize = idToWorkDef.keySet().size();
        for (IAtsWorkDefinitionProvider workDefProvider : new CopyOnWriteArrayList<IAtsWorkDefinitionProvider>(this.workDefProviders)) {
            this.handleProvider(workDefProvider);
        }
        if (cacheSize == idToWorkDef.keySet().size()) {
            return;
        }
        XResultData rd = new XResultData();
        for (WorkDefinition workDef : idToWorkDef.values()) {
            if (!workDef.getResults().isErrors()) continue;
            rd.merge(workDef.getResults());
        }
        if (rd.isErrors()) {
            throw new OseeArgumentException("Exception Building WorkDef(s) %s", new Object[]{rd.toString()});
        }
    }

    private void handleProvider(IAtsWorkDefinitionProvider workDefProvider) {
        if (!this.workDefProviderProcessed.contains(workDefProvider)) {
            for (WorkDefinition workDef : workDefProvider.getWorkDefinitions()) {
                idToWorkDef.put(workDef.getId(), workDef);
            }
            this.workDefProviderProcessed.add(workDefProvider);
        }
    }

    public WorkDefinition getWorkDefinition(Long id) {
        this.ensureLoaded();
        return idToWorkDef.get(id);
    }

    public Collection<WorkDefinition> getAll() {
        this.ensureLoaded();
        return idToWorkDef.values();
    }

    public void addWorkDefinition(WorkDefinition workDef) {
        this.ensureLoaded();
        idToWorkDef.put(workDef.getId(), workDef);
    }
}

