/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.builder;

import java.util.Collection;
import org.eclipse.osee.ats.api.review.DecisionReviewOption;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.workdef.builder.DecisionReviewDefinitionBuilder;
import org.eclipse.osee.framework.core.data.UserToken;

public class DecisionReviewOptionBuilder {
    private final DecisionReviewOption decRevOpt;
    private final DecisionReviewDefinitionBuilder decRevBldr;

    public DecisionReviewOptionBuilder(String name, DecisionReviewDefinitionBuilder decRevBldr) {
        this.decRevOpt = new DecisionReviewOption(name);
        decRevBldr.getReviewDefinition().getOptions().add(this.decRevOpt);
        this.decRevBldr = decRevBldr;
    }

    public void setName(String name) {
        this.decRevOpt.setName(name);
    }

    public void setUserIds(Collection<String> userIds) {
        this.decRevOpt.getUserIds().addAll(userIds);
    }

    public void setFollowup(boolean followup) {
        this.decRevOpt.setFollowupRequired(true);
    }

    public DecisionReviewOptionBuilder toCompleted() {
        this.decRevOpt.setFollowupRequired(false);
        return this;
    }

    public DecisionReviewOptionBuilder toFollowup() {
        this.decRevOpt.setFollowupRequired(true);
        return this;
    }

    public DecisionReviewOptionBuilder andAssignees(AtsUser ... users) {
        AtsUser[] atsUserArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            AtsUser user = atsUserArray[n2];
            this.decRevOpt.getUserIds().add(user.getUserId());
            ++n2;
        }
        return this;
    }

    public DecisionReviewOptionBuilder andAssignees(UserToken ... users) {
        UserToken[] userTokenArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            UserToken user = userTokenArray[n2];
            this.decRevOpt.getUserIds().add(user.getUserId());
            ++n2;
        }
        return this;
    }

    public DecisionReviewDefinitionBuilder done() {
        return this.decRevBldr;
    }
}

