/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionBuilder;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.HeaderDefinition;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.agile.AgileItem;
import org.eclipse.osee.ats.core.workdef.operations.ValidateWorkDefinitionsOperation;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWorkDefinitionServiceImpl
implements IAtsWorkDefinitionService {
    private final AtsApi atsApi;
    private final ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;
    private final Map<IAtsWorkItem, WorkDefinition> bootstrappingWorkItemToWorkDefCache = new HashMap<IAtsWorkItem, WorkDefinition>();
    private final Set<IAtsWorkItem> logOnce = new HashSet<IAtsWorkItem>();
    public static final String VALID_STATE_NAMES_KEY = "validStateNames";

    public AtsWorkDefinitionServiceImpl(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.atsApi = atsApi;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    public WorkDefinition getWorkDefinitionFromAsObject(IAtsObject atsObject, AttributeTypeToken workDefAttrTypeId) {
        WorkDefinition workDefinition = null;
        String workDefIdStr = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString(atsObject, workDefAttrTypeId, "");
        if (Strings.isNumeric((String)workDefIdStr)) {
            workDefinition = this.getWorkDefinition(Long.valueOf(workDefIdStr));
        }
        return workDefinition;
    }

    private WorkDefinition getWorkDefinitionFromAsObject(IAtsObject atsObject) {
        return this.getWorkDefinitionFromAsObject(atsObject, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference);
    }

    public WorkDefinition getWorkDefinition(IAtsWorkItem workItem) {
        WorkDefinition workDefinition = this.bootstrappingWorkItemToWorkDefCache.get(workItem);
        if (workDefinition != null) {
            return workDefinition;
        }
        try {
            workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)workItem);
        }
        catch (Exception ex) {
            throw new OseeWrappedException((Throwable)ex, "Error getting work definition for work item %s", new Object[]{workItem.toStringWithId()});
        }
        return workDefinition;
    }

    public WorkDefinition getWorkDefinitionByName(String name) {
        for (WorkDefinition workDef : this.atsApi.getWorkDefinitionProviderService().getAll()) {
            if (!workDef.getName().equals(name)) continue;
            return workDef;
        }
        if (Strings.isNumeric((String)name)) {
            throw new OseeArgumentException("Can't get work def, but is numeric [%s], probably wrong method", new Object[]{name});
        }
        return null;
    }

    private WorkDefinition getWorkDefinitionFromArtifactsAttributeValue(IAtsWorkItem workItem) {
        WorkDefinition workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)workItem);
        return workDefinition;
    }

    private WorkDefinition getWorkDefinitionFromArtifactsAttributeValue(IAtsTeamDefinition teamDef) {
        WorkDefinition workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)teamDef);
        return workDefinition;
    }

    private WorkDefinition getTaskWorkDefinitionFromArtifactsAttributeValue(IAtsTeamDefinition teamDef) {
        WorkDefinition workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference);
        return workDefinition;
    }

    private WorkDefinition getWorkDefinitionFromTeamDefinitionAttributeInherited(IAtsTeamDefinition teamDef) {
        WorkDefinition workDef = this.getWorkDefinitionFromArtifactsAttributeValue(teamDef);
        if (workDef != null) {
            return workDef;
        }
        TeamDefinition parentArt = this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef);
        if (parentArt != null) {
            workDef = this.getWorkDefinitionFromTeamDefinitionAttributeInherited((IAtsTeamDefinition)parentArt);
        }
        return workDef;
    }

    public WorkDefinition computedWorkDefinitionForTaskNotYetCreated(IAtsTeamWorkflow teamWf) {
        Conditions.assertNotNull((Object)teamWf, (String)"Team Workflow can not be null", (Object[])new Object[0]);
        WorkDefinition workDefinition = null;
        for (ITeamWorkflowProvider provider : TeamWorkflowProviders.getTeamWorkflowProviders()) {
            AtsWorkDefinitionToken workDefTok = provider.getRelatedTaskWorkflowDefinitionId(teamWf);
            if (workDefTok == null || !workDefTok.isValid()) continue;
            workDefinition = this.getWorkDefinition((Id)workDefTok);
            break;
        }
        if (workDefinition == null) {
            workDefinition = this.getTaskWorkDefinitionFromArtifactsAttributeValue(teamWf.getTeamDefinition());
        }
        if (workDefinition == null) {
            workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Task_Default);
        }
        return workDefinition;
    }

    public WorkDefinition computeWorkDefinition(IAtsWorkItem workItem) {
        return this.computeWorkDefinition(workItem, true);
    }

    public WorkDefinition computeWorkDefinition(IAtsWorkItem workItem, boolean useAttr) {
        WorkDefinition workDef = null;
        if (useAttr) {
            workDef = this.getWorkDefinitionFromArtifactsAttributeValue(workItem);
        }
        if (workDef == null) {
            if (!this.logOnce.contains(workItem)) {
                OseeLog.log(AtsWorkDefinitionServiceImpl.class, (Level)Level.INFO, (String)("No WorkDef attr for " + workItem.toStringWithId()));
                this.logOnce.add(workItem);
            }
            if (workItem instanceof IAtsTask && ((IAtsTask)workItem).getParentTeamWorkflow() != null) {
                workDef = this.computedWorkDefinitionForTaskNotYetCreated(((IAtsTask)workItem).getParentTeamWorkflow());
            }
            if (workDef == null) {
                for (ITeamWorkflowProvider provider : this.teamWorkflowProvidersLazy.getProviders()) {
                    AtsWorkDefinitionToken workFlowDefId = provider.getWorkflowDefinitionId(workItem);
                    if (workFlowDefId == null || !workFlowDefId.isValid()) continue;
                    workDef = this.getWorkDefinition((Id)workFlowDefId);
                }
                if (workDef == null) {
                    if (workItem instanceof AgileItem) {
                        workItem = this.atsApi.getWorkItemService().getWorkItem(((AgileItem)workItem).getId());
                    }
                    if (workItem instanceof IAtsTeamWorkflow) {
                        IAtsTeamDefinition teamDef = ((IAtsTeamWorkflow)workItem).getTeamDefinition();
                        Conditions.assertNotNull((Object)teamDef, (String)"Team Def can not be null for %s.  Re-convert?", (Object[])new Object[]{workItem.toStringWithId()});
                        workDef = this.getWorkDefinitionFromTeamDefinitionAttributeInherited(teamDef);
                    } else if (workItem instanceof IAtsGoal) {
                        workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
                    } else if (workItem instanceof IAgileBacklog) {
                        workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
                    } else if (workItem instanceof IAgileSprint) {
                        workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Sprint);
                    } else if (workItem instanceof IAtsPeerToPeerReview) {
                        workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Review_PeerToPeer);
                    } else if (workItem instanceof IAtsDecisionReview) {
                        workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Review_Decision);
                    }
                }
            }
        }
        return workDef;
    }

    public WorkDefinition getWorkDefinitionForPeerToPeerReview(IAtsPeerToPeerReview review) {
        Conditions.notNull((Object[])new Object[]{review, AtsWorkDefinitionServiceImpl.class.getSimpleName()});
        WorkDefinition workDef = this.getWorkDefinitionFromArtifactsAttributeValue((IAtsWorkItem)review);
        if (workDef == null) {
            workDef = this.getDefaultPeerToPeerWorkflowDefinition();
        }
        return workDef;
    }

    public WorkDefinition getDefaultPeerToPeerWorkflowDefinition() {
        return this.getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Review_PeerToPeer);
    }

    public WorkDefinition getWorkDefinitionForPeerToPeerReviewNotYetCreated(IAtsTeamWorkflow teamWf) {
        Conditions.notNull((Object[])new Object[]{teamWf, AtsWorkDefinitionServiceImpl.class.getSimpleName()});
        IAtsTeamDefinition teamDefinition = teamWf.getTeamDefinition();
        WorkDefinition workDef = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(teamDefinition);
        if (workDef == null) {
            workDef = this.getDefaultPeerToPeerWorkflowDefinition();
        }
        return workDef;
    }

    public WorkDefinition getWorkDefinitionForPeerToPeerReviewNotYetCreatedAndStandalone(IAtsActionableItem actionableItem) {
        Conditions.notNull((Object[])new Object[]{actionableItem, AtsWorkDefinitionServiceImpl.class.getSimpleName()});
        WorkDefinition workDef = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(actionableItem.getAtsApi().getActionableItemService().getTeamDefinitionInherited(actionableItem));
        if (workDef == null) {
            workDef = this.getDefaultPeerToPeerWorkflowDefinition();
        }
        return workDef;
    }

    public WorkDefinition getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse(IAtsTeamDefinition teamDef) {
        TeamDefinition parentTeamDef;
        Conditions.notNull((Object[])new Object[]{teamDef, AtsWorkDefinitionServiceImpl.class.getSimpleName()});
        WorkDefinition workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference);
        if ((workDefinition == null || workDefinition.isInvalid()) && (parentTeamDef = this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef)) != null) {
            workDefinition = this.getPeerToPeerWorkDefinitionFromTeamDefinitionAttributeValueRecurse((IAtsTeamDefinition)parentTeamDef);
        }
        return workDefinition;
    }

    public List<StateDefinition> getStatesOrderedByOrdinal(WorkDefinition workDef) {
        ArrayList<StateDefinition> orderedPages = new ArrayList<StateDefinition>();
        ArrayList<StateDefinition> unOrderedPages = new ArrayList<StateDefinition>();
        int x = 1;
        while (x < workDef.getStates().size() + 1) {
            for (StateDefinition state : workDef.getStates()) {
                if (state.getOrdinal() == x) {
                    orderedPages.add(state);
                    continue;
                }
                if (state.getOrdinal() != 0 || unOrderedPages.contains(state)) continue;
                unOrderedPages.add(state);
            }
            ++x;
        }
        orderedPages.addAll(unOrderedPages);
        return orderedPages;
    }

    public List<WidgetDefinition> getWidgetsFromLayoutItems(StateDefinition stateDef) {
        ArrayList<WidgetDefinition> widgets = new ArrayList<WidgetDefinition>();
        AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, (List<LayoutItem>)stateDef.getLayoutItems());
        return widgets;
    }

    public List<WidgetDefinition> getWidgetsFromLayoutItems(StateDefinition stateDef, List<LayoutItem> layoutItems) {
        ArrayList<WidgetDefinition> widgets = new ArrayList<WidgetDefinition>();
        AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, layoutItems);
        return widgets;
    }

    private static void getWidgets(StateDefinition stateDef, List<WidgetDefinition> widgets, List<LayoutItem> layoutItems) {
        for (LayoutItem lItem : layoutItems) {
            if (lItem instanceof CompositeLayoutItem) {
                AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, (List<LayoutItem>)((CompositeLayoutItem)lItem).getLayoutItems());
                continue;
            }
            if (!(lItem instanceof WidgetDefinition)) continue;
            widgets.add((WidgetDefinition)lItem);
        }
    }

    private static void getWidgets(HeaderDefinition headerDef, List<WidgetDefinition> widgets, List<LayoutItem> layoutItems) {
        for (LayoutItem lItem : layoutItems) {
            if (lItem instanceof CompositeLayoutItem) {
                AtsWorkDefinitionServiceImpl.getWidgets(headerDef, widgets, (List<LayoutItem>)((CompositeLayoutItem)lItem).getLayoutItems());
                continue;
            }
            if (!(lItem instanceof WidgetDefinition)) continue;
            widgets.add((WidgetDefinition)lItem);
        }
    }

    public Collection<WidgetDefinition> getWidgets(WorkDefinition workDef) {
        ArrayList<WidgetDefinition> widgets = new ArrayList<WidgetDefinition>();
        AtsWorkDefinitionServiceImpl.getWidgets(workDef.getHeaderDef(), widgets, (List<LayoutItem>)workDef.getHeaderDef().getLayoutItems());
        for (StateDefinition stateDef : workDef.getStates()) {
            AtsWorkDefinitionServiceImpl.getWidgets(stateDef, widgets, (List<LayoutItem>)stateDef.getLayoutItems());
        }
        return widgets;
    }

    public boolean hasWidgetNamed(StateDefinition stateDef, String name) {
        for (WidgetDefinition widgetDef : this.getWidgetsFromLayoutItems(stateDef)) {
            if (!widgetDef.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getStateNames(WorkDefinition workDef) {
        return Named.getNames((Collection)workDef.getStates());
    }

    public WorkDefinition getWorkDefinition(Long id) {
        Conditions.assertTrue((id > 0L ? 1 : 0) != 0, (String)"Id must be > 0, not %s", (Object[])new Object[]{id});
        return this.atsApi.getWorkDefinitionProviderService().getWorkDefinition(id);
    }

    public StateDefinition getStateDefinitionByName(IAtsWorkItem workItem, String stateName) {
        return this.getWorkDefinition(workItem).getStateByName(stateName);
    }

    public Collection<String> computeAllValidStateNames() {
        HashSet<String> allValidStateNames = new HashSet<String>();
        for (WorkDefinition workDef : this.getAllWorkDefinitions()) {
            for (String stateName : this.getStateNames(workDef)) {
                if (allValidStateNames.contains(stateName)) continue;
                allValidStateNames.add(stateName);
            }
        }
        return allValidStateNames;
    }

    public Collection<String> getAllValidStateNamesFromConfig() {
        String stateNamesStr = this.atsApi.getConfigValue(VALID_STATE_NAMES_KEY);
        LinkedList<String> stateNames = new LinkedList<String>();
        if (Strings.isValid((String)stateNamesStr)) {
            String[] stringArray = stateNamesStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String stateName = stringArray[n2];
                stateNames.add(stateName);
                ++n2;
            }
        }
        return stateNames;
    }

    public Collection<String> updateAllValidStateNames() {
        Collection validStateNames = this.atsApi.getWorkDefinitionService().computeAllValidStateNames();
        this.atsApi.setConfigValue(VALID_STATE_NAMES_KEY, Collections.toString((String)",", (Iterable)validStateNames));
        return validStateNames;
    }

    public boolean teamDefHasRule(IAtsWorkItem workItem, RuleDefinitionOption option) {
        boolean hasRule = false;
        IAtsTeamWorkflow teamWf = null;
        try {
            if (workItem instanceof IAtsTeamWorkflow) {
                teamWf = (IAtsTeamWorkflow)workItem;
            } else if (workItem instanceof IAtsAbstractReview) {
                teamWf = ((IAtsAbstractReview)workItem).getParentTeamWorkflow();
            }
            if (teamWf != null) {
                hasRule = this.atsApi.getTeamDefinitionService().hasRule(teamWf.getTeamDefinition(), option.name());
            }
        }
        catch (Exception ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Error reading rule [%s] for workItem %s", new Object[]{option, workItem.toStringWithId()});
        }
        return hasRule;
    }

    public boolean isInState(IAtsWorkItem workItem, StateDefinition stateDef) {
        return workItem.getCurrentStateName().equals(stateDef.getName());
    }

    public Collection<WorkDefinition> getAllWorkDefinitions() {
        return this.atsApi.getWorkDefinitionProviderService().getAll();
    }

    public ArtifactToken getWorkDefArt(String workDefName) {
        return this.atsApi.getQueryService().getArtifactByName(AtsArtifactTypes.WorkDefinition, workDefName);
    }

    public WorkDefinition computeWorkDefinitionForTeamWfNotYetCreated(IAtsTeamDefinition teamDef, Collection<INewActionListener> newActionListeners) {
        AtsWorkDefinitionToken workDefTok;
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition can not be null", (Object[])new Object[0]);
        WorkDefinition workDefinition = null;
        if (newActionListeners != null) {
            for (INewActionListener listener : newActionListeners) {
                workDefTok = listener.getOverrideWorkDefinitionId(teamDef);
                if (workDefTok == null) continue;
                workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefTok);
                break;
            }
        }
        if (workDefinition == null) {
            for (ITeamWorkflowProvider provider : this.atsApi.getWorkItemService().getTeamWorkflowProviders().getProviders()) {
                workDefTok = provider.getOverrideWorkflowDefinitionId(teamDef);
                if (workDefTok == null) continue;
                workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefTok);
            }
        }
        if (workDefinition == null) {
            workDefinition = this.getWorkDefinitionForTeamWfFromTeamDef(teamDef);
        }
        if (workDefinition == null) {
            throw new OseeStateException("Work Definition not computed for %s", new Object[]{teamDef.toStringWithId()});
        }
        return workDefinition;
    }

    private WorkDefinition getWorkDefinitionForTeamWfFromTeamDef(IAtsTeamDefinition teamDef) {
        WorkDefinition workDefinition = this.getWorkDefinitionFromAsObject((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference);
        if (workDefinition != null && workDefinition.isValid()) {
            return workDefinition;
        }
        TeamDefinition parentTeamDef = this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef);
        if (parentTeamDef == null) {
            return this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        }
        return this.getWorkDefinitionForTeamWfFromTeamDef((IAtsTeamDefinition)parentTeamDef);
    }

    public void setWorkDefinitionAttrs(IAtsTeamDefinition teamDef, WorkDefinition workDefinition, IAtsChangeSet changes) {
        this.setWorkDefinitionAttrs((IAtsObject)teamDef, workDefinition, changes);
    }

    public void setWorkDefinitionAttrs(IAtsWorkItem workItem, WorkDefinition workDefinition, IAtsChangeSet changes) {
        this.setWorkDefinitionAttrs((IAtsObject)workItem, workDefinition, changes);
    }

    private void setWorkDefinitionAttrs(IAtsObject atsObject, WorkDefinition workDef, IAtsChangeSet changes) {
        Conditions.assertNotNull((Object)workDef, (String)"workDefArt", (Object[])new Object[0]);
        Conditions.assertNotSentinel((Id)workDef, (String)"workDefArt");
        changes.setSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)Id.valueOf((Long)workDef.getId()));
    }

    public void setWorkDefinitionAttrs(IAtsTeamDefinition topTeam, NamedIdBase id, IAtsChangeSet changes) {
        Conditions.assertNotNull((Object)topTeam, (String)"topTeam", (Object[])new Object[0]);
        Conditions.assertNotSentinel((Id)topTeam, (String)"topTeam");
        Conditions.assertNotNull((Object)id, (String)"id", (Object[])new Object[0]);
        Conditions.assertNotSentinel((Id)id, (String)"id");
        changes.setSoleAttributeValue((IAtsObject)topTeam, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)id);
    }

    public void setWorkDefinitionAttrs(IAtsTeamWorkflow teamWf, NamedIdBase id, IAtsChangeSet changes) {
        Conditions.assertNotNull((Object)teamWf, (String)"teamWf", (Object[])new Object[0]);
        Conditions.assertNotSentinel((Id)teamWf, (String)"teamWf");
        Conditions.assertNotNull((Object)id, (String)"id", (Object[])new Object[0]);
        Conditions.assertNotSentinel((Id)id, (String)"id");
        changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)id);
    }

    public void internalSetWorkDefinition(IAtsWorkItem workItem, WorkDefinition workDef) {
        this.bootstrappingWorkItemToWorkDefCache.put(workItem, workDef);
    }

    public void internalClearWorkDefinition(IAtsWorkItem workItem) {
        this.bootstrappingWorkItemToWorkDefCache.remove(workItem);
    }

    public void addWorkDefinition(IAtsWorkDefinitionBuilder workDefBuilder) {
        this.atsApi.getWorkDefinitionProviderService().addWorkDefinition(workDefBuilder.build());
    }

    public WorkDefinition getWorkDefinition(Id id) {
        return this.getWorkDefinition(id.getId());
    }

    public XResultData validateWorkDefinitions() {
        ValidateWorkDefinitionsOperation op = new ValidateWorkDefinitionsOperation(this.atsApi);
        return op.run();
    }
}

