/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class AtsVersionServiceImpl
implements IAtsVersionService {
    private final AtsApi atsApi;
    private final EventAdmin eventAdmin;

    public AtsVersionServiceImpl(AtsApi atsApi, EventAdmin eventAdmin) {
        this.atsApi = atsApi;
        this.eventAdmin = eventAdmin;
    }

    public Version getVersionById(IAtsVersion versionId) {
        Version version = null;
        version = versionId instanceof Version ? (Version)versionId : this.getVersionById((ArtifactId)versionId.getStoreObject());
        return version;
    }

    public Version getVersionById(ArtifactId versionId) {
        Version version = null;
        if (versionId instanceof Version) {
            version = (Version)versionId;
        }
        if (version == null) {
            version = (Version)this.atsApi.getConfigService().getConfigurations().getIdToVersion().get(versionId.getId());
        }
        if (version == null) {
            if (this.atsApi.isIde()) {
                version = this.atsApi.getServerEndpoints().getConfigEndpoint().getVersion(ArtifactId.valueOf((Long)versionId.getId()));
                version.setAtsApi(this.atsApi);
            } else {
                ArtifactToken verArt = this.atsApi.getQueryService().getArtifact(versionId);
                if (verArt.isValid()) {
                    Version version2 = this.createVersion(verArt);
                    this.atsApi.getConfigService().getConfigurations().addVersion(version2);
                    version = version2;
                }
            }
        }
        return version;
    }

    public Version createVersion(ArtifactToken verArt) {
        Version version = new Version(verArt, this.atsApi);
        version.setName(verArt.getName());
        version.setId(verArt.getId());
        version.setGuid(verArt.getGuid());
        version.setActive(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        version.setClosureState((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.ClosureState, (Object)""));
        version.setAllowCreateBranch(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.AllowCreateBranch, (Object)false)).booleanValue());
        version.setAllowCommitBranch(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.AllowCommitBranch, (Object)false)).booleanValue());
        version.setReleased(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.Released, (Object)false)).booleanValue());
        version.setLocked(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.VersionLocked, (Object)false)).booleanValue());
        version.setNextVersion(((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.NextVersion, (Object)false)).booleanValue());
        version.setBaselineBranch(BranchId.valueOf((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1"))));
        for (String workTypeStr : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.WorkType)) {
            WorkType workType = WorkType.valueOfOrNone((String)workTypeStr);
            if (!workType.isNotNone()) continue;
            version.getWorkTypes().add(workType);
        }
        version.getTags().addAll(this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)verArt, (AttributeTypeToken)CoreAttributeTypes.StaticId));
        return version;
    }

    public IAtsVersion getTargetedVersion(IAtsWorkItem workItem) {
        IAtsTeamWorkflow team;
        IAtsVersion version = null;
        if (workItem != null && (team = workItem.getParentTeamWorkflow()) != null) {
            version = this.getTargetedVersionByTeamWf(team);
        }
        return version;
    }

    public IAtsVersion getFoundInVersion(IAtsWorkItem workItem) {
        try {
            ArtifactToken artId = this.atsApi.getRelationResolver().getRelatedOrNull((IAtsObject)workItem, AtsRelationTypes.TeamWorkflowToFoundInVersion_Version);
            if (artId != null && artId.isValid()) {
                Version foundInVersion = this.getVersionById((ArtifactId)artId);
                return foundInVersion;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IAtsVersion getTargetedVersionByTeamWf(IAtsTeamWorkflow team) {
        if (team == null) {
            throw new OseeArgumentException("Team Workflow can not be null %s", new Object[]{team});
        }
        Collection versions = this.atsApi.getRelationResolver().getRelated((ArtifactId)team.getStoreObject(), AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        Version version = null;
        if (!versions.isEmpty()) {
            if (versions.size() > 1) {
                OseeLog.log(this.getClass(), (Level)Level.SEVERE, (String)("Multiple targeted versions for artifact " + team.toStringWithId()));
            } else {
                version = this.getVersionById((ArtifactId)versions.iterator().next());
            }
        }
        return version;
    }

    public void removeTargetedVersion(IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
        changes.unrelateAll((Object)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
    }

    public IAtsVersion setTargetedVersion(IAtsTeamWorkflow teamWf, IAtsVersion version, IAtsChangeSet changes) {
        Collection previousVersions = this.atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        ArtifactId previousVersion = ArtifactId.SENTINEL;
        if (!previousVersions.isEmpty()) {
            previousVersion = ArtifactId.create((Id)((Id)previousVersions.iterator().next()));
        }
        changes.setRelation((Object)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (Object)version);
        changes.addExecuteListener(this.getPostPersistExecutionListener(teamWf, version, previousVersion));
        return version;
    }

    protected IExecuteListener getPostPersistExecutionListener(final IAtsTeamWorkflow teamWf, final IAtsVersion newVersion, final ArtifactId previousVersion) {
        return new IExecuteListener(){

            public void changesStored(IAtsChangeSet changes) {
                try {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("workItemIds", teamWf.getIdString());
                    properties.put("atsVersionId", newVersion == null ? ArtifactId.SENTINEL.getIdString() : newVersion.getIdString());
                    properties.put("previousAtsVersionId", previousVersion.getIdString());
                    Event event = new Event("ats/workitem/targetedversion/modified", properties);
                    AtsVersionServiceImpl.this.eventAdmin.postEvent(event);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(this.getClass(), (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
    }

    public boolean isReleased(IAtsTeamWorkflow teamWf) {
        boolean released = false;
        IAtsVersion verArt = this.getTargetedVersion((IAtsWorkItem)teamWf);
        if (verArt != null) {
            released = verArt.isReleased();
        }
        return released;
    }

    public boolean isVersionLocked(IAtsTeamWorkflow teamWf) {
        boolean locked = false;
        IAtsVersion verArt = this.getTargetedVersion((IAtsWorkItem)teamWf);
        if (verArt != null) {
            locked = verArt.isLocked();
        }
        return locked;
    }

    public boolean hasTargetedVersion(IAtsWorkItem workItem) {
        return this.getTargetedVersion(workItem) != null;
    }

    public void setTeamDefinition(IAtsVersion version, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        if (!this.atsApi.getRelationResolver().areRelated((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, (IAtsObject)teamDef)) {
            changes.relate((Object)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, (Object)teamDef);
        }
    }

    public IAtsTeamDefinition getTeamDefinition(IAtsVersion version) {
        Version ver = this.getVersionById(version);
        TeamDefinition teamDef = null;
        if (ver.getTeamDefId() > 0L) {
            teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(ArtifactId.valueOf((Long)ver.getTeamDefId()));
        }
        return teamDef;
    }

    public Collection<IAtsTeamWorkflow> getTargetedForTeamWorkflows(IAtsVersion verArt) {
        LinkedList<IAtsTeamWorkflow> teamWorkflows = new LinkedList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow teamWf : this.atsApi.getRelationResolver().getRelated((IAtsObject)verArt, AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, IAtsTeamWorkflow.class)) {
            teamWorkflows.add(teamWf);
        }
        return teamWorkflows;
    }

    public BranchId getBranch(IAtsVersion version) {
        String branchId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"");
        if (branchId == null || branchId.isEmpty()) {
            return BranchId.SENTINEL;
        }
        return BranchId.valueOf((String)branchId);
    }

    public Version createVersion(IAtsProgram program, String versionName, IAtsChangeSet changes) {
        Version version = null;
        version = (Version)this.atsApi.getProgramService().getVersion(program, versionName);
        if (version == null) {
            version = this.getVersionById((ArtifactId)changes.createArtifact(AtsArtifactTypes.Version, versionName));
        }
        return version;
    }

    public IAtsVersion getVersion(IAtsProgram program, String versionName) {
        return this.atsApi.getProgramService().getVersion(program, versionName);
    }

    public Collection<IAtsVersion> getVersions(IAtsTeamDefinition teamDef) {
        return this.atsApi.getTeamDefinitionService().getVersions(teamDef);
    }

    public Version createVersion(String title, IAtsChangeSet changes) {
        return this.createVersion(title, Lib.generateArtifactIdAsInt(), changes);
    }

    public Version createVersion(String name, long id, IAtsChangeSet changes) {
        ArtifactToken verArt = changes.createArtifact(AtsArtifactTypes.Version, name, Long.valueOf(id));
        return this.createVersion(verArt);
    }

    public boolean isTeamUsesVersions(IAtsTeamDefinition teamDef) {
        return this.getTeamDefinitionHoldingVersions(teamDef) != null;
    }

    public IAtsVersion getNextReleaseVersion(IAtsTeamDefinition teamDef) {
        IAtsVersion result = null;
        for (IAtsVersion version : this.getVersions(teamDef)) {
            if (!version.isNextVersion()) continue;
            result = version;
            break;
        }
        return result;
    }

    public IAtsTeamDefinition getTeamDefinitionHoldingVersions(IAtsTeamDefinition teamDef) {
        IAtsTeamDefinition teamDefHoldVer = null;
        if (this.hasVersions(teamDef)) {
            teamDefHoldVer = teamDef;
        } else {
            TeamDefinition parentTda = this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef);
            if (parentTda != null) {
                teamDefHoldVer = this.getTeamDefinitionHoldingVersions((IAtsTeamDefinition)parentTda);
            }
        }
        return teamDefHoldVer;
    }

    public boolean hasVersions(IAtsTeamDefinition teamDef) {
        return !((TeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamDef.getId())).getVersions().isEmpty();
    }

    public IAtsVersion getVersion(IAtsTeamDefinition teamDef, String name) {
        IAtsVersion result = null;
        for (IAtsVersion version : this.getVersions(teamDef)) {
            if (!version.getName().equals(name)) continue;
            result = version;
            break;
        }
        return result;
    }

    public Collection<IAtsVersion> getVersions(IAtsTeamDefinition teamDef, VersionReleaseType releaseType, VersionLockedType lockedType) {
        return Collections.setIntersection(this.getVersionsReleased(teamDef, releaseType), this.getVersionsLocked(teamDef, lockedType));
    }

    public Collection<IAtsVersion> getVersionsFromTeamDefHoldingVersions(IAtsTeamDefinition teamDef, VersionReleaseType releaseType, VersionLockedType lockedType) {
        if (teamDef == null) {
            return new ArrayList<IAtsVersion>();
        }
        IAtsTeamDefinition teamDefHoldVer = this.getTeamDefinitionHoldingVersions(teamDef);
        return this.getVersions(teamDefHoldVer, releaseType, lockedType);
    }

    public Collection<IAtsVersion> getVersionsLocked(IAtsTeamDefinition teamDef, VersionLockedType lockType) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (IAtsVersion version : this.getVersions(teamDef)) {
            if (version.isLocked() && (lockType == VersionLockedType.Locked || lockType == VersionLockedType.Both)) {
                versions.add(version);
                continue;
            }
            if ((version.isLocked() || lockType != VersionLockedType.UnLocked) && lockType != VersionLockedType.Both) continue;
            versions.add(version);
        }
        return versions;
    }

    public Collection<IAtsVersion> getVersionsReleased(IAtsTeamDefinition teamDef, VersionReleaseType releaseType) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (IAtsVersion version : this.getVersions(teamDef)) {
            if (version.isReleased() && (releaseType == VersionReleaseType.Released || releaseType == VersionReleaseType.Both)) {
                versions.add(version);
                continue;
            }
            if ((version.isReleased() || releaseType != VersionReleaseType.UnReleased) && releaseType != VersionReleaseType.Both) continue;
            versions.add(version);
        }
        return versions;
    }

    public Collection<IAtsVersion> getVersionsFromTeamDefHoldingVersions(IAtsTeamDefinition teamDef) {
        IAtsTeamDefinition teamDefHoldVer = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef);
        return this.getVersions(teamDefHoldVer);
    }

    public BranchId getBaselineBranchIdInherited(IAtsVersion version) {
        if (version.getBaselineBranch().isValid()) {
            return version.getBaselineBranch();
        }
        try {
            IAtsTeamDefinition teamDef = this.getTeamDefinition(version);
            if (teamDef != null) {
                return this.atsApi.getTeamDefinitionService().getTeamBranchId(teamDef);
            }
            return BranchId.SENTINEL;
        }
        catch (OseeCoreException oseeCoreException) {
            return BranchId.SENTINEL;
        }
    }

    public Result isAllowCommitBranchInherited(IAtsVersion version) {
        if (!version.isAllowCommitBranch()) {
            return new Result(false, "Version [" + this + "] not configured to allow branch commit.");
        }
        if (version.isInvalid()) {
            return new Result(false, "Parent Branch not configured for Version [" + this + "]");
        }
        return Result.TrueResult;
    }

    public Date getEstimatedReleaseDate(IAtsVersion version) {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.EstimatedReleaseDate, null);
    }

    public Date getReleaseDate(IAtsVersion version) {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.ReleaseDate, null);
    }

    public Result isAllowCreateBranchInherited(IAtsVersion version) {
        if (!version.isAllowCreateBranch()) {
            return new Result(false, "Branch creation disabled for Version [" + this + "]");
        }
        if (version.isBranchInvalid()) {
            return new Result(false, "Parent Branch not configured for Version [" + this + "]");
        }
        return Result.TrueResult;
    }

    public String getTargetedVersionStr(IAtsWorkItem workItem, IAtsVersionService versionService) {
        IAtsVersion version;
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        if (teamWf != null && (version = versionService.getTargetedVersion((IAtsWorkItem)teamWf)) != null) {
            if (!teamWf.getCurrentStateType().isCompletedOrCancelled() && versionService.isReleased(teamWf)) {
                String errStr = "Workflow " + teamWf.getAtsId() + " targeted for released version, but not completed: " + version;
                return "!Error " + errStr;
            }
            return version.getName();
        }
        return "";
    }

    public List<IAtsVersion> getParallelVersions(IAtsVersion version) {
        ArrayList<IAtsVersion> parallelVersions = new ArrayList<IAtsVersion>();
        for (ArtifactId parallelVersion : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact((IAtsObject)version), AtsRelationTypes.ParallelVersion_Child)) {
            Version parallelVer = this.getVersionById(parallelVersion);
            parallelVersions.add((IAtsVersion)parallelVer);
        }
        return parallelVersions;
    }

    public void getParallelVersions(IAtsVersion version, Set<CommitConfigItem> configItems) {
        configItems.add(new CommitConfigItem(version, this.atsApi));
        for (IAtsVersion pVersion : this.getParallelVersions(version)) {
            if (configItems.contains(new CommitConfigItem(pVersion, this.atsApi))) continue;
            this.getParallelVersions(pVersion, configItems);
        }
    }
}

