/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.util.RecentlyVisistedItem;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class RecentlyVisitedItems {
    public List<RecentlyVisistedItem> visited = new ArrayList<RecentlyVisistedItem>();
    private static String RECENTLY_VISITED_COUNT = "recentlyVisitedCount";
    private final int defaultRecentlyVisitedCount = 20;
    private Integer recentlyVisitedCount = null;

    @JsonIgnore
    public List<RecentlyVisistedItem> getReverseVisited() {
        ArrayList<RecentlyVisistedItem> revItems = new ArrayList<RecentlyVisistedItem>();
        int x = this.visited.size() - 1;
        while (x >= 0) {
            RecentlyVisistedItem item = this.visited.get(x);
            revItems.add(item);
            --x;
        }
        return revItems;
    }

    public void addVisited(IAtsWorkItem workItem) {
        RecentlyVisistedItem item = RecentlyVisistedItem.valueOf(workItem.getArtifactToken(), workItem.getArtifactType());
        this.visited.remove(item);
        this.visited.add(item);
        if (this.visited.size() > this.getRecentlyVisitedCount()) {
            int x = this.getRecentlyVisitedCount() - 1;
            while (x < this.getRecentlyVisitedCount()) {
                this.visited.remove(0);
                ++x;
            }
        }
    }

    public void clearVisited() {
        if (this.visited != null) {
            this.visited.clear();
        }
    }

    @JsonIgnore
    private int getRecentlyVisitedCount() {
        if (this.recentlyVisitedCount == null) {
            String recentlyVisitedCountStr;
            this.recentlyVisitedCount = 20;
            if (AtsApiService.get() != null && Strings.isNumeric((String)(recentlyVisitedCountStr = AtsApiService.get().getConfigValue(RECENTLY_VISITED_COUNT)))) {
                this.recentlyVisitedCount = Integer.valueOf(recentlyVisitedCountStr);
            }
        }
        return this.recentlyVisitedCount;
    }
}

