/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.task.CreateChangeReportTasksOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class CreateChangeReportTaskCommitHook
implements IAtsWorkItemHook {
    private final AtsTaskDefToken taskDefToken;

    public CreateChangeReportTaskCommitHook(AtsTaskDefToken taskDefToken) {
        this.taskDefToken = taskDefToken;
    }

    public void committed(final IAtsTeamWorkflow teamWf, XResultData rd) {
        final AtsApi atsApi = AtsApiService.get();
        if (teamWf.getTags().contains("finalTaskgen")) {
            rd.log("Final Task Generation has already been run.");
            return;
        }
        Collection branchesCommittedTo = atsApi.getBranchService().getBranchesCommittedTo(teamWf);
        if (branchesCommittedTo.size() != 1) {
            return;
        }
        Thread thread = new Thread("Create/Update Tasks on Commit"){

            @Override
            public void run() {
                IAtsChangeSet changes;
                ChangeReportTaskData data;
                CreateTasksDefinitionBuilder taskSetDefinition = AtsApiService.get().getTaskSetDefinitionProviderService().getTaskSetDefinition(CreateChangeReportTaskCommitHook.this.taskDefToken);
                if (taskSetDefinition != null && taskSetDefinition.getCreateTasksDef().getHelper().isApplicable((IAtsWorkItem)teamWf, AtsApiService.get()) && (data = CreateChangeReportTaskCommitHook.runChangeReportTaskOperation((IAtsWorkItem)teamWf, CreateChangeReportTaskCommitHook.this.taskDefToken, true, changes = atsApi.createChangeSet(this.getName()), atsApi.getUserService().getCurrentUser())).getResults().isErrors()) {
                    throw new OseeArgumentException(data.getResults().toString(), new Object[0]);
                }
            }
        };
        if (AtsUtil.isInTest()) {
            thread.run();
        } else {
            thread.start();
        }
    }

    public static ChangeReportTaskData runChangeReportTaskOperation(IAtsWorkItem workItem, AtsTaskDefToken taskDefToken, boolean finalTaskGen, IAtsChangeSet changes, AtsUser asUser) {
        ChangeReportTaskData data = new ChangeReportTaskData();
        data.setTaskDefToken(taskDefToken);
        data.setHostTeamWf(workItem.getStoreObject());
        data.setAsUser(asUser);
        data.setFinalTaskGen(finalTaskGen);
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(data, AtsApiService.get(), changes);
        operation.run();
        return data;
    }

    public String getDescription() {
        return "Checks for and runs Change Report Task Set Definitions after first commit";
    }
}

