/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewDefectManager;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsReviewHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.review.DecisionReview;
import org.eclipse.osee.ats.core.review.PeerToPeerReview;
import org.eclipse.osee.ats.core.review.UserRoleManager;
import org.eclipse.osee.ats.core.workdef.SimpleDecisionReviewOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsReviewServiceImpl
implements IAtsReviewService {
    private final AtsApi atsApi;
    private static final String VALIDATE_REVIEW_TITLE = "Is the resolution of this Action valid?";
    private static Set<IAtsReviewHook> reviewHooks = new HashSet<IAtsReviewHook>();

    public void addReviewHook(IAtsReviewHook hook) {
        reviewHooks.add(hook);
    }

    public AtsReviewServiceImpl() {
        this(null);
    }

    public AtsReviewServiceImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public boolean isValidationReviewRequired(IAtsWorkItem workItem) {
        boolean required = false;
        if (workItem.isTeamWorkflow()) {
            required = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)false);
        }
        return required;
    }

    public IAtsDecisionReview createValidateReview(IAtsTeamWorkflow teamWf, boolean force, Date transitionDate, AtsUser transitionUser, IAtsChangeSet changes) {
        if (!force && !AtsReviewServiceImpl.isValidatePage(teamWf.getStateDefinition())) {
            return null;
        }
        if (!force && this.getReviewsFromCurrentState(teamWf).size() > 0) {
            for (IAtsAbstractReview review : this.getReviewsFromCurrentState(teamWf)) {
                if (!review.getName().equals(VALIDATE_REVIEW_TITLE)) continue;
                return null;
            }
        }
        try {
            IAtsDecisionReview decRev = this.createNewDecisionReview(teamWf, this.isValidateReviewBlocking(teamWf.getStateDefinition()) ? ReviewBlockType.Transition : ReviewBlockType.None, true, new Date(), this.atsApi.getUserService().getCurrentUser(), changes);
            changes.setName((IAtsObject)decRev, VALIDATE_REVIEW_TITLE);
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeToken)AtsAttributeTypes.DecisionReviewOptions, "No;Followup;" + this.getValidateReviewFollowupUsersStr(teamWf) + "\n" + "Yes;Completed;");
            TransitionHelper helper = new TransitionHelper("Transition to Decision", Arrays.asList(decRev), DecisionReviewState.Decision.getName(), Arrays.asList(teamWf.getCreatedBy()), null, changes, this.atsApi, TransitionOption.None);
            TransitionManager transitionMgr = new TransitionManager(helper);
            TransitionResults results = transitionMgr.handleAll();
            if (!results.isEmpty()) {
                OseeLog.logf(AtsReviewServiceImpl.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error transitioning Decision review [%s] to Decision %s", (Object[])new Object[]{decRev.toStringWithId(), results});
            }
            return decRev;
        }
        catch (Exception ex) {
            OseeLog.log(AtsReviewServiceImpl.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return null;
        }
    }

    public String getValidateReviewFollowupUsersStr(IAtsTeamWorkflow teamWf) {
        try {
            Collection<AtsUser> users = this.getValidateReviewFollowupUsers(teamWf);
            return this.atsApi.getWorkStateFactory().getStorageString(users);
        }
        catch (Exception ex) {
            OseeLog.log(AtsReviewServiceImpl.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    public boolean isValidateReviewBlocking(StateDefinition stateDefinition) {
        return stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateBlockingReview.name());
    }

    public Collection<AtsUser> getValidateReviewFollowupUsers(IAtsTeamWorkflow teamWf) {
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        users.addAll(teamWf.getStateMgr().getAssignees((IStateToken)TeamState.Implement));
        if (users.size() > 0) {
            return users;
        }
        users.addAll(this.atsApi.getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
        return users;
    }

    public IAtsDecisionReview createNewDecisionReviewAndTransitionToDecision(IAtsTeamWorkflow teamWf, String reviewTitle, String description, String againstState, ReviewBlockType reviewBlockType, Collection<IAtsDecisionReviewOption> options, List<AtsUser> assignees, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        IAtsDecisionReview decRev = this.createNewDecisionReview(teamWf, reviewBlockType, reviewTitle, againstState, description, options, assignees, createdDate, createdBy, changes);
        changes.add((Object)decRev);
        TransitionHelper helper = new TransitionHelper("Transition to Decision", Arrays.asList(decRev), DecisionReviewState.Decision.getName(), assignees, null, changes, this.atsApi, TransitionOption.OverrideAssigneeCheck);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleAll();
        if (!results.isEmpty()) {
            throw new OseeStateException("Error auto-transitioning review %s to Decision state. Results [%s]", new Object[]{decRev.toStringWithId(), results.toString()});
        }
        decRev.getStateMgr().setAssignees(assignees);
        changes.add((Object)decRev);
        return decRev;
    }

    public IAtsDecisionReview createNewDecisionReview(IAtsTeamWorkflow teamWf, ReviewBlockType reviewBlockType, boolean againstCurrentState, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        return this.createNewDecisionReview(teamWf, reviewBlockType, "Should we do this?  Yes will require followup, No will not", againstCurrentState ? teamWf.getCurrentStateName() : null, "Enter description of the decision, if any", this.getDefaultDecisionReviewOptions(), null, createdDate, createdBy, changes);
    }

    public IAtsDecisionReview createNewDecisionReview(IAtsTeamWorkflow teamWf, ReviewBlockType reviewBlockType, String title, String relatedToState, String description, Collection<IAtsDecisionReviewOption> options, List<? extends AtsUser> assignees, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        ArtifactToken decRevArt = changes.createArtifact(AtsArtifactTypes.DecisionReview, title);
        IAtsDecisionReview decRev = (IAtsDecisionReview)this.atsApi.getWorkItemService().getReview(decRevArt);
        changes.relate((Object)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, (Object)decRev);
        this.atsApi.getActionService().setAtsId((IAtsObject)decRev, decRev.getParentTeamWorkflow().getTeamDefinition(), null, changes);
        WorkDefinition workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Review_Decision);
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)decRev, workDefinition, changes);
        this.atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)decRev, null, createdDate, createdBy, workDefinition, changes);
        decRev.getStateMgr().setAssignees(workDefinition.getStartState().getName(), StateType.Working, assignees);
        if (Strings.isValid((String)relatedToState)) {
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, relatedToState);
        }
        if (Strings.isValid((String)description)) {
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeToken)AtsAttributeTypes.Description, description);
        }
        changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeToken)AtsAttributeTypes.DecisionReviewOptions, this.getDecisionReviewOptionsString(options));
        if (reviewBlockType != null) {
            changes.setSoleAttributeFromString((IAtsObject)decRev, (AttributeTypeGeneric)AtsAttributeTypes.ReviewBlocks, reviewBlockType.name());
        }
        changes.add((Object)decRev);
        return decRev;
    }

    public String getDecisionReviewOptionsString(Collection<IAtsDecisionReviewOption> options) {
        StringBuffer sb = new StringBuffer();
        for (IAtsDecisionReviewOption opt : options) {
            sb.append(opt.getName());
            sb.append(";");
            sb.append(opt.isFollowupRequired() ? "Followup" : "Completed");
            sb.append(";");
            for (String userId : opt.getUserIds()) {
                sb.append("<" + userId + ">");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isValidatePage(StateDefinition stateDefinition) {
        if (stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateBlockingReview.name())) {
            return true;
        }
        return stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateNonBlockingReview.name());
    }

    public List<IAtsDecisionReviewOption> getDefaultDecisionReviewOptions() {
        ArrayList<IAtsDecisionReviewOption> options = new ArrayList<IAtsDecisionReviewOption>();
        options.add(new SimpleDecisionReviewOption("Yes", true, Arrays.asList(this.atsApi.getUserService().getCurrentUser().getUserId())));
        options.add(new SimpleDecisionReviewOption("No", false, null));
        return options;
    }

    public Collection<IAtsAbstractReview> getReviewsFromCurrentState(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getWorkItemService().getReviews(teamWf, teamWf.getStateMgr().getCurrentState());
    }

    public ReviewBlockType getReviewBlockType(IAtsAbstractReview review) {
        String blockStr = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
        return ReviewBlockType.valueOf((String)blockStr);
    }

    public boolean isStandAloneReview(Object obj) {
        if (obj instanceof IAtsPeerToPeerReview) {
            return this.atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)((IAtsPeerToPeerReview)obj), (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference) > 0;
        }
        return false;
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf) {
        ArrayList<IAtsAbstractReview> reviews = new ArrayList<IAtsAbstractReview>();
        for (ArtifactToken reviewArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review)) {
            reviews.add(this.atsApi.getWorkItemService().getReview(reviewArt));
        }
        return reviews;
    }

    public IAtsPeerReviewRoleManager createPeerReviewRoleManager(IAtsPeerToPeerReview peerRev) {
        return new UserRoleManager(peerRev, this.atsApi);
    }

    public boolean hasReviews(IAtsTeamWorkflow teamWf) {
        return !this.getReviews(teamWf).isEmpty();
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf, IStateToken state) {
        HashSet<IAtsAbstractReview> reviews = new HashSet<IAtsAbstractReview>();
        for (IAtsAbstractReview review : this.getReviews(teamWf)) {
            if (!((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)review, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)"")).equals(state.getName())) continue;
            reviews.add(review);
        }
        return reviews;
    }

    public String getDefaultPeerReviewTitle(IAtsTeamWorkflow teamWf) {
        return "Review \"" + teamWf.getArtifactTypeName() + "\" titled \"" + teamWf.getName() + "\"";
    }

    public IAtsPeerToPeerReview createNewPeerToPeerReview(IAtsTeamWorkflow teamWf, String reviewTitle, String againstState, IAtsChangeSet changes) {
        return this.createNewPeerToPeerReview(teamWf, reviewTitle, againstState, new Date(), this.atsApi.getUserService().getCurrentUser(), changes);
    }

    public IAtsPeerToPeerReview createNewPeerToPeerReview(WorkDefinition workDefinition, IAtsTeamWorkflow teamWf, String reviewTitle, String againstState, IAtsChangeSet changes) {
        return this.createNewPeerToPeerReview(workDefinition, teamWf, teamWf.getTeamDefinition(), reviewTitle, againstState, new Date(), this.atsApi.getUserService().getCurrentUser(), changes);
    }

    public IAtsPeerToPeerReview createNewPeerToPeerReview(IAtsTeamWorkflow teamWF, String reviewTitle, String againstState, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        return this.createNewPeerToPeerReview(this.atsApi.getWorkDefinitionService().getWorkDefinitionForPeerToPeerReviewNotYetCreated(teamWF), teamWF, teamWF.getTeamDefinition(), reviewTitle, againstState, createdDate, createdBy, changes);
    }

    public IAtsPeerToPeerReview createNewPeerToPeerReview(IAtsActionableItem actionableItem, String reviewTitle, String againstState, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        IAtsTeamDefinition teamDef = actionableItem.getAtsApi().getActionableItemService().getTeamDefinitionInherited(actionableItem);
        WorkDefinition workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinitionForPeerToPeerReviewNotYetCreatedAndStandalone(actionableItem);
        IAtsPeerToPeerReview peerArt = this.createNewPeerToPeerReview(workDefinition, null, teamDef, reviewTitle, againstState, createdDate, createdBy, changes);
        this.atsApi.getActionableItemService().addActionableItem((IAtsWorkItem)peerArt, actionableItem, changes);
        return peerArt;
    }

    private IAtsPeerToPeerReview createNewPeerToPeerReview(WorkDefinition workDefinition, IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, String reviewTitle, String againstState, Date createdDate, AtsUser createdBy, IAtsChangeSet changes) {
        Conditions.assertNotNull((Object)workDefinition, (String)"WorkDefinition", (Object[])new Object[0]);
        ArtifactTypeToken reviewArtType = workDefinition.getArtType();
        IAtsPeerToPeerReview peerRev = (IAtsPeerToPeerReview)changes.createArtifact(reviewArtType, reviewTitle == null ? "Peer to Peer Review" : reviewTitle);
        if (teamWf != null) {
            changes.relate((Object)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, (Object)peerRev);
        }
        this.atsApi.getActionService().setAtsId((IAtsObject)peerRev, teamDef, null, changes);
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)peerRev, workDefinition, changes);
        this.atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)peerRev, null, createdDate, createdBy, workDefinition, changes);
        if (teamWf != null && againstState != null) {
            changes.setSoleAttributeValue((IAtsWorkItem)peerRev, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, againstState);
        }
        changes.setSoleAttributeValue((IAtsWorkItem)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
        changes.add((Object)peerRev);
        return peerRev;
    }

    public Set<IAtsReviewHook> getReviewHooks() {
        return reviewHooks;
    }

    public Result transitionDecisionTo(IAtsDecisionReview decRev, DecisionReviewState toState, AtsUser user, boolean popup, IAtsChangeSet changes) {
        Result result = Result.TrueResult;
        if (decRev.isInState((IStateToken)DecisionReviewState.Prepare)) {
            result = this.setDecisionPrepareStateData(popup, decRev, 100, 3.0, 0.2, changes);
            if (result.isFalse()) {
                return result;
            }
            result = this.transitionDecisionToState(toState.getStateType(), popup, (IStateToken)DecisionReviewState.Decision, decRev, user, changes);
            if (result.isFalse()) {
                return result;
            }
        }
        if (toState == DecisionReviewState.Decision) {
            return Result.TrueResult;
        }
        boolean decision = toState != DecisionReviewState.Followup;
        result = this.setDecisionStateData(popup, decRev, decision, 100, 0.2, changes);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionDecisionToState(toState.getStateType(), popup, (IStateToken)toState, decRev, user, changes);
        if (result.isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    public Result setDecisionPrepareStateData(boolean popup, IAtsDecisionReview decRev, int statePercentComplete, double estimateHours, double stateHoursSpent, IAtsChangeSet changes) {
        Result result;
        if (!decRev.isInState((IStateToken)DecisionReviewState.Prepare) && (result = new Result("Action not in Prepare state")).isFalse() && popup) {
            return result;
        }
        changes.setSoleAttributeValue((IAtsObject)decRev, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)estimateHours);
        AtsApiService.get().getWorkItemMetricsService().updateMetrics((IAtsWorkItem)decRev, (IStateToken)decRev.getStateDefinition(), stateHoursSpent, statePercentComplete, true, this.atsApi.getUserService().getCurrentUser(), changes);
        return Result.TrueResult;
    }

    public Result transitionDecisionToState(StateType StateType2, boolean popup, IStateToken toState, IAtsDecisionReview decRev, AtsUser user, IAtsChangeSet changes) {
        TransitionHelper helper = new TransitionHelper("Transition to " + toState.getName(), Arrays.asList(decRev), toState.getName(), Arrays.asList(user == null ? (AtsUser)decRev.getStateMgr().getAssignees().iterator().next() : user), null, changes, this.atsApi, TransitionOption.OverrideAssigneeCheck);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleAll();
        if (results.isEmpty()) {
            return Result.TrueResult;
        }
        return new Result("Transition Error %s", new Object[]{results.toString()});
    }

    public Result setDecisionStateData(boolean popup, IAtsDecisionReview decRev, boolean decision, int statePercentComplete, double stateHoursSpent, IAtsChangeSet changes) {
        Result result;
        if (!decRev.isInState((IStateToken)DecisionReviewState.Decision) && (result = new Result("Action not in Decision state")).isFalse() && popup) {
            return result;
        }
        changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeToken)AtsAttributeTypes.Decision, decision ? "Yes" : "No");
        AtsApiService.get().getWorkItemMetricsService().updateMetrics((IAtsWorkItem)decRev, (IStateToken)decRev.getStateDefinition(), stateHoursSpent, statePercentComplete, true, this.atsApi.getUserService().getCurrentUser(), changes);
        return Result.TrueResult;
    }

    public String getDefaultReviewTitle(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getReviewService().getDefaultPeerReviewTitle(teamWf);
    }

    public Result transitionTo(IAtsPeerToPeerReview peerRev, PeerToPeerReviewState toState, Collection<UserRole> roles, Collection<ReviewDefectItem> defects, AtsUser user, boolean popup, IAtsChangeSet changes) {
        Result result = this.setPrepareStateData(popup, peerRev, roles, "DoThis.java", 100, 0.2, changes);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionToState(PeerToPeerReviewState.Review.getStateType(), popup, peerRev, (IStateToken)PeerToPeerReviewState.Review, changes);
        if (result.isFalse()) {
            return result;
        }
        if (toState == PeerToPeerReviewState.Review) {
            return Result.TrueResult;
        }
        result = this.setReviewStateData(peerRev, roles, defects, 100, 0.2, changes);
        if (result.isFalse()) {
            return result;
        }
        result = this.transitionToState(PeerToPeerReviewState.Completed.getStateType(), popup, peerRev, (IStateToken)PeerToPeerReviewState.Completed, changes);
        if (result.isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    private Result transitionToState(StateType StateType2, boolean popup, IAtsPeerToPeerReview peerRev, IStateToken toState, IAtsChangeSet changes) {
        TransitionHelper helper = new TransitionHelper("Transition to " + toState.getName(), Arrays.asList(peerRev), toState.getName(), Arrays.asList((AtsUser)peerRev.getStateMgr().getAssignees().iterator().next()), null, changes, this.atsApi, TransitionOption.OverrideAssigneeCheck);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleAll();
        if (results.isEmpty()) {
            return Result.TrueResult;
        }
        return new Result("Error transitioning [%s]", new Object[]{results});
    }

    public Result setPrepareStateData(boolean popup, IAtsPeerToPeerReview peerRev, Collection<UserRole> roles, String reviewMaterials, int statePercentComplete, double stateHoursSpent, IAtsChangeSet changes) {
        Result result;
        if (!peerRev.isInState((IStateToken)PeerToPeerReviewState.Prepare) && (result = new Result("Action not in Prepare state")).isFalse() && popup) {
            return result;
        }
        if (roles != null) {
            IAtsPeerReviewRoleManager roleMgr = peerRev.getRoleManager();
            for (UserRole role : roles) {
                roleMgr.addOrUpdateUserRole(role);
            }
            roleMgr.saveToArtifact(changes);
        }
        changes.setSoleAttributeValue((IAtsWorkItem)peerRev, (AttributeTypeToken)AtsAttributeTypes.Location, reviewMaterials);
        changes.setSoleAttributeValue((IAtsWorkItem)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewFormalType, ReviewFormalType.InFormal.name());
        AtsApiService.get().getWorkItemMetricsService().updateMetrics((IAtsWorkItem)peerRev, (IStateToken)peerRev.getStateDefinition(), stateHoursSpent, statePercentComplete, true, this.atsApi.getUserService().getCurrentUser(), changes);
        return Result.TrueResult;
    }

    public Result setReviewStateData(IAtsPeerToPeerReview peerRev, Collection<UserRole> roles, Collection<ReviewDefectItem> defects, int statePercentComplete, double stateHoursSpent, IAtsChangeSet changes) {
        if (roles != null) {
            IAtsPeerReviewRoleManager roleMgr = peerRev.getRoleManager();
            for (UserRole role : roles) {
                roleMgr.addOrUpdateUserRole(role);
            }
            roleMgr.saveToArtifact(changes);
        }
        if (defects != null) {
            IAtsPeerReviewDefectManager defectManager = peerRev.getDefectManager();
            for (ReviewDefectItem defect : defects) {
                defectManager.addOrUpdateDefectItem(defect);
            }
            defectManager.saveToArtifact(peerRev, changes);
        }
        AtsApiService.get().getWorkItemMetricsService().updateMetrics((IAtsWorkItem)peerRev, (IStateToken)peerRev.getStateDefinition(), stateHoursSpent, statePercentComplete, true, this.atsApi.getUserService().getCurrentUser(), changes);
        return Result.TrueResult;
    }

    public ReviewDefectItem getDefectItem(String xml, IAtsPeerToPeerReview review) {
        return new ReviewDefectItem(xml, false, review);
    }

    public IAtsAbstractReview getReview(ArtifactToken artifact) {
        IAtsAbstractReview review = null;
        if (artifact instanceof IAtsAbstractReview) {
            review = (IAtsAbstractReview)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview})) {
            review = new PeerToPeerReview(this.atsApi.getLogger(), this.atsApi, artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview})) {
            review = new DecisionReview(this.atsApi.getLogger(), this.atsApi, artifact);
        } else {
            throw new OseeArgumentException("Artifact %s must be of type Review", new Object[]{artifact.toStringWithId()});
        }
        return review;
    }
}

