/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.query.ISearchCriteriaProvider;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.query.AtsSearchDataSearch;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public abstract class AbstractAtsQueryService
implements IAtsQueryService {
    protected final JdbcClient jdbcClient;
    private final AtsApi atsApi;
    private static String ATTR_QUERY = "SELECT art.art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr WHERE txs.branch_id = ? and art.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND attr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = ? and attr.VALUE = ?";
    private static String ATTR_EXISTS_QUERY = "SELECT unique art.art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr WHERE txs.branch_id = ? and art.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND attr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = ?";

    public AbstractAtsQueryService(JdbcService jdbcService, AtsApi atsApi) {
        this.jdbcClient = jdbcService.getClient();
        this.atsApi = atsApi;
    }

    public Collection<IAtsWorkItem> getWorkItemsFromQuery(String query, Object ... data) {
        LinkedList ids = new LinkedList();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = ids.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        }, query, data);
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(ids, (BranchId)this.atsApi.getAtsBranch())) {
            IAtsWorkItem workItem;
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) || (workItem = this.atsApi.getWorkItemService().getWorkItem(art)) == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public List<Map<String, String>> query(String query, Object ... data) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>(10);
        try (JdbcStatement stmt = this.jdbcClient.getStatement();){
            stmt.runPreparedQuery(query, data);
            while (stmt.next()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                int x = 1;
                while (x <= stmt.getColumnCount()) {
                    String colName = stmt.getColumnName(x);
                    String val = stmt.getString(colName);
                    rowMap.put(colName, val);
                    ++x;
                }
                rows.add(rowMap);
            }
        }
        return rows;
    }

    public Collection<ArtifactToken> getArtifactsFromQuery(String query, Object ... data) {
        LinkedList ids = new LinkedList();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = ids.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        }, query, data);
        return this.atsApi.getQueryService().getArtifacts(ids, (BranchId)this.atsApi.getAtsBranch());
    }

    public List<ArtifactId> getArtifactIdsFromQuery(String query, Object ... data) {
        LinkedList<ArtifactId> ids = new LinkedList<ArtifactId>();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = ids.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        }, query, data);
        return ids;
    }

    public ArtifactToken getArtifactTokenOrSentinal(ArtifactId artifactId) {
        return this.getArtifactToken(artifactId);
    }

    public void runUpdate(String query, Object ... data) {
        this.jdbcClient.runPreparedUpdate(query, data);
    }

    public List<IAtsWorkItem> getWorkItemsByIds(String ids) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (ArtifactToken art : this.getArtifactsByIds(ids)) {
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public List<ArtifactToken> getArtifactsByIds(String ids) {
        ArrayList<ArtifactToken> actions = new ArrayList<ArtifactToken>();
        for (String id : this.getIdsFromStr(ids)) {
            ArtifactToken action = this.getArtifactById(id);
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    public IAtsWorkItem getWorkItem(String id) {
        ArtifactToken workItemArt = this.getArtifactById(id);
        if (workItemArt == null) {
            throw new OseeArgumentException("workItem can not be found for id " + id, new Object[0]);
        }
        return this.atsApi.getWorkItemService().getWorkItem(workItemArt);
    }

    public IAtsWorkItem getWorkItemByAtsId(String atsId) {
        ArtifactToken workItemArt = this.getArtifactByAtsId(atsId);
        if (workItemArt == null) {
            throw new OseeArgumentException("workItem can not be found for id " + atsId, new Object[0]);
        }
        return this.atsApi.getWorkItemService().getWorkItem(workItemArt);
    }

    public ArtifactToken getArtifactById(String id) {
        ArtifactToken result = null;
        if (Strings.isNumeric((String)id)) {
            result = this.getArtifact(Long.valueOf(id));
        }
        if (result == null) {
            result = this.getArtifactByAtsId(id);
        }
        return result;
    }

    public ArtifactToken getArtifactByAtsId(String id) {
        ArtifactToken artifact = null;
        try {
            Collection<ArtifactToken> workItems = this.getArtifactsFromQuery(ATTR_QUERY, this.atsApi.getAtsBranch(), AtsAttributeTypes.AtsId, id);
            if (!workItems.isEmpty()) {
                artifact = workItems.iterator().next();
            }
        }
        catch (ItemDoesNotExist itemDoesNotExist) {}
        return artifact;
    }

    public ArtifactToken getArtifactByLegacyPcrId(String id) {
        try {
            Collection<ArtifactToken> workItems = this.getArtifactsFromQuery(ATTR_QUERY, this.atsApi.getAtsBranch(), AtsAttributeTypes.LegacyPcrId, id);
            if (workItems.size() == 1) {
                return workItems.iterator().next();
            }
            if (workItems.size() > 1) {
                throw new OseeStateException("More than 1 artifact exists with legacy id [%s]", new Object[]{id});
            }
        }
        catch (ItemDoesNotExist itemDoesNotExist) {}
        return null;
    }

    public Collection<ArtifactToken> getArtifactsByLegacyPcrId(String id) {
        return this.getArtifactsFromQuery(ATTR_QUERY, this.atsApi.getAtsBranch(), AtsAttributeTypes.LegacyPcrId, id);
    }

    public Collection<IAtsWorkItem> getWorkItemsByLegacyPcrId(String id) {
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken art : this.getArtifactsFromQuery(ATTR_QUERY, this.atsApi.getAtsBranch(), AtsAttributeTypes.LegacyPcrId.getIdString(), id)) {
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public Collection<IAtsWorkItem> getWorkItemsAtrTypeExists(AttributeTypeToken attrType) {
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken art : this.getArtifactsFromQuery(ATTR_EXISTS_QUERY, this.atsApi.getAtsBranch(), attrType)) {
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public List<String> getIdsFromStr(String ids) {
        LinkedList<String> idStrs = new LinkedList<String>();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            id = id.replaceAll("^ +", "");
            id = id.replaceAll(" +$", "");
            idStrs.add(id);
            ++n2;
        }
        return idStrs;
    }

    public <T> T getConfigItem(ArtifactId artId) {
        Conditions.assertTrue((artId.getId() > 0L ? 1 : 0) != 0, (String)"Art Id must be > 0, not %s", (Object[])new Object[]{artId});
        IAtsConfigObject atsObject = null;
        ArtifactToken artifact = this.getArtifact(artId);
        if (artifact != null) {
            atsObject = AtsObjects.getConfigObject(artifact, this.atsApi);
        }
        return (T)atsObject;
    }

    public <T> T getConfigItem(Long id) {
        IAtsConfigObject atsObject = null;
        ArtifactToken artifact = this.getArtifact(id);
        if (artifact != null && artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsConfigArtifact})) {
            atsObject = AtsObjects.getConfigObject(artifact, this.atsApi);
        }
        return (T)atsObject;
    }

    public IAtsTeamWorkflow getTeamWf(ArtifactId artifact) {
        ArtifactToken art = this.getArtifact(artifact);
        if (art != null) {
            return this.atsApi.getWorkItemService().getTeamWf(art);
        }
        return null;
    }

    public IAtsTeamWorkflow getTeamWf(Long id) {
        ArtifactToken art = this.getArtifact(id);
        if (art != null) {
            return this.atsApi.getWorkItemService().getTeamWf(art);
        }
        return null;
    }

    public List<ArtifactToken> getArtifacts(ArtifactTypeToken artifactType) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.atsApi.getQueryService().getArtifacts((BranchId)this.atsApi.getAtsBranch(), true, new ArtifactTypeToken[]{artifactType}));
    }

    public ArtifactToken getConfigArtifact(IAtsConfigObject atsConfigObject) {
        if (atsConfigObject.getStoreObject() != null) {
            return atsConfigObject.getStoreObject();
        }
        return this.getArtifact(atsConfigObject.getId());
    }

    public ArtifactToken getArtifactByIdOrAtsId(String id) {
        ArtifactToken art = null;
        try {
            if (Strings.isValid((String)id)) {
                art = Strings.isNumeric((String)id) ? this.getArtifact(Long.valueOf(id)) : this.getArtifactByAtsId(id);
            }
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return art;
    }

    public Collection<ArtifactToken> getArtifactsByIdsOrAtsIds(String searchStr) {
        LinkedList<ArtifactToken> artifacts = new LinkedList<ArtifactToken>();
        String[] stringArray = searchStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            str = str.replaceAll("^ ", "");
            str = str.replaceAll("$ ", "");
            try {
                if (Strings.isValid((String)str)) {
                    ArtifactToken art = null;
                    art = Strings.isNumeric((String)str) ? this.getArtifact(Long.valueOf(str)) : this.getArtifactByAtsId(str);
                    if (art != null) {
                        artifacts.add(art);
                    }
                }
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
            ++n2;
        }
        return artifacts;
    }

    public ArtifactToken getOrCreateArtifact(ArtifactToken parent, ArtifactToken artifactTok, IAtsChangeSet changes) {
        ArtifactToken artifact = this.getArtifact((ArtifactId)artifactTok);
        if (artifact == null || artifact.isInvalid()) {
            artifact = changes.createArtifact(artifactTok);
        }
        if (this.atsApi.getRelationResolver().getParent((ArtifactId)artifact) == null) {
            changes.addChild((ArtifactId)parent, (ArtifactId)artifact);
        }
        return artifact;
    }

    public Collection<ArtifactToken> getArtifactsById(Collection<ArtifactId> artifacts) {
        HashSet<Long> ids = new HashSet<Long>();
        for (ArtifactId art : artifacts) {
            ids.add(art.getId());
        }
        return this.getArtifacts(ids);
    }

    public Collection<ArtifactToken> getArtifacts(AtsSearchData atsSearchData, ISearchCriteriaProvider provider) {
        AtsSearchDataSearch query = new AtsSearchDataSearch(atsSearchData, this.atsApi, provider);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(query.performSearch());
    }

    public Collection<ArtifactToken> getArtifactsNew(AtsSearchData atsSearchData, ISearchCriteriaProvider provider) {
        AtsSearchDataSearch query = new AtsSearchDataSearch(atsSearchData, this.atsApi, provider);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(query.performSearchNew());
    }

    public Collection<ArtifactToken> getArtifactsFromObjects(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<ArtifactToken> arts = new ArrayList<ArtifactToken>();
        for (IAtsObject iAtsObject : atsObjects) {
            arts.add(this.getArtifact(iAtsObject));
        }
        return arts;
    }

    public Map<String, IAtsWorkItem> getWorkItemsByAtsId(Collection<String> atsIds) {
        HashMap<String, IAtsWorkItem> results = new HashMap<String, IAtsWorkItem>();
        for (ArtifactToken art : this.getArtifactsFromAttributeValues((AttributeTypeToken)AtsAttributeTypes.AtsId, atsIds, 200)) {
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
            results.put(workItem.getAtsId(), workItem);
        }
        return results;
    }

    public List<AtsSearchData> getSavedSearches(String namespace) {
        ArrayList<AtsSearchData> searches = new ArrayList<AtsSearchData>();
        List json = this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)this.atsApi.userService().getUser(), (AttributeTypeToken)CoreAttributeTypes.AtsActionSearch);
        for (String jsonValue : json) {
            if (!jsonValue.contains("\"" + namespace + "\"")) continue;
            try {
                AtsSearchData data = this.atsApi.getSearchDataProvider(namespace).fromJson(namespace, jsonValue);
                if (data == null) continue;
                searches.add(data);
            }
            catch (Exception exception) {}
        }
        return searches;
    }

    public AtsSearchData createSearchData(String namespace, String searchName) {
        return this.atsApi.getSearchDataProvider(namespace).createSearchData(namespace, searchName);
    }

    public ArtifactToken getArtifactByName(ArtifactTypeToken artType, String name, BranchToken branch) {
        return this.getArtifactFromTypeAndAttribute(artType, (AttributeTypeToken)CoreAttributeTypes.Name, name, (BranchId)branch);
    }

    public List<ArtifactToken> getArtifactsFromIds(Collection<String> atsIds) {
        LinkedList<ArtifactToken> toReturn = new LinkedList<ArtifactToken>();
        if (!atsIds.isEmpty()) {
            List fromIds = this.getArtifactsFromAttributeValues((AttributeTypeId)AtsAttributeTypes.AtsId, atsIds, (BranchId)CoreBranches.COMMON, atsIds.size());
            toReturn.addAll(fromIds);
        }
        return toReturn;
    }

    public Collection<ArtifactToken> getAssigned(AtsUser user, boolean useNewAttr) {
        if (useNewAttr) {
            return this.atsApi.getQueryService().getArtifacts((AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, user.getArtifactId().getIdString(), this.atsApi.getAtsBranch());
        }
        return Collections.emptyList();
    }
}

