/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.util.regex.Matcher;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.ats.core.internal.log.AtsLogWriter;
import org.eclipse.osee.ats.core.internal.log.LogItem;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsLogReader {
    private final ILogStorageProvider storeProvider;
    private final IAtsLog atsLog;

    public AtsLogReader(IAtsLog atsLog, ILogStorageProvider storeProvider) {
        this.atsLog = atsLog;
        this.storeProvider = storeProvider;
    }

    public void load() {
        this.atsLog.clearLog();
        this.atsLog.setLogId(this.storeProvider.getLogId());
        String xml = this.storeProvider.getLogXml();
        if (!xml.isEmpty()) {
            Matcher m = AtsLogWriter.LOG_ITEM_PATTERN.matcher(xml);
            while (m.find()) {
                LogItem item = new LogItem(m.group(4), m.group(1), Strings.intern((String)m.group(5)), Strings.intern((String)m.group(3)), AXml.xmlToText((String)m.group(2)));
                this.atsLog.addLogItem((IAtsLogItem)item);
            }
        }
        this.atsLog.setDirty(false);
    }
}

