/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config.tx;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.Csci;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.config.tx.AtsActionableItemArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsActionableItemArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxActionableItem;
import org.eclipse.osee.ats.api.config.tx.IAtsProgramArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.config.tx.AbstractAtsConfigTxObject;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsConfigTxActionableItem
extends AbstractAtsConfigTxObject<IAtsConfigTxActionableItem>
implements IAtsConfigTxActionableItem {
    private final IAtsActionableItem ai;

    public AtsConfigTxActionableItem(IAtsObject atsObject, AtsApi atsApi, IAtsChangeSet changes, IAtsConfigTx cfgTx) {
        super(atsObject, atsApi, changes, cfgTx);
        Conditions.assertTrue((boolean)(atsObject instanceof IAtsActionableItem), (String)"AtsObject must be of type IAtsActionableItem", (Object[])new Object[0]);
        this.ai = (IAtsActionableItem)atsObject;
    }

    public IAtsConfigTxActionableItem createChildActionableItem(IAtsActionableItemArtifactToken childTok) {
        IAtsConfigTxActionableItem child = this.cfgTx.createActionableItem(childTok);
        this.changes.relate((Object)this.ai, CoreRelationTypes.DefaultHierarchical_Child, (Object)child.getAi());
        return child;
    }

    public IAtsConfigTxActionableItem createChildActionableItem(String name) {
        return this.createChildActionableItem(AtsActionableItemArtifactToken.valueOf((Long)Lib.generateArtifactIdAsInt(), (String)name));
    }

    @Override
    public IAtsConfigTxActionableItem andActive(boolean active) {
        this.changes.setSoleAttributeValue((IAtsObject)this.ai, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)active);
        return this;
    }

    public IAtsConfigTxActionableItem andActionable(boolean actionable) {
        this.changes.setSoleAttributeValue((IAtsObject)this.ai, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)actionable);
        return this;
    }

    public IAtsConfigTxActionableItem andTeamDef(IAtsTeamDefinitionArtifactToken teamDefTok) {
        IAtsTeamDefinition teamDef = this.cfgTx.getTeamDef((ArtifactId)teamDefTok);
        if (teamDef == null || teamDef.isInvalid()) {
            teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)teamDefTok);
        }
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition must be created before AI %s", (Object[])new Object[]{this.ai});
        this.changes.relate((Object)this.ai, AtsRelationTypes.TeamActionableItem_TeamDefinition, (Object)teamDef);
        return this;
    }

    public IAtsConfigTxActionableItem andTeamDef(String name) {
        IAtsTeamDefinition teamDef = this.cfgTx.getTeamDef(name);
        if (teamDef == null || teamDef.isInvalid()) {
            teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinition(name);
        }
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition must be created before AI %s", (Object[])new Object[]{this.ai});
        this.changes.relate((Object)this.ai, AtsRelationTypes.TeamActionableItem_TeamDefinition, (Object)teamDef);
        return this;
    }

    public IAtsActionableItem getAi() {
        return this.ai;
    }

    public IAtsConfigTxActionableItem andChildAis(String ... aiNames) {
        String[] stringArray = aiNames;
        int n = aiNames.length;
        int n2 = 0;
        while (n2 < n) {
            String aiName = stringArray[n2];
            IAtsConfigTxActionableItem childAi = this.createChildActionableItem(aiName);
            this.changes.addChild((IAtsObject)this.ai, (IAtsObject)childAi.getAi());
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxActionableItem andChildAis(IAtsActionableItemArtifactToken ... ais) {
        IAtsActionableItemArtifactToken[] iAtsActionableItemArtifactTokenArray = ais;
        int n = ais.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsActionableItemArtifactToken cai = iAtsActionableItemArtifactTokenArray[n2];
            IAtsConfigTxActionableItem childAi = this.createChildActionableItem(cai);
            this.changes.addChild((IAtsObject)this.ai, (IAtsObject)childAi.getAi());
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxActionableItem andWorkType(WorkType workType) {
        this.changes.addAttribute((IAtsObject)this.ai, (AttributeTypeToken)AtsAttributeTypes.WorkType, (Object)workType.name());
        return this;
    }

    public IAtsConfigTxActionableItem andProgram(IAtsProgramArtifactToken program) {
        this.changes.addAttribute((IAtsObject)this.ai, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)program);
        return this;
    }

    public IAtsConfigTxActionableItem andCsci(Csci ... cscis) {
        Csci[] csciArray = cscis;
        int n = cscis.length;
        int n2 = 0;
        while (n2 < n) {
            Csci csci = csciArray[n2];
            this.changes.addAttribute((IAtsObject)this.ai, (AttributeTypeToken)AtsAttributeTypes.CSCI, (Object)csci.name());
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxActionableItem andAccessContexts(AccessContextToken ... contextIds) {
        AccessContextToken[] accessContextTokenArray = contextIds;
        int n = contextIds.length;
        int n2 = 0;
        while (n2 < n) {
            AccessContextToken id = accessContextTokenArray[n2];
            this.and((AttributeTypeToken)CoreAttributeTypes.AccessContextId, String.format("%s, %s", id.getIdString(), id.getName()));
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxActionableItem andTag(String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.and((AttributeTypeToken)CoreAttributeTypes.StaticId, tag);
            ++n2;
        }
        return this;
    }
}

