/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemProvider;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class ParentTopTeamColumn {
    private ParentTopTeamColumn() {
    }

    public static String getColumnText(IAtsObject atsObject) {
        IAtsActionableItemProvider provider;
        Set actionableItems;
        IAtsWorkItem workItem;
        IAtsTeamWorkflow teamArt;
        String result = "";
        IAtsTeamDefinition teamDef = null;
        if (atsObject instanceof IAtsWorkItem && (teamArt = (workItem = (IAtsWorkItem)atsObject).getParentTeamWorkflow()) != null) {
            teamDef = teamArt.getTeamDefinition();
        }
        if (!Strings.isValid((String)(result = ParentTopTeamColumn.getTopTeamDefName(teamDef))) && atsObject instanceof IAtsActionableItemProvider && !(actionableItems = (provider = (IAtsActionableItemProvider)atsObject).getActionableItems()).isEmpty()) {
            teamDef = ((IAtsActionableItem)actionableItems.iterator().next()).getTeamDefinition();
            if (teamDef == null) {
                IAtsActionableItem ai = (IAtsActionableItem)actionableItems.iterator().next();
                teamDef = ai.getAtsApi().getActionableItemService().getTeamDefinitionInherited(ai);
            }
            result = ParentTopTeamColumn.getTopTeamDefName(teamDef);
        }
        return result;
    }

    protected static String getTopTeamDefName(IAtsTeamDefinition teamDef) {
        String result = "";
        if (teamDef != null) {
            IAtsTeamDefinition teamDefinitionHoldingVersions = teamDef.getAtsApi().getTeamDefinitionService().getTeamDefHoldingVersions(teamDef);
            if (teamDefinitionHoldingVersions != null) {
                teamDef = teamDefinitionHoldingVersions;
            }
            result = teamDef.getName();
        }
        return result;
    }
}

