/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.column.CountryColumn;
import org.eclipse.osee.ats.core.config.WorkPackageUtility;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class InsertionActivityColumn
extends AbstractServicesColumn {
    private Map<Object, ArtifactToken> idToInsertionActivity;

    public InsertionActivityColumn(AtsApi atsApi) {
        super(atsApi);
    }

    public void setIdToInsertionActivityCache(Map<Object, ArtifactToken> idToInsertionActivity) {
        this.idToInsertionActivity = idToInsertionActivity;
    }

    @Override
    public String getText(IAtsObject atsObject) {
        String format = "%s";
        if (this.atsApi.getStoreService().isDeleted(atsObject)) {
            format = "<Deleted> %s";
        }
        return String.format(format, InsertionActivityColumn.getInsertionActivityStr(atsObject, this.atsApi, CountryColumn.getUtil(), this.idToInsertionActivity));
    }

    public static String getInsertionActivityStr(IAtsObject atsObject, AtsApi atsApi) {
        return InsertionActivityColumn.getInsertionActivityStr(atsObject, atsApi, CountryColumn.getUtil());
    }

    public static String getInsertionActivityStr(IAtsObject atsObject, AtsApi atsApi, WorkPackageUtility util) {
        return InsertionActivityColumn.getInsertionActivityStr(atsObject, atsApi, util, null);
    }

    public static String getInsertionActivityStr(IAtsObject atsObject, AtsApi atsApi, WorkPackageUtility utilMap, Map<Object, ArtifactToken> idToInsertionActivity) {
        String result = "";
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem;
            Pair<IAtsInsertionActivity, Boolean> insertionActivity;
            ArtifactToken insertionArt;
            if (idToInsertionActivity != null && (insertionArt = idToInsertionActivity.get(atsObject.getId())) != null) {
                result = insertionArt.getName();
            }
            if (Strings.isInValid((String)result) && (insertionActivity = utilMap.getInsertionActivity(atsApi, workItem = (IAtsWorkItem)atsObject)).getFirst() != null) {
                result = String.format("%s%s", ((IAtsInsertionActivity)insertionActivity.getFirst()).getName(), (Boolean)insertionActivity.getSecond() != false ? " (I)" : "");
            }
        } else if (atsObject instanceof IAtsWorkPackage) {
            ArtifactToken insertionActivityArt;
            if (idToInsertionActivity != null && (insertionActivityArt = idToInsertionActivity.get(((IAtsWorkPackage)atsObject).getId())) != null) {
                result = insertionActivityArt.getName();
            }
            if (Strings.isInValid((String)result)) {
                IAtsWorkPackage workPackage = (IAtsWorkPackage)atsObject;
                IAtsInsertionActivity insertionActivity = atsApi.getProgramService().getInsertionActivity(workPackage);
                if (insertionActivity != null) {
                    result = insertionActivity.getName();
                }
            }
        }
        return result;
    }
}

