/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.HasAssignees;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.Action;
import org.eclipse.osee.ats.core.workflow.AtsImplementersService;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AssigneeColumn
extends AbstractServicesColumn {
    private static IAtsImplementerService implementStrProvider;

    public AssigneeColumn(AtsApi atsApi) {
        super(atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        return this.getAssigneeStr(atsObject);
    }

    public String getAssigneeStr(IAtsObject atsObject) {
        return AssigneeColumn.getAssigneeStrr(atsObject);
    }

    public static String getAssigneeStrr(IAtsObject atsObject) {
        if (atsObject instanceof Action) {
            ArrayList<AtsUser> pocs = new ArrayList<AtsUser>();
            ArrayList<AtsUser> implementers = new ArrayList<AtsUser>();
            for (IAtsWorkItem iAtsWorkItem : ((Action)atsObject).getTeamWorkflows()) {
                StateType stateType = iAtsWorkItem.getCurrentStateType();
                if (stateType == null) continue;
                if (stateType.isCompletedOrCancelled()) {
                    for (AtsUser user : iAtsWorkItem.getImplementers()) {
                        if (implementers.contains(user)) continue;
                        implementers.add(user);
                    }
                    continue;
                }
                for (AtsUser user : iAtsWorkItem.getAssignees()) {
                    if (pocs.contains(user)) continue;
                    pocs.add(user);
                }
            }
            Collections.sort(pocs);
            Collections.sort(implementers);
            return String.valueOf(AtsObjects.toString("; ", pocs)) + (implementers.isEmpty() ? "" : "(" + AtsObjects.toString("; ", implementers) + ")");
        }
        if (atsObject instanceof IAtsWorkItem) {
            String string;
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            StateType stateType = workItem.getCurrentStateType();
            if (stateType != null && stateType.isCompletedOrCancelled() && Strings.isValid((String)(string = AssigneeColumn.getImplementersStringProvider().getImplementersStr((IAtsObject)workItem)))) {
                return "(" + string + ")";
            }
            if (atsObject instanceof HasAssignees) {
                return AtsObjects.toString("; ", ((HasAssignees)atsObject).getAssignees());
            }
        }
        return "";
    }

    private static IAtsImplementerService getImplementersStringProvider() {
        if (implementStrProvider == null) {
            implementStrProvider = new AtsImplementersService();
        }
        return implementStrProvider;
    }
}

