/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileSprintDateData;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class SprintDataBuilder {
    private final AtsApi atsApi;
    private final IAgileSprint sprint;
    private final IAgileTeam agileTeam;
    private final XResultData results;

    public SprintDataBuilder(IAgileTeam agileTeam, IAgileSprint sprint, AtsApi atsApi, XResultData results) {
        this.agileTeam = agileTeam;
        this.sprint = sprint;
        this.atsApi = atsApi;
        this.results = results;
    }

    public AgileSprintData get() {
        AgileSprintData sprintData = new AgileSprintData();
        sprintData.setResults(this.results);
        try {
            ArtifactToken sprintArt = this.sprint.getStoreObject();
            sprintData.setSprintName(sprintArt.getName());
            sprintData.setAgileTeamName(this.agileTeam.getName());
            Date startDate = this.validateStartDate(sprintData, sprintArt);
            if (startDate == null) {
                return sprintData;
            }
            Date endDate = this.validateEndDate(sprintData, sprintArt);
            if (endDate == null) {
                return sprintData;
            }
            LinkedList holidays = new LinkedList();
            holidays.addAll(this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)sprintArt, (AttributeTypeToken)AtsAttributeTypes.Holiday));
            sprintData.setHolidays(holidays);
            Integer unPlannedPoints = (Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)sprintArt, (AttributeTypeToken)AtsAttributeTypes.UnplannedPoints, (Object)0);
            sprintData.setUnPlannedPoints(unPlannedPoints);
            Integer plannedPoints = (Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)sprintArt, (AttributeTypeToken)AtsAttributeTypes.PlannedPoints, (Object)0);
            sprintData.setPlannedPoints(plannedPoints);
            sprintData.setPointsAttrTypeName((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.agileTeam, (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, (Object)AtsAttributeTypes.Points.getName()));
            int totalPoints = unPlannedPoints + plannedPoints;
            long oneDay = 86400000L;
            this.computeDateBuckets(sprintData, startDate, endDate, oneDay);
            Collection items = this.atsApi.getAgileService().getItems(this.sprint);
            this.computeGoal(sprintData, totalPoints);
            this.computeTotalUnplannedAndPlannedPoints(sprintData, items);
            this.computeUnPlannedIncomplete(sprintData);
            this.computeCompleted(sprintData);
        }
        catch (Exception ex) {
            sprintData.getResults().error("Error generating burndown data: \n\n" + Lib.exceptionToString((Exception)ex));
        }
        return sprintData;
    }

    private void computeTotalUnplannedAndPlannedPoints(AgileSprintData sprintData, Collection<IAgileItem> items) {
        for (IAgileItem item : items) {
            boolean completed = item.isCompletedOrCancelled();
            boolean unPlanned = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)item, (AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)false);
            Date completedCancelledDate = item.isCompleted() ? item.getCompletedDate() : item.getCancelledDate();
            for (AgileSprintDateData dateBucket : sprintData.getDates()) {
                Date createdDate;
                double points = this.getPoints(sprintData, item);
                if (completed && completedCancelledDate.before(dateBucket.getDate())) {
                    if (unPlanned) {
                        if (dateBucket.getCompletedUnPlannedPoints() != null) {
                            dateBucket.setCompletedUnPlannedPoints(Double.valueOf(dateBucket.getCompletedUnPlannedPoints() + points));
                        } else {
                            dateBucket.setCompletedUnPlannedPoints(Double.valueOf(points));
                        }
                    } else if (dateBucket.getCompletedPlannedPoints() != null) {
                        dateBucket.setCompletedPlannedPoints(Double.valueOf(dateBucket.getCompletedPlannedPoints() + points));
                    } else {
                        dateBucket.setCompletedPlannedPoints(Double.valueOf(points));
                    }
                }
                if (!(createdDate = item.getCreatedDate()).before(dateBucket.getDate())) continue;
                dateBucket.setTotalRealizedPoints(Double.valueOf(dateBucket.getTotalRealizedPoints() + points));
            }
        }
    }

    private void computeDateBuckets(AgileSprintData sprintData, Date startDate, Date endDate, long oneDay) {
        Date date = startDate;
        while (date.before(endDate) || date.equals(endDate)) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            if (c.get(7) != 7 && c.get(7) != 1 && !this.isHoliday(date, sprintData.getHolidays())) {
                AgileSprintDateData sprintDateData = new AgileSprintDateData();
                sprintDateData.setDate(date);
                sprintData.getDates().add(sprintDateData);
            }
            date = new Date(date.getTime() + oneDay);
        }
    }

    private Date validateEndDate(AgileSprintData sprintData, ArtifactToken sprintArt) {
        Date endDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)sprintArt, (AttributeTypeToken)AtsAttributeTypes.EndDate, null);
        if (endDate == null) {
            sprintData.getResults().error("End Date must be set on Sprint");
            return null;
        }
        endDate = this.clearTimeComponent(endDate);
        sprintData.setEndDateAsDate(endDate);
        return endDate;
    }

    private Date validateStartDate(AgileSprintData sprintData, ArtifactToken sprintArt) {
        Date startDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)sprintArt, (AttributeTypeToken)AtsAttributeTypes.StartDate, null);
        if (startDate == null) {
            sprintData.getResults().error("Start Date must be set on Sprint");
            return null;
        }
        startDate = this.clearTimeComponent(startDate);
        sprintData.setStartDateAsDate(startDate);
        return startDate;
    }

    private void computeUnPlannedIncomplete(AgileSprintData burn) {
        for (AgileSprintDateData date : burn.getDates()) {
            Integer unplannedPoints = burn.getUnPlannedPoints();
            Double completedUnPlannedPoints = date.getCompletedUnPlannedPoints();
            if (completedUnPlannedPoints == null) {
                completedUnPlannedPoints = 0.0;
            }
            Double inCompleteUnPlannedPoints = Double.valueOf(unplannedPoints.intValue()) - completedUnPlannedPoints;
            date.setInCompletedUnPlannedPoints(inCompleteUnPlannedPoints);
        }
    }

    private void computeCompleted(AgileSprintData burn) {
        for (AgileSprintDateData date : burn.getDates()) {
            double completed;
            Double copmletedPlannedPoints;
            Double completedUnPlannedPoints = date.getCompletedUnPlannedPoints();
            if (completedUnPlannedPoints == null) {
                completedUnPlannedPoints = 0.0;
            }
            if ((copmletedPlannedPoints = date.getCompletedPlannedPoints()) == null) {
                copmletedPlannedPoints = 0.0;
            }
            if ((completed = completedUnPlannedPoints + copmletedPlannedPoints) < 0.0) {
                completed = 0.0;
            }
            date.setCompletedPoints(Double.valueOf(completed));
        }
    }

    private Date clearTimeComponent(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        cal.set(9, 1);
        return cal.getTime();
    }

    private double getPoints(AgileSprintData burn, IAgileItem item) {
        AttributeTypeGeneric pointsType = this.atsApi.tokenService().getAttributeType(burn.getPointsAttrTypeName());
        Object value = this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)item, (AttributeTypeToken)pointsType, (Object)"");
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String && Strings.isNumeric((String)((String)value))) {
            return Double.valueOf((String)value);
        }
        return 0.0;
    }

    private void computeGoal(AgileSprintData burn, int totalPoints) {
        int numDates = burn.getDates().size();
        int count = 1;
        int numWorkDays = numDates - 3;
        double pointsPerDay = (double)totalPoints / (double)numWorkDays;
        for (AgileSprintDateData date : burn.getDates()) {
            if (count == 1 || count == 2) {
                date.setGoalPoints(Double.valueOf(totalPoints));
            } else if (count == numDates || count == numDates - 1) {
                date.setGoalPoints(Double.valueOf(0.0));
            } else {
                double goalPoints = (double)totalPoints - (double)(count - 2) * pointsPerDay;
                if (goalPoints < 0.0) {
                    goalPoints = 0.0;
                }
                date.setGoalPoints(Double.valueOf(goalPoints));
            }
            ++count;
        }
    }

    private boolean isHoliday(Date date, List<Date> holidays) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        for (Date holiday : holidays) {
            boolean sameDay;
            Calendar holCal = Calendar.getInstance();
            holCal.setTime(holiday);
            boolean bl = sameDay = dateCal.get(1) == holCal.get(1) && dateCal.get(6) == holCal.get(6);
            if (!sameDay) continue;
            return true;
        }
        return false;
    }
}

