/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileWriterResult;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AgileItemWriter {
    private final AtsApi atsApi;
    private final JaxAgileItem newItem;
    private final IAgileService agileService;
    private List<IAtsWorkItem> workItems;

    public AgileItemWriter(AtsApi atsApi, IAgileService agileService, JaxAgileItem newItem) {
        this.atsApi = atsApi;
        this.agileService = agileService;
        this.newItem = newItem;
    }

    public AgileWriterResult write() {
        AgileWriterResult result = new AgileWriterResult();
        result.setJaxAgileItem(this.newItem);
        try {
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Update new Agile Item", AtsCoreUsers.SYSTEM_USER);
            if (Strings.isValid((String)this.newItem.getToState())) {
                List<IAtsWorkItem> workItems = this.getWorkItems();
                for (IAtsWorkItem workItem : workItems) {
                    Collection<AtsUser> toStateAssignees;
                    if (this.atsApi.getWorkItemService().getCurrentStateName(workItem).equals(this.newItem.getToState())) {
                        toStateAssignees = this.getAssignees(this.newItem.getToStateUsers());
                        this.resolveAssignees(toStateAssignees);
                        workItem.getStateMgr().setAssignees(toStateAssignees);
                        changes.add((Object)workItem);
                        continue;
                    }
                    toStateAssignees = this.getAssignees(this.newItem.getToStateUsers());
                    this.resolveAssignees(toStateAssignees);
                    TransitionHelper helper = new TransitionHelper("Transition Agile Workflow", Arrays.asList(workItem), this.newItem.getToState(), toStateAssignees, "Cancelled via Agile Kanban", changes, this.atsApi, TransitionOption.OverrideAssigneeCheck);
                    helper.setTransitionUser(AtsCoreUsers.SYSTEM_USER);
                    TransitionManager mgr = new TransitionManager(helper);
                    TransitionResults results = new TransitionResults();
                    mgr.handleTransitionValidation(results);
                    if (!results.isEmpty()) {
                        throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
                    }
                    mgr.handleTransition(results);
                    if (results.isEmpty()) continue;
                    throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
                }
            }
            if (this.newItem.isSetFeatures()) {
                Collection features = this.agileService.getAgileFeatureGroups(this.newItem.getFeatures());
                LinkedList featureArts = new LinkedList();
                for (IAgileFeatureGroup feature : features) {
                    featureArts.add(feature.getStoreObject());
                }
                for (ArtifactToken awa : this.atsApi.getQueryService().getArtifacts((Collection)this.newItem.getIds())) {
                    for (IAgileFeatureGroup feature : features) {
                        ArtifactToken featureArt = feature.getStoreObject();
                        if (this.atsApi.getRelationResolver().areRelated((ArtifactId)featureArt, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup, (ArtifactId)awa)) continue;
                        changes.relate((Object)feature, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)awa);
                    }
                    for (ArtifactToken featureArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)awa, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
                        if (featureArts.contains(featureArt)) continue;
                        changes.unrelate((ArtifactId)featureArt, AtsRelationTypes.AgileFeatureToItem_AtsItem, (ArtifactId)awa);
                    }
                }
            } else if (this.newItem.isRemoveFeatures()) {
                for (ArtifactToken awa : this.atsApi.getQueryService().getArtifacts((Collection)this.newItem.getIds())) {
                    for (IAgileFeatureGroup feature : this.atsApi.getRelationResolver().getRelated((ArtifactId)awa, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
                        changes.unrelate((ArtifactId)feature, AtsRelationTypes.AgileFeatureToItem_AtsItem, (ArtifactId)awa);
                    }
                }
            }
            if (this.newItem.isSetSprint()) {
                ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(this.newItem.getSprintId()));
                IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint((ArtifactId)sprintArt);
                for (ArtifactToken awa : this.atsApi.getQueryService().getArtifacts((Collection)this.newItem.getIds())) {
                    if (sprint != null) {
                        changes.setRelation((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)awa);
                    } else {
                        changes.unrelateAll((Object)awa, AtsRelationTypes.AgileSprintToItem_AtsItem);
                    }
                    changes.add((Object)sprint);
                }
            }
            if (this.newItem.isSetBacklog()) {
                ArtifactToken backlogArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(this.newItem.getBacklogId()));
                IAgileSprint backlog = this.atsApi.getAgileService().getAgileSprint((ArtifactId)backlogArt);
                for (ArtifactToken awa : this.atsApi.getQueryService().getArtifacts((Collection)this.newItem.getIds())) {
                    if (backlog != null) {
                        changes.setRelation((Object)backlog, AtsRelationTypes.Goal_Member, (Object)awa);
                    } else {
                        changes.unrelateAll((Object)awa, AtsRelationTypes.Goal_Member);
                    }
                    changes.add((Object)backlog);
                }
            }
            if (this.newItem.isSetAssignees()) {
                Collection<AtsUser> assignees = this.getAssignees(this.newItem.getAssigneesAccountIds());
                for (IAtsWorkItem workItem : this.getWorkItems()) {
                    workItem.getStateMgr().setAssignees(assignees);
                    changes.add((Object)workItem);
                }
                String assigneesStr = Collections.toString(assignees, (String)"; ", Named::getName);
                this.newItem.setAssigneesStr(assigneesStr);
                this.newItem.setAssigneesStrShort(Strings.truncate((String)assigneesStr, (int)30, (boolean)true));
            }
            if (!changes.isEmpty()) {
                changes.execute();
            }
        }
        catch (Exception ex) {
            result.getResults().errorf("Error Updating Work Items [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    private void resolveAssignees(Collection<AtsUser> toStateAssignees) {
        if (toStateAssignees.size() > 1 && toStateAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
            toStateAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
        }
        if (toStateAssignees.isEmpty()) {
            toStateAssignees.add(AtsCoreUsers.UNASSIGNED_USER);
        }
    }

    private List<IAtsWorkItem> getWorkItems() {
        if (this.workItems == null) {
            this.workItems = new LinkedList<IAtsWorkItem>();
            Iterator iterator = this.newItem.getIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                IAtsWorkItem workItem = this.atsApi.getQueryService().getTeamWf(id);
                this.workItems.add(workItem);
            }
        }
        return this.workItems;
    }

    private Collection<AtsUser> getAssignees(List<String> usersAccountIds) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        for (String userId : usersAccountIds) {
            users.add(this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)userId)));
        }
        return users;
    }
}

