/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.core.internal.util.FilterableCollection;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;
import org.eclipse.osee.orcs.core.internal.util.OrcsWriteable;

public abstract class AbstractTypeCollection<TYPE, MATCH_DATA extends OrcsWriteable, KEY, DATA>
extends FilterableCollection<MATCH_DATA, KEY, DATA> {
    protected AbstractTypeCollection(Multimap<KEY, DATA> map) {
        super(map);
    }

    protected AbstractTypeCollection() {
    }

    protected abstract TYPE getType(DATA var1);

    public Collection<TYPE> getExistingTypes(DeletionFlag includeDeleted) {
        LinkedHashSet<TYPE> toReturn = new LinkedHashSet<TYPE>();
        for (DATA data : this.getList(includeDeleted)) {
            if (!this.isValid(data)) continue;
            toReturn.add(this.getType(data));
        }
        return toReturn;
    }

    public List<DATA> getDirties() {
        Predicate matchDirties = OrcsPredicates.isDirty();
        return this.getListByFilter(matchDirties);
    }

    public boolean hasDirty() {
        Predicate matchDirties = OrcsPredicates.isDirty();
        return this.hasItemMatchingFilter(matchDirties);
    }

    public List<DATA> getList(DeletionFlag includeDeleted) {
        Predicate deletedStateMatch = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getListByFilter(deletedStateMatch);
    }

    public ResultSet<DATA> getResultSet(DeletionFlag includeDeleted) {
        Predicate value = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getResultSetByFilter(value);
    }
}

