/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdombuilder;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Node;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.util.EnumFunctionMap;

public class SpecElementWithAttributesConverter {
    private static Map<IdentifierType, String> descriptionMap = Map.ofEntries(Map.entry(IdentifierType.SPECIFICATION, " Specification"), Map.entry(IdentifierType.SPECTER_SPEC_OBJECT, " Specter Spec Object"), Map.entry(IdentifierType.SPEC_OBJECT, " Spec Object"), Map.entry(IdentifierType.SPEC_RELATION, " Spec Relation"));
    private final DocumentMap documentMap;
    private final EnumFunctionMap<IdentifierType, Object[], Node> nodeFactoryMap;

    public SpecElementWithAttributesConverter(DocumentMap documentMap) {
        this.documentMap = documentMap;
        this.nodeFactoryMap = new EnumFunctionMap(IdentifierType.class);
        this.nodeFactoryMap.put((Enum)IdentifierType.SPECIFICATION, args -> this.documentMap.createDocument((Identifier)args[0], (String)args[1], (String)args[2]));
        this.nodeFactoryMap.put((Enum)IdentifierType.SPECTER_SPEC_OBJECT, args -> this.documentMap.createDocumentObject((Identifier)args[0], (String)args[1], (String)args[2]));
        this.nodeFactoryMap.put((Enum)IdentifierType.SPEC_OBJECT, args -> this.documentMap.createDocumentObject((Identifier)args[0], (String)args[1], (String)args[2]));
        this.nodeFactoryMap.put((Enum)IdentifierType.SPEC_RELATION, args -> this.documentMap.createDocumentObject((Identifier)args[0], (String)args[1], (String)args[2]));
    }

    void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isInGroup(IdentifierTypeGroup.OBJECT)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierTypeGroup.OBJECT);
        ArtifactReadable nativeArtifactReadable = (ArtifactReadable)groveThing.getNativeThing();
        String name = nativeArtifactReadable.getName();
        String type = descriptionMap.get(groveThing.getIdentifier().getType());
        Identifier identifier = groveThing.getIdentifier();
        Node node = (Node)this.nodeFactoryMap.apply((Enum)groveThing.getIdentifier().getType(), (Object)new Object[]{identifier, name, type});
        groveThing.setForeignThing(node);
    }
}

