/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.markdownsynchronizationartifactbuilder;

import java.io.InputStream;
import java.util.function.Function;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Document;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentObject;
import org.eclipse.osee.define.operations.synchronization.publishingdom.HierarchicalNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.NodeWrongTypeException;

public class MarkdownSynchronizationArtifactSerializer
implements Function<DocumentMap, InputStream> {
    private static int bufferSize = 0x800000;
    private static String[] headings = new String[]{"", "#", "##", "###", "####", "#####", "######"};
    private static boolean printHeadingsWithTypes = false;

    void serializeDocumentObject(HierarchicalNode hierarchicalNode, StringBuilder stringBuilder) {
        if (!(hierarchicalNode instanceof DocumentObject)) {
            throw new NodeWrongTypeException(hierarchicalNode.getIdentifier(), hierarchicalNode, DocumentObject.class);
        }
        DocumentObject documentObject = (DocumentObject)hierarchicalNode;
        int level = documentObject.getHierarchyLevel();
        level = level <= 4 ? level : 4;
        stringBuilder.append(headings[level]).append(" ").append(documentObject.getHierarchyLevelString()).append(" ").append(documentObject.getNameAttributeValue().orElse("\"Name\" attribute not found."));
        if (printHeadingsWithTypes) {
            stringBuilder.append(" ( ").append(documentObject.getName()).append(" - ").append(documentObject.getType()).append(" ) ");
        }
        stringBuilder.append("\n").append("\n").append(documentObject.getPrimaryAttributeValue().orElse("\"Primary Attribute\" or referenced attribute not found.")).append("\n").append("\n");
        documentObject.streamHierarchicalChildren().forEach(childDocumentObject -> this.serializeDocumentObject((HierarchicalNode)childDocumentObject, stringBuilder));
    }

    void serializeDocument(HierarchicalNode hierarchicalNode, StringBuilder stringBuilder) {
        if (!(hierarchicalNode instanceof Document)) {
            throw new NodeWrongTypeException(hierarchicalNode.getIdentifier(), hierarchicalNode, Document.class);
        }
        Document document = (Document)hierarchicalNode;
        stringBuilder.append("# 1 ").append(document.getName());
        if (printHeadingsWithTypes) {
            stringBuilder.append(" ( ").append(document.getTypeDescription()).append(" )");
        }
        stringBuilder.append("\n").append("\n");
        document.streamHierarchicalChildren().forEach(documentObject -> this.serializeDocumentObject((HierarchicalNode)documentObject, stringBuilder));
    }

    @Override
    public InputStream apply(DocumentMap documentMap) {
        StringBuilder stringBuilder = new StringBuilder(bufferSize);
        documentMap.streamHierarchicalChildren().forEach(document -> this.serializeDocument((HierarchicalNode)document, stringBuilder));
        return new CharSequenceInputStream((CharSequence)stringBuilder, "UTF-8", bufferSize);
    }
}

