/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCacheKey;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.logger.Log;

abstract class AbstractPublishingTemplateProvider
implements PublishingTemplateProvider {
    private final Log logger;
    protected PublishingTemplateCache publishingTemplateCache;

    public AbstractPublishingTemplateProvider(Log logger) {
        this.logger = logger;
    }

    @Override
    public void deleteCache() {
        this.publishingTemplateCache.deleteCache();
    }

    @Override
    public Optional<PublishingTemplateInternal> getTemplate(PublishingTemplateRequest publishingTemplateRequest, boolean isNoTags) {
        if (publishingTemplateRequest.isByOptions()) {
            return this.publishingTemplateCache.findFirstTemplate(PublishingTemplateCacheKey.NAME, publishingTemplateRequest.getOption()).or(() -> this.publishingTemplateCache.findFirstTemplateByMatchCriteria(this.getPossibleTemplateNamesOrderedBySpecialization(publishingTemplateRequest, isNoTags)));
        }
        return this.publishingTemplateCache.findFirstTemplate(PublishingTemplateCacheKey.IDENTIFIER, publishingTemplateRequest.getTemplateId());
    }

    @Override
    public Optional<PublishingTemplateInternal> getTemplate(PublishingTemplateCacheKey primaryKey, String secondaryKey) {
        return this.publishingTemplateCache.findFirstTemplate(primaryKey, secondaryKey);
    }

    private List<String> getPossibleTemplateNamesOrderedBySpecialization(PublishingTemplateRequest publishingTemplateRequest, boolean isNoTags) {
        String isNoTagsString;
        String rendererId = publishingTemplateRequest.getRendererId();
        String presentationType = publishingTemplateRequest.getPresentationType();
        String publishArtifactTypeName = publishingTemplateRequest.getPublishArtifactTypeName();
        String option = publishingTemplateRequest.getOption();
        if (Objects.isNull(rendererId) || Objects.isNull(presentationType)) {
            throw new OseeArgumentException("Invalid renderer[%s] or presentationType[%s]", new Object[]{rendererId == null ? "null" : rendererId, presentationType == null ? "null" : presentationType});
        }
        ArrayList<String> list = new ArrayList<String>();
        String string = isNoTagsString = isNoTags ? " NO TAGS" : "";
        if (Objects.nonNull(publishArtifactTypeName) && Objects.nonNull(option)) {
            list.add(String.valueOf(rendererId) + " " + publishArtifactTypeName + " " + presentationType + " " + option + isNoTagsString);
        }
        if (Objects.nonNull(publishArtifactTypeName)) {
            list.add(String.valueOf(rendererId) + " " + publishArtifactTypeName + " " + presentationType + isNoTagsString);
        }
        if (Objects.nonNull(option)) {
            list.add(String.valueOf(rendererId) + " " + presentationType + " " + option + isNoTagsString);
        }
        list.add(String.valueOf(rendererId) + " " + presentationType + isNoTagsString);
        return list;
    }

    @Override
    public abstract int getApplicabilityRating(PublishingTemplateRequest var1);

    @Override
    public List<String> getPublishingTemplateSafeNames() {
        return this.publishingTemplateCache.getPublishingTemplateSafeNames();
    }
}

