/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;

public abstract class PublishingSharedArtifactsFolder {
    private static PublishingSharedArtifactsFolder createErrorImplementation(String reason, PublishingUtils publishingUtils, PublishingErrorLog publishingErrorLog, BranchId publishingBranchId, String sharedFolderDescription, ArtifactToken sharedFolderArtifactToken) {
        String message = new StringBuilder(1024).append(reason).append("\n").append("   Shared Folder Description: ").append(sharedFolderDescription).append("\n").append("   Publishing Branch Id:      ").append(publishingBranchId.getIdString()).append("\n").append("   Publishing View Id:        ").append(publishingBranchId.getViewId().getIdString()).append("\n").append("   Shared Folder Id:          ").append(sharedFolderArtifactToken.getIdString()).append("\n").toString();
        publishingErrorLog.error(sharedFolderArtifactToken, message);
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return false;
            }

            @Override
            public Optional<ArtifactReadable> getSharedPublishingFolder() {
                return Optional.empty();
            }

            @Override
            public List<ArtifactReadable> getSharedArtifacts(String attributeValue) {
                return List.of();
            }
        };
    }

    public static PublishingSharedArtifactsFolder create(final PublishingUtils publishingUtils, final PublishingErrorLog publishingErrorLog, final BranchId publishingBranchId, final String sharedFolderDescription, final ArtifactToken sharedFolderArtifactToken, final AttributeTypeId childAttributeTypeId) {
        Optional<ArtifactReadable> sharedFolderOptional;
        Objects.requireNonNull(publishingUtils, "PublishingSharedArtifactsFolder::create, parameter \"publishingUtils\" is null.");
        Objects.requireNonNull(publishingErrorLog, "PublishingSharedArtifactsFolder::create, parameter \"publishingErrorLog\" is null.");
        Objects.requireNonNull(publishingBranchId, "PublishingSharedArtifactsFolder::create, parameter \"publishingBranchId\" is null.");
        Objects.requireNonNull(sharedFolderDescription, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderDescription\" is null.");
        Objects.requireNonNull(sharedFolderArtifactToken, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderArtifactToken\" is null.");
        Objects.requireNonNull(childAttributeTypeId, "PublishingSharedArtifactsFolder::create, parameter \"childAttributeTypeId\" is null.");
        if (AttributeTypeId.SENTINEL.equals(childAttributeTypeId)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Attribute Type Identifier is SENTINEL.", publishingUtils, publishingErrorLog, publishingBranchId, sharedFolderDescription, sharedFolderArtifactToken);
        }
        Optional<ArtifactReadable> optional = sharedFolderOptional = sharedFolderArtifactToken instanceof ArtifactReadable ? Optional.of((ArtifactReadable)sharedFolderArtifactToken) : publishingUtils.getArtifactReadableByIdentifierFilteredForView(publishingBranchId, publishingBranchId.getViewId(), (ArtifactId)sharedFolderArtifactToken);
        if (sharedFolderOptional.isEmpty()) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Unable to locate the shared folder.", publishingUtils, publishingErrorLog, publishingBranchId, sharedFolderDescription, sharedFolderArtifactToken);
        }
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return true;
            }

            @Override
            public Optional<ArtifactReadable> getSharedPublishingFolder() {
                return Optional.of((ArtifactReadable)sharedFolderOptional.get());
            }

            @Override
            public List<ArtifactReadable> getSharedArtifacts(String attributeValue) {
                return publishingUtils.getRecursiveChildenArtifactReadablesByAttributeTypeAndAttributeValue(publishingBranchId, publishingBranchId.getViewId(), (ArtifactId)sharedFolderArtifactToken, childAttributeTypeId, attributeValue).orElseGet(() -> {
                    StringBuilder message = new StringBuilder(1024).append("Failed to get artifacts from the shared folder.").append("\n").append("   Shared Folder Description: ").append(sharedFolderDescription).append("\n").append("   Publishing Branch Id:      ").append(publishingBranchId.getIdString()).append("\n").append("   Publishing View Id:        ").append(publishingBranchId.getViewId().getIdString()).append("\n").append("   Shared Folder Id:          ").append(sharedFolderArtifactToken.getIdString()).append("\n").append("   Search Attribute Type Id:  ").append(childAttributeTypeId.getIdString()).append("\n").append("   Search Attribute Value:    ").append(attributeValue).append("\n");
                    publishingUtils.getLastError().ifPresent(reason -> {
                        StringBuilder stringBuilder2 = message.append("   Reason Follows:").append("\n").append(reason.getMessage());
                    });
                    publishingErrorLog.error(sharedFolderArtifactToken, message.toString());
                    return List.of();
                });
            }
        };
    }

    public static PublishingSharedArtifactsFolder create(final PublishingUtils publishingUtils, final PublishingErrorLog publishingErrorLog, final BranchId publishingBranchId, final String sharedFolderDescription, final ArtifactToken sharedFolderArtifactToken, final ArtifactTypeToken childArtifactTypeToken, final AttributeTypeId childAttributeTypeId) {
        Optional<ArtifactReadable> sharedFolderOptional;
        Objects.requireNonNull(publishingUtils, "PublishingSharedArtifactsFolder::create, parameter \"publishingUtils\" is null.");
        Objects.requireNonNull(publishingErrorLog, "PublishingSharedArtifactsFolder::create, parameter \"publishingErrorLog\" is null.");
        Objects.requireNonNull(publishingBranchId, "PublishingSharedArtifactsFolder::create, parameter \"publishingBranchId\" is null.");
        Objects.requireNonNull(sharedFolderDescription, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderDescription\" is null.");
        Objects.requireNonNull(sharedFolderArtifactToken, "PublishingSharedArtifactsFolder::create, parameter \"sharedFolderArtifactToken\" is null.");
        Objects.requireNonNull(childArtifactTypeToken, "PublishingSharedArtifactsFolder::create, parameter \"childArtifactTypeToken\" is null.");
        Objects.requireNonNull(childAttributeTypeId, "PublishingSharedArtifactsFolder::create, parameter \"childAttributeTypeId\" is null.");
        if (AttributeTypeId.SENTINEL.equals(childAttributeTypeId)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Attribute Type Identifier is SENTINEL.", publishingUtils, publishingErrorLog, publishingBranchId, sharedFolderDescription, sharedFolderArtifactToken);
        }
        if (ArtifactTypeToken.SENTINEL.equals(childArtifactTypeToken)) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Child Artifact Type Token is SENTINEL.", publishingUtils, publishingErrorLog, publishingBranchId, sharedFolderDescription, sharedFolderArtifactToken);
        }
        Optional<ArtifactReadable> optional = sharedFolderOptional = sharedFolderArtifactToken instanceof ArtifactReadable ? Optional.of((ArtifactReadable)sharedFolderArtifactToken) : publishingUtils.getArtifactReadableByIdentifierFilteredForView(publishingBranchId, publishingBranchId.getViewId(), (ArtifactId)sharedFolderArtifactToken);
        if (sharedFolderOptional.isEmpty()) {
            return PublishingSharedArtifactsFolder.createErrorImplementation("Unable to locate the shared folder.", publishingUtils, publishingErrorLog, publishingBranchId, sharedFolderDescription, sharedFolderArtifactToken);
        }
        return new PublishingSharedArtifactsFolder(){

            @Override
            public boolean sharedPublishingFolderFound() {
                return true;
            }

            @Override
            public Optional<ArtifactReadable> getSharedPublishingFolder() {
                return Optional.of((ArtifactReadable)sharedFolderOptional.get());
            }

            @Override
            public List<ArtifactReadable> getSharedArtifacts(String attributeValue) {
                return publishingUtils.getRecursiveChildenArtifactReadablesOfTypeByAttributeTypeAndAttributeValue(publishingBranchId, publishingBranchId.getViewId(), (ArtifactId)sharedFolderArtifactToken, childArtifactTypeToken, childAttributeTypeId, attributeValue).orElseGet(() -> {
                    StringBuilder message = new StringBuilder(1024).append("Failed to get artifacts from the shared folder.").append("\n").append("   Shared Folder Description: ").append(sharedFolderDescription).append("\n").append("   Publishing Branch Id:      ").append(publishingBranchId.getIdString()).append("\n").append("   Publishing View Id:        ").append(publishingBranchId.getViewId().getIdString()).append("\n").append("   Shared Folder Id:          ").append(sharedFolderArtifactToken.getIdString()).append("\n").append("   Search Artifact Type:      ").append(childArtifactTypeToken.getName()).append("\n").append("   Search Attribute Type Id:  ").append(childAttributeTypeId.getIdString()).append("\n").append("   Search Attribute Value:    ").append(attributeValue).append("\n");
                    publishingUtils.getLastError().ifPresent(reason -> {
                        StringBuilder stringBuilder2 = message.append("   Reason Follows:").append("\n").append(reason.getMessage());
                    });
                    publishingErrorLog.error(sharedFolderArtifactToken, message.toString());
                    return List.of();
                });
            }
        };
    }

    public abstract boolean sharedPublishingFolderFound();

    public abstract Optional<ArtifactReadable> getSharedPublishingFolder();

    public abstract List<ArtifactReadable> getSharedArtifacts(String var1);
}

