/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceEnumerationSet
extends PLGenericDBObject {
    public static final InterfaceEnumerationSet SENTINEL = new InterfaceEnumerationSet();
    private String Description = "";
    private ApplicabilityToken applicability = ApplicabilityToken.SENTINEL;
    private List<InterfaceEnumeration> enumerations = new LinkedList<InterfaceEnumeration>();
    private ArtifactReadable artifactReadable = ArtifactReadable.SENTINEL;

    public InterfaceEnumerationSet(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceEnumerationSet(ArtifactReadable art) {
        super(art);
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        art.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationState).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).forEach(a -> {
            boolean bl = this.getEnumerations().add(new InterfaceEnumeration((ArtifactReadable)a));
        });
        this.artifactReadable = art;
        if (!this.getEnumerations().isEmpty()) {
            String desc = "";
            for (InterfaceEnumeration enumeration : this.getEnumerations()) {
                if (!enumeration.isValid()) continue;
                desc = String.valueOf(desc) + enumeration.getOrdinal() + " = " + enumeration.getName() + "\n";
            }
            this.setDescription(desc.trim());
        }
    }

    public InterfaceEnumerationSet(Long id, String name) {
        super(id, name);
    }

    public InterfaceEnumerationSet() {
        this(Id.SENTINEL, "");
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public List<InterfaceEnumeration> getEnumerations() {
        return this.enumerations;
    }

    public void setEnumerations(List<InterfaceEnumeration> enumerations) {
        this.enumerations = enumerations;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

