/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthOverview {
    private final JdbcClient jdbcClient;

    public ServerHealthOverview(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        List<String> servers = ServerUtils.getServers(this.jdbcClient);
        if (servers.size() == 0) {
            return AHTML.simplePage((String)"No osee.health.servers configured in osee_info table");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>OSEE Health - Server Health - Overview</h3>");
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)3));
        LinkedList<String> headers = new LinkedList<String>();
        headers.add("Server:Port (select to see server status)");
        headers.add("Server Alive");
        headers.add("DB Alive");
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        for (String server : servers) {
            this.addServer(sb, server);
        }
        sb.append(AHTML.endMultiColumnTable());
        String html = AHTML.simplePage((String)sb.toString());
        return html;
    }

    private void addServer(StringBuilder sb, String server) {
        String results;
        LinkedList<String> values = new LinkedList<String>();
        String statusUrl = "http://" + server + "/server/health/status";
        values.add(AHTML.getHyperlinkNewTab((String)statusUrl, (String)server));
        String urlStr = String.format("http://%s%s", server, "/ide/versions");
        try {
            results = ServerUtils.getUrlResults(urlStr);
            if (results.contains("\"versions\"")) {
                values.add(ServerUtils.getImage("greenDot.png", urlStr));
            } else {
                values.add(ServerUtils.getImage("redDot.png", urlStr));
            }
        }
        catch (Exception exception) {
            values.add(ServerUtils.getImage("redDot.png", urlStr));
        }
        urlStr = String.format("http://%s%s", server, "/orcs/branches");
        try {
            results = ServerUtils.getUrlResults(urlStr);
            if (results.contains("\"System Root Branch\"")) {
                values.add(ServerUtils.getImage("greenDot.png", urlStr));
            } else {
                values.add(ServerUtils.getImage("redDot.png", urlStr));
            }
        }
        catch (Exception exception) {
            values.add(ServerUtils.getImage("redDot.png", urlStr));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
    }
}

