/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadableSerializer;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.HasTransaction;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.OrcsReadable;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;

@JsonSerialize(using=ArtifactReadableSerializer.class)
public interface ArtifactReadable
extends ArtifactToken,
HasTransaction,
OrcsReadable {
    public static final ArtifactReadable SENTINEL = new ArtifactReadableImpl();

    public TransactionId getLastModifiedTransaction();

    public int getAttributeCount(AttributeTypeToken var1);

    public int getAttributeCount(AttributeTypeToken var1, DeletionFlag var2);

    public Collection<AttributeTypeToken> getValidAttributeTypes();

    public Collection<AttributeTypeToken> getExistingAttributeTypes();

    public <T> T getSoleAttributeValue(AttributeTypeToken var1);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, DeletionFlag var2, T var3);

    public <T> T getSoleAttributeValue(AttributeTypeToken var1, T var2);

    public String getSoleAttributeAsString(AttributeTypeToken var1);

    public String getSoleAttributeAsString(AttributeTypeToken var1, String var2);

    public AttributeId getSoleAttributeId(AttributeTypeToken var1);

    public Long getSoleAttributeId(AttributeTypeToken var1, Long var2);

    public <T> List<T> getAttributeValues(AttributeTypeToken var1);

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable();

    default public <T extends EnumToken> boolean attributeMatches(AttributeTypeEnum<T> attributeType, T ... values) {
        EnumToken enumValue = (EnumToken)((Object)this.getSoleAttributeValue(attributeType));
        return enumValue.matches((Id[])values);
    }

    public AttributeReadable<Object> getAttributeById(AttributeId var1);

    public ResultSet<? extends AttributeReadable<Object>> getAttributes();

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken var1);

    public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> var1);

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag var1);

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken var1, DeletionFlag var2);

    default public String getAttributeValuesAsString(AttributeTypeToken attributeType) {
        return Collections.toString((String)", ", this.getAttributeValues(attributeType));
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> var1);

    public int getMaximumRelationAllowed(RelationTypeSide var1);

    public Collection<RelationTypeToken> getValidRelationTypes();

    public Collection<RelationTypeToken> getExistingRelationTypes();

    default public ArtifactReadable getParent() {
        return (ArtifactReadable)Collections.exactlyOne(this.getRelated(CoreRelationTypes.DefaultHierarchical_Parent, ArtifactTypeToken.SENTINEL));
    }

    public List<ArtifactReadable> getDescendants();

    public void getDescendants(List<ArtifactReadable> var1);

    public boolean isDescendantOf(ArtifactToken var1);

    default public List<ArtifactReadable> getAncestors() {
        ArrayList<ArtifactReadable> ancestors = new ArrayList<ArtifactReadable>();
        ArtifactReadable parent = this.getParent();
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    public List<ArtifactReadable> getChildren();

    default public ArtifactReadable getChild() {
        return (ArtifactReadable)Collections.exactlyOne(this.getChildren());
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide var1);

    default public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>();
        for (ArtifactReadable artifact : this.getRelated(relationTypeSide)) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artifactType})) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    default public List<ArtifactToken> getRelatedIds(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType) {
        return Collections.cast(this.getRelated(relationTypeSide, artifactType));
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide var1, DeletionFlag var2);

    public List<ArtifactReadable> getRelated(RelationTypeSide var1, ArtifactTypeToken var2, DeletionFlag var3);

    public boolean areRelated(RelationTypeSide var1, ArtifactReadable var2);

    public int getRelatedCount(RelationTypeSide var1);

    public String getRationale(RelationTypeSide var1, ArtifactReadable var2);

    public ResultSet<IRelationLink> getRelations(RelationTypeSide var1);

    public Collection<ArtifactId> getChildrentIds();

    public List<ArtifactId> getRelatedIds(RelationTypeSide var1);

    public boolean isHistorical();

    public ApplicabilityId getApplicability();

    public ApplicabilityToken getApplicabilityToken();

    public String getSafeName();

    public List<ArtifactReadable> getRelatedList(RelationTypeSide var1);

    public <T> List<T> getAttributeValues(AttributeTypeToken var1, DeletionFlag var2);

    public List<String> fetchAttributesAsStringList(AttributeTypeToken var1);

    default public Collection<String> getTags() {
        return Collections.castAll(this.getAttributeValues(CoreAttributeTypes.StaticId));
    }

    public static class ArtifactReadableImpl
    extends NamedIdBase
    implements ArtifactReadable {
        public ArtifactReadableImpl() {
            super(Id.SENTINEL, "Sentinel");
        }

        @Override
        public ModificationType getModificationType() {
            return ModificationType.SENTINEL;
        }

        @Override
        public BranchToken getBranch() {
            return CoreBranches.COMMON;
        }

        @Override
        public TransactionId getTransaction() {
            return TransactionId.SENTINEL;
        }

        @Override
        public ArtifactTypeToken getArtifactType() {
            return CoreArtifactTypes.Artifact;
        }

        @Override
        public TransactionId getLastModifiedTransaction() {
            return TransactionId.SENTINEL;
        }

        @Override
        public int getAttributeCount(AttributeTypeToken type) {
            return 0;
        }

        @Override
        public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
            return 0;
        }

        @Override
        public Collection<AttributeTypeToken> getValidAttributeTypes() {
            return null;
        }

        @Override
        public Collection<AttributeTypeToken> getExistingAttributeTypes() {
            return null;
        }

        @Override
        public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
            return null;
        }

        @Override
        public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, T defaultValue) {
            return null;
        }

        @Override
        public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public String getSoleAttributeAsString(AttributeTypeToken attributeType, String defaultValue) {
            return null;
        }

        @Override
        public AttributeId getSoleAttributeId(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public Long getSoleAttributeId(AttributeTypeToken attributeType, Long defaultValue) {
            return null;
        }

        @Override
        public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
            return null;
        }

        @Override
        public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
            return null;
        }

        @Override
        public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
            return null;
        }

        @Override
        public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> attributeType) {
            return null;
        }

        @Override
        public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
            return null;
        }

        @Override
        public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
            return null;
        }

        @Override
        public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
            return null;
        }

        @Override
        public int getMaximumRelationAllowed(RelationTypeSide relationTypeSide) {
            return 0;
        }

        @Override
        public Collection<RelationTypeToken> getValidRelationTypes() {
            return null;
        }

        @Override
        public Collection<RelationTypeToken> getExistingRelationTypes() {
            return null;
        }

        @Override
        public List<ArtifactReadable> getDescendants() {
            return null;
        }

        @Override
        public void getDescendants(List<ArtifactReadable> descendants) {
        }

        @Override
        public boolean isDescendantOf(ArtifactToken parent) {
            return false;
        }

        @Override
        public List<ArtifactReadable> getChildren() {
            return null;
        }

        @Override
        public ResultSet<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide) {
            return null;
        }

        @Override
        public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, DeletionFlag deletionFlag) {
            return null;
        }

        @Override
        public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, DeletionFlag deletionFlag) {
            return null;
        }

        @Override
        public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
            return false;
        }

        @Override
        public int getRelatedCount(RelationTypeSide typeAndSide) {
            return 0;
        }

        @Override
        public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
            return null;
        }

        @Override
        public ResultSet<IRelationLink> getRelations(RelationTypeSide relationTypeSide) {
            return null;
        }

        @Override
        public Collection<ArtifactId> getChildrentIds() {
            return null;
        }

        @Override
        public List<ArtifactId> getRelatedIds(RelationTypeSide relationTypeSide) {
            return null;
        }

        @Override
        public boolean isHistorical() {
            return false;
        }

        @Override
        public ApplicabilityId getApplicability() {
            return ApplicabilityId.BASE;
        }

        @Override
        public String getSafeName() {
            return null;
        }

        @Override
        public List<ArtifactReadable> getRelatedList(RelationTypeSide relationTypeSide) {
            return null;
        }

        @Override
        public <T> List<T> getAttributeValues(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
            return null;
        }

        @Override
        public List<String> fetchAttributesAsStringList(AttributeTypeToken attributeType) {
            return null;
        }

        @Override
        public ApplicabilityToken getApplicabilityToken() {
            return ApplicabilityToken.BASE;
        }
    }
}

