/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.framework.resource.management.exception.MalformedLocatorException;
import org.eclipse.osee.framework.resource.management.util.Resource;
import org.eclipse.osee.framework.resource.management.util.ResourceLocator;
import org.eclipse.osee.framework.resource.management.util.Resources;

public class OptionsProcessor {
    private final URI fileuri;
    private final URI locatoruri;
    private final IResource resource;
    private final String extension;
    private final boolean deCompressOnSave;
    private final boolean shouldCompress;
    private final boolean decompressOnAcquire;
    private final boolean compressOnAcquire;
    private final boolean overwrite;

    public OptionsProcessor(URI uri, IResourceLocator locator, IResource resource, PropertyStore options) throws MalformedLocatorException {
        this.resource = resource;
        this.decompressOnAcquire = options.getBoolean(StandardOptions.DecompressOnAquire.name());
        this.compressOnAcquire = options.getBoolean(StandardOptions.CompressOnAcquire.name());
        this.overwrite = options.getBoolean(StandardOptions.Overwrite.name());
        this.shouldCompress = options.getBoolean(StandardOptions.CompressOnSave.name());
        this.deCompressOnSave = options.getBoolean(StandardOptions.DecompressOnSave.name());
        this.extension = options.get(StandardOptions.Extension.name());
        StringBuilder sb = new StringBuilder(uri.toString());
        StringBuilder sb2 = new StringBuilder(locator.toString());
        if (Strings.isValid((String)this.extension)) {
            sb.append(".");
            sb.append(this.extension);
            sb2.append(".");
            sb2.append(this.extension);
        }
        if (this.shouldCompress) {
            sb.append(".");
            sb.append("zip");
            sb2.append(".");
            sb2.append("zip");
        }
        try {
            this.fileuri = new URI(sb.toString());
        }
        catch (URISyntaxException ex) {
            throw new MalformedLocatorException(sb.toString(), ex);
        }
        try {
            this.locatoruri = new URI(sb2.toString());
        }
        catch (URISyntaxException ex) {
            throw new MalformedLocatorException(sb2.toString(), ex);
        }
    }

    public File getStorageFile() {
        File storageFile = new File(this.fileuri);
        if (!this.overwrite && storageFile.exists()) {
            throw new OseeStateException("The file [%s] already exists.", new Object[]{storageFile.getAbsolutePath()});
        }
        File parent = storageFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new OseeCoreException("The path [%s] could not be created.  Check permissions.", new Object[]{parent});
        }
        return storageFile;
    }

    public IResource getResourceToStore() {
        IResource resourceToReturn = this.shouldCompress && !this.resource.isCompressed() ? Resources.compressResource(this.resource) : (this.deCompressOnSave && this.resource.isCompressed() ? Resources.decompressResource(this.resource) : this.resource);
        return resourceToReturn;
    }

    public IResource getResourceToServer() {
        IResource toReturn = null;
        File testFile = new File(this.fileuri);
        if (testFile.exists()) {
            boolean isCompressed = Lib.isCompressed((File)testFile);
            toReturn = new Resource(this.fileuri, isCompressed);
            if (this.compressOnAcquire && !isCompressed) {
                toReturn = Resources.compressResource(toReturn);
            } else if (this.decompressOnAcquire && isCompressed) {
                toReturn = Resources.decompressResource(toReturn);
            }
        }
        return toReturn;
    }

    public IResourceLocator getActualResouceLocator() {
        return new ResourceLocator(this.locatoruri);
    }
}

