/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.metrics.SoftwareReqVolatilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;

public final class SoftwareReqVolatilityMetrics
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    private final boolean implDetails;
    Collection<IAtsTask> tasksMissingChangeType = new ArrayList<IAtsTask>();
    private ExcelXmlWriter writer;
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    Pattern UI_IMPL = Pattern.compile("\\(Impl Details\\)");
    private final SoftwareReqVolatilityId[] reportColumns = new SoftwareReqVolatilityId[]{SoftwareReqVolatilityId.ACT, SoftwareReqVolatilityId.TW, SoftwareReqVolatilityId.ActionName, SoftwareReqVolatilityId.Program, SoftwareReqVolatilityId.Build, SoftwareReqVolatilityId.Date, SoftwareReqVolatilityId.Completed, SoftwareReqVolatilityId.AddedReq, SoftwareReqVolatilityId.ModifiedReq, SoftwareReqVolatilityId.DeletedReq, SoftwareReqVolatilityId.AddedImpl, SoftwareReqVolatilityId.ModifiedImpl, SoftwareReqVolatilityId.DeletedImpl};

    public SoftwareReqVolatilityMetrics(OrcsApi orcsApi, AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime, boolean implDetails) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
        this.implDetails = implDetails;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            try {
                this.writer.endWorkbook();
            }
            catch (IOException ex1) {
                throw new WebApplicationException((Throwable)ex1);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        Collection<IAtsTeamWorkflow> reqWorkflows = this.getDatedWorkflows();
        if (!reqWorkflows.isEmpty()) {
            this.writer.startSheet("SRV", this.reportColumns.length);
            this.fillActionableData(reqWorkflows);
        }
    }

    private Collection<IAtsTeamWorkflow> getDatedWorkflows() {
        ArtifactToken versionId = this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(AtsArtifactTypes.Version, (AttributeTypeToken)CoreAttributeTypes.Name, this.targetVersion, (BranchId)this.atsApi.getAtsBranch());
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsTeamWorkflow> reqWorkflows = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            if (!workflow.isWorkType(WorkType.Requirements) || !workflow.isCompleted() || !this.allTime && (!workflow.getCompletedDate().after(this.startDate) || !workflow.getCompletedDate().before(this.endDate))) continue;
            reqWorkflows.add(workflow);
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return reqWorkflows;
    }

    private void fillActionableData(Collection<IAtsTeamWorkflow> reqWorkflows) throws IOException {
        int numColumns = this.reportColumns.length;
        if (!this.implDetails) {
            numColumns -= 3;
        }
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.reportColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsTeamWorkflow reqWorkflow : reqWorkflows) {
            Date completedDate = new Date();
            try {
                completedDate = reqWorkflow.getCompletedDate();
                buffer[6] = !completedDate.equals(new Date(0L)) ? completedDate : "";
            }
            catch (Exception exception) {
                buffer[6] = "Missing or Multiple Values";
            }
            String changeReportData = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)reqWorkflow, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"");
            if (changeReportData.isEmpty()) continue;
            List changeItems = JsonUtil.readValues((String)changeReportData, ChangeItem.class);
            buffer[0] = reqWorkflow.getParentAction().getAtsId();
            buffer[1] = reqWorkflow.getAtsId();
            buffer[2] = reqWorkflow.getName();
            buffer[3] = this.programVersion;
            buffer[4] = this.targetVersion;
            Date createdDate = new Date();
            try {
                createdDate = reqWorkflow.getCreatedDate();
                buffer[5] = !createdDate.equals(new Date(0L)) ? createdDate : "";
            }
            catch (Exception exception) {
                buffer[5] = "Missing or Multiple Values";
            }
            ArrayList<ChangeItem> attrChangeItems = new ArrayList<ChangeItem>();
            HashMap<ArtifactId, ChangeItem> artChangeItems = new HashMap<ArtifactId, ChangeItem>();
            for (ChangeItem changeItem : changeItems) {
                if (changeItem.getChangeType().equals((Object)ChangeType.Attribute) && changeItem.getIgnoreType().equals((Object)ChangeIgnoreType.NONE) && changeItem.getItemTypeId().equals(CoreAttributeTypes.WordTemplateContent)) {
                    attrChangeItems.add(changeItem);
                    continue;
                }
                if (!changeItem.getChangeType().equals((Object)ChangeType.Artifact)) continue;
                artChangeItems.put(changeItem.getArtId(), changeItem);
            }
            int swAdded = 0;
            int swModified = 0;
            int swDeleted = 0;
            int implAdded = 0;
            int implModified = 0;
            int implDeleted = 0;
            for (ChangeItem changeItem : attrChangeItems) {
                ModificationType modType;
                BranchToken workingBranch = this.atsApi.getBranchService().getBranch(reqWorkflow);
                BranchId parentBranch = this.atsApi.getBranchService().getParentBranch((BranchId)workingBranch);
                ArtifactTypeToken artType = ArtifactTypeToken.SENTINEL;
                artType = this.orcsApi.getQueryFactory().fromBranch(parentBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType();
                if (artType.isInvalid() && (artType = this.orcsApi.tokenService().getArtifactTypeOrSentinel(((ChangeItem)artChangeItems.get(changeItem.getArtId())).getItemTypeId().getId())).isInvalid() && (artType = this.orcsApi.getQueryFactory().fromBranch((BranchId)workingBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType()).isInvalid()) continue;
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractImplementationDetails)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++implAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++implModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++implDeleted;
                    continue;
                }
                if (!artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractSoftwareRequirement)) continue;
                modType = changeItem.getNetChange().getModType();
                if (modType.equals(ModificationType.NEW)) {
                    ++swAdded;
                    continue;
                }
                if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                    ++swModified;
                    continue;
                }
                if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                ++swDeleted;
            }
            buffer[7] = swAdded;
            buffer[8] = swModified;
            buffer[9] = swDeleted;
            if (this.implDetails) {
                buffer[10] = implAdded;
                buffer[11] = implModified;
                buffer[12] = implDeleted;
            }
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.writer.endSheet();
    }
}

