/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.rest.metrics.DevProgressItemId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public final class DevProgressMetrics
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    private ExcelXmlWriter writer;
    private final QueryBuilder query;
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    Pattern UI_DELETED = Pattern.compile("^\\(Deleted\\)$");
    private final DevProgressItemId[] actionColumns = new DevProgressItemId[]{DevProgressItemId.ACT, DevProgressItemId.ActionName, DevProgressItemId.Program, DevProgressItemId.Build, DevProgressItemId.Date, DevProgressItemId.Created, DevProgressItemId.WorkType, DevProgressItemId.TW, DevProgressItemId.State, DevProgressItemId.Analyze, DevProgressItemId.Authorize, DevProgressItemId.Implement, DevProgressItemId.Complete, DevProgressItemId.Cancelled, DevProgressItemId.TotalCount, DevProgressItemId.CompletedCount, DevProgressItemId.CancelledCount, DevProgressItemId.TotalAddModCount, DevProgressItemId.CompletedAddModCount, DevProgressItemId.CancelledAddModCount, DevProgressItemId.TotalDeletedCount, DevProgressItemId.CompletedDeletedCount, DevProgressItemId.CancelledDeletedCount};

    public DevProgressMetrics(OrcsApi orcsApi, AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)atsApi.getAtsBranch());
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            try {
                this.writer.endWorkbook();
            }
            catch (IOException ex1) {
                throw new WebApplicationException((Throwable)ex1);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        Collection<IAtsTeamWorkflow> workflows = this.getDatedWorkflows();
        if (!workflows.isEmpty()) {
            Set<IAtsAction> actionableItems = this.getDatedActions(workflows);
            this.writer.startSheet("Non-Periodic Data", this.actionColumns.length);
            this.fillActionableData(actionableItems, this.actionColumns.length);
        }
    }

    private Collection<IAtsTeamWorkflow> getDatedWorkflows() {
        ArtifactReadable versionId = this.query.andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.Name, this.targetVersion).asArtifact();
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsTeamWorkflow> datedWorkflowArts = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            try {
                if (!workflow.isWorkType(WorkType.Requirements) && !workflow.isWorkType(WorkType.Code) && !workflow.isWorkType(WorkType.Test)) continue;
                if (this.allTime) {
                    datedWorkflowArts.add(workflow);
                    continue;
                }
                if (!workflow.getCreatedDate().before(this.endDate) || this.allTime && (workflow.isCompleted() && workflow.getCompletedDate() != null && workflow.getCompletedDate().before(this.startDate) || workflow.isCancelled() && workflow.getCancelledDate() != null && workflow.getCancelledDate().before(this.startDate))) continue;
                datedWorkflowArts.add(workflow);
            }
            catch (Exception exception) {}
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return datedWorkflowArts;
    }

    private Set<IAtsAction> getDatedActions(Collection<IAtsTeamWorkflow> workflows) {
        HashSet<IAtsAction> actionableItems = new HashSet<IAtsAction>();
        for (IAtsTeamWorkflow workflow : workflows) {
            actionableItems.add(workflow.getParentAction());
        }
        return actionableItems;
    }

    private void fillActionableData(Set<IAtsAction> actionableItems, int numColumns) throws IOException {
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.actionColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsAction actionItem : actionableItems) {
            buffer[0] = actionItem.getAtsId();
            buffer[1] = actionItem.getName();
            buffer[2] = this.programVersion;
            buffer[3] = this.targetVersion;
            Date createdDate = new Date();
            for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
                if (!teamWorkflow.getCreatedDate().before(createdDate)) continue;
                createdDate = teamWorkflow.getCreatedDate();
            }
            buffer[5] = createdDate;
            this.fillTeamWfData(buffer, this.endDate, actionItem);
        }
        this.writer.endSheet();
    }

    private void fillTeamWfData(Object[] buffer, Date rowDate, IAtsAction actionItem) {
        int tasksCancelled;
        float tasksCompleted;
        String stateAtDate;
        float[] deletedCounts;
        Collection<IAtsTask> tasks;
        buffer[4] = rowDate;
        IAtsTeamWorkflow requirementsWorkflow = IAtsTeamWorkflow.SENTINEL;
        IAtsTeamWorkflow codeWorkflow = IAtsTeamWorkflow.SENTINEL;
        IAtsTeamWorkflow testWorkflow = IAtsTeamWorkflow.SENTINEL;
        for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
            if (teamWorkflow.isWorkType(WorkType.Requirements)) {
                if (requirementsWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                    requirementsWorkflow = teamWorkflow;
                    continue;
                }
                if (!requirementsWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
                requirementsWorkflow = teamWorkflow;
                continue;
            }
            if (teamWorkflow.isWorkType(WorkType.Code)) {
                if (codeWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                    codeWorkflow = teamWorkflow;
                    continue;
                }
                if (!codeWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
                codeWorkflow = teamWorkflow;
                continue;
            }
            if (!teamWorkflow.isWorkType(WorkType.Test)) continue;
            if (testWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                testWorkflow = teamWorkflow;
                continue;
            }
            if (!testWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
            testWorkflow = teamWorkflow;
        }
        int reqTasks = 0;
        float reqAddModTasks = 0.0f;
        float reqDeletedTasks = 0.0f;
        if (!codeWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)codeWorkflow, rowDate).isEmpty()) {
            tasks = this.getTaskList(codeWorkflow, rowDate);
            deletedCounts = this.getDeletedTaskCount(codeWorkflow, rowDate);
            stateAtDate = this.getStateAtDate((IAtsWorkItem)codeWorkflow, rowDate);
            buffer[6] = "Code";
            buffer[7] = codeWorkflow.getAtsId();
            buffer[8] = stateAtDate;
            if (stateAtDate.equals("None")) {
                buffer[9] = null;
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Analyze")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Analyze");
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Authorize")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Authorize");
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Implement") || stateAtDate.equals("Test")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Completed")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Implement");
                buffer[12] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Completed");
                buffer[13] = null;
            } else if (stateAtDate.equals("Cancelled")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, "Cancelled");
            }
            tasksCompleted = this.getTaskCompleted(codeWorkflow, rowDate, tasks);
            tasksCancelled = this.getTaskCancelled(codeWorkflow, rowDate, tasks);
            buffer[14] = tasks.size();
            buffer[15] = Float.valueOf(tasksCompleted);
            buffer[16] = tasksCancelled;
            buffer[17] = Float.valueOf((float)tasks.size() - deletedCounts[0]);
            buffer[18] = Float.valueOf(tasksCompleted - deletedCounts[1]);
            buffer[19] = Float.valueOf((float)tasksCancelled - deletedCounts[2]);
            buffer[20] = Float.valueOf(deletedCounts[0]);
            buffer[21] = Float.valueOf(deletedCounts[1]);
            buffer[22] = Float.valueOf(deletedCounts[2]);
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!testWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)testWorkflow, rowDate).isEmpty()) {
            tasks = this.getTaskList(testWorkflow, rowDate);
            deletedCounts = this.getDeletedTaskCount(testWorkflow, rowDate);
            stateAtDate = this.getStateAtDate((IAtsWorkItem)testWorkflow, rowDate);
            buffer[6] = "Test";
            buffer[7] = testWorkflow.getAtsId();
            buffer[8] = stateAtDate;
            if (stateAtDate.equals("None")) {
                buffer[9] = null;
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Analyze")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Analyze");
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Authorize")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Authorize");
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Implement") || stateAtDate.equals("Test")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate.equals("Completed")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Implement");
                buffer[12] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Completed");
                buffer[13] = null;
            } else if (stateAtDate.equals("Cancelled")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, "Cancelled");
            }
            reqTasks = tasks.size();
            reqAddModTasks = (float)tasks.size() - deletedCounts[0];
            reqDeletedTasks = deletedCounts[0];
            tasksCompleted = this.getTaskCompleted(testWorkflow, rowDate, tasks);
            tasksCancelled = this.getTaskCancelled(testWorkflow, rowDate, tasks);
            buffer[14] = tasks.size();
            buffer[15] = Float.valueOf(tasksCompleted);
            buffer[16] = tasksCancelled;
            buffer[17] = Float.valueOf((float)tasks.size() - deletedCounts[0]);
            buffer[18] = Float.valueOf(tasksCompleted - deletedCounts[1]);
            buffer[19] = Float.valueOf((float)tasksCancelled - deletedCounts[2]);
            buffer[20] = Float.valueOf(deletedCounts[0]);
            buffer[21] = Float.valueOf(deletedCounts[1]);
            buffer[22] = Float.valueOf(deletedCounts[2]);
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!requirementsWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)requirementsWorkflow, rowDate).isEmpty()) {
            String stateAtDate2 = this.getStateAtDate((IAtsWorkItem)requirementsWorkflow, rowDate);
            buffer[6] = "Requirements";
            buffer[7] = requirementsWorkflow.getAtsId();
            buffer[8] = stateAtDate2;
            if (stateAtDate2.equals("None")) {
                buffer[9] = null;
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate2.equals("Analyze")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Analyze");
                buffer[10] = null;
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate2.equals("Authorize")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Authorize");
                buffer[11] = null;
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate2.equals("Implement") || stateAtDate2.equals("Test")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = null;
            } else if (stateAtDate2.equals("Completed")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Implement");
                buffer[12] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Completed");
                buffer[13] = null;
            } else if (stateAtDate2.equals("Cancelled")) {
                buffer[9] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Analyze");
                buffer[10] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Authorize");
                buffer[11] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Implement");
                buffer[12] = null;
                buffer[13] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, "Cancelled");
            }
            buffer[14] = reqTasks;
            buffer[17] = Float.valueOf(reqAddModTasks);
            buffer[20] = Float.valueOf(reqDeletedTasks);
            if (stateAtDate2.contains("Complete")) {
                buffer[15] = reqTasks;
                buffer[16] = 0;
                buffer[18] = Float.valueOf(reqAddModTasks);
                buffer[19] = 0;
                buffer[21] = Float.valueOf(reqDeletedTasks);
                buffer[22] = 0;
            } else if (stateAtDate2.equals("Cancelled")) {
                buffer[15] = 0;
                buffer[16] = reqTasks;
                buffer[18] = 0;
                buffer[19] = Float.valueOf(reqAddModTasks);
                buffer[21] = 0;
                buffer[22] = Float.valueOf(reqDeletedTasks);
            } else {
                buffer[15] = 0;
                buffer[16] = 0;
                buffer[18] = 0;
                buffer[19] = 0;
                buffer[21] = 0;
                buffer[22] = 0;
            }
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    private String getStateAtDate(IAtsWorkItem teamWorkflow, Date iterationDate) {
        ArrayList<String> stateList = new ArrayList<String>();
        try {
            for (StateDefinition state : teamWorkflow.getWorkDefinition().getStates()) {
                stateList.add(state.getName());
            }
        }
        catch (Exception exception) {}
        String stateName = "";
        Date stateStartDate = new GregorianCalendar(1916, 7, 15).getTime();
        try {
            for (String visitedState : teamWorkflow.getStateMgr().getVisitedStateNames()) {
                Date newStateStartDate;
                if (!stateList.contains(visitedState) || !(newStateStartDate = teamWorkflow.getStateMgr().getStateStartedData(visitedState).getDate()).before(iterationDate) || !newStateStartDate.after(stateStartDate)) continue;
                stateName = visitedState;
                stateStartDate = newStateStartDate;
            }
        }
        catch (Exception exception) {}
        return stateName;
    }

    private Date getStateStartDate(IAtsWorkItem teamWorkflow, Date iterationDate, String stateName) {
        try {
            IAtsLogItem stateStartedData = teamWorkflow.getStateMgr().getStateStartedData(stateName);
            if (stateStartedData.getDate().before(iterationDate)) {
                return stateStartedData.getDate();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Collection<IAtsTask> getTaskList(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        ArrayList<IAtsTask> tasks = new ArrayList<IAtsTask>();
        ArrayList<String> taskUINames = new ArrayList<String>();
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher m = this.UI_NAME.matcher(task.getName());
            if (!m.find()) continue;
            String taskUIName = m.group();
            if (!task.getCreatedDate().before(iterationDate) || taskUINames.contains(taskUIName)) continue;
            taskUINames.add(taskUIName);
            tasks.add(task);
        }
        return tasks;
    }

    private float[] getDeletedTaskCount(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        float[] deletedCounts = new float[3];
        float deletedCount = 0.0f;
        float deletedCompleteCount = 0.0f;
        float deletedCancelledCount = 0.0f;
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher m = this.UI_DELETED.matcher(task.getName());
            if (!m.find()) continue;
            try {
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (!task.getCreatedDate().before(iterationDate)) continue;
                deletedCount += 1.0f;
                if (task.isCompleted() && task.getCompletedDate().before(iterationDate)) {
                    deletedCompleteCount += 1.0f;
                    continue;
                }
                if (task.isCancelled() && task.getCancelledDate().before(iterationDate)) {
                    deletedCancelledCount += 1.0f;
                    continue;
                }
                if (state.getRecommendedPercentComplete() == null || state.getRecommendedPercentComplete() <= 0) continue;
                deletedCompleteCount += (float)(state.getRecommendedPercentComplete() / 100);
            }
            catch (Exception exception) {}
        }
        deletedCounts[0] = deletedCount;
        deletedCounts[1] = deletedCompleteCount;
        deletedCounts[2] = deletedCancelledCount;
        return deletedCounts;
    }

    private float getTaskCompleted(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        float completedTasks = 0.0f;
        for (IAtsTask task : tasks) {
            try {
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (task.isCompleted() && task.getCompletedDate().before(iterationDate) || state.getName().equals("No_Change")) {
                    completedTasks += 1.0f;
                    continue;
                }
                if (state.getRecommendedPercentComplete() == null || state.getRecommendedPercentComplete() <= 0 || state.getName().equals("Cancelled")) continue;
                completedTasks = (float)((double)completedTasks + (double)state.getRecommendedPercentComplete().intValue() / 100.0);
            }
            catch (Exception exception) {}
        }
        return completedTasks;
    }

    private StateDefinition stateNameToDefinition(IAtsWorkItem item, Date iterationDate) {
        for (StateDefinition state : item.getWorkDefinition().getStates()) {
            if (!state.getName().equals(this.getStateAtDate(item, iterationDate))) continue;
            return state;
        }
        return null;
    }

    private int getTaskCancelled(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        ArrayList<IAtsTask> iterationTasks = new ArrayList<IAtsTask>();
        for (IAtsTask task : tasks) {
            try {
                if (!task.isCancelled() || !task.getCancelledDate().before(iterationDate)) continue;
                iterationTasks.add(task);
            }
            catch (Exception exception) {}
        }
        return iterationTasks.size();
    }
}

