/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.ArtifactSearchOptions;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.AttributeEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.DslFactory;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.SearchQueryBuilder;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.AttributeEndpoint;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMatch;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.search.ArtifactTable;
import org.eclipse.osee.orcs.search.ArtifactTableOptions;
import org.eclipse.osee.orcs.search.Match;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ArtifactEndpointImpl
implements ArtifactEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final UriInfo uriInfo;

    public ArtifactEndpointImpl(OrcsApi orcsApi, BranchId branch, UriInfo uriInfo) {
        this.orcsApi = orcsApi;
        this.uriInfo = uriInfo;
        this.branch = branch;
    }

    public SearchResponse getSearchWithMatrixParams(SearchRequest params) {
        long startTime = System.currentTimeMillis();
        SearchQueryBuilder searchQueryBuilder = DslFactory.createQueryBuilder(this.orcsApi);
        QueryBuilder builder = searchQueryBuilder.build(this.orcsApi.getQueryFactory(), params);
        builder.includeDeletedArtifacts(params.isIncludeDeleted());
        if (params.getFromTx().isGreaterThan((Id)TransactionId.valueOf((int)0))) {
            builder.fromTransaction(params.getFromTx());
        }
        SearchResponse result = new SearchResponse();
        RequestType request = params.getRequestType();
        if (request != null) {
            switch (request) {
                case COUNT: {
                    int total = builder.getCount();
                    result.setTotal(total);
                    break;
                }
                case IDS: {
                    List ids = builder.asArtifactIds();
                    result.setIds(ids);
                    result.setTotal(ids.size());
                    break;
                }
                case MATCHES: {
                    ResultSet matches = builder.getMatches();
                    LinkedList<SearchMatch> searchMatches = new LinkedList<SearchMatch>();
                    LinkedList<ArtifactId> matchIds = new LinkedList<ArtifactId>();
                    for (Match match : matches) {
                        ArtifactId artId = (ArtifactId)match.getItem();
                        matchIds.add(artId);
                        for (AttributeReadable attribute : match.getElements()) {
                            List locations = match.getLocation((Object)attribute);
                            searchMatches.add(new SearchMatch(artId, (AttributeId)attribute, locations));
                        }
                    }
                    result.setIds(matchIds);
                    result.setMatches(searchMatches);
                    result.setTotal(searchMatches.size());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        result.setSearchRequest(params);
        result.setSearchTime(System.currentTimeMillis() - startTime);
        return result;
    }

    public String getRootChildrenAsHtml() {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        ArtifactReadable rootArtifact = query.andIsHeirarchicalRootArtifact().getArtifact();
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        return writer.toHtml(rootArtifact.getChildren());
    }

    public String getArtifactAsHtml(ArtifactId artifactId) {
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return writer.toHtml((Iterable<? extends Object>)query.andId(artifactId).getResults());
    }

    public ArtifactToken getArtifactToken(ArtifactId artifactId) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andId(artifactId).asArtifactToken();
    }

    public AttributeEndpoint getAttributes(ArtifactId artifactId) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return new AttributeEndpointImpl(artifactId, this.branch, this.orcsApi, query, this.uriInfo);
    }

    private <T> T getArtifactXByAttribute(QueryBuilder query, AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType, Supplier<T> queryMethod) {
        if (artifactType.isValid()) {
            query.andIsOfType(new ArtifactTypeToken[]{artifactType});
        }
        if (attributeType.isValid()) {
            if (exists) {
                query.andAttributeIs((AttributeTypeId)attributeType, value);
            } else {
                query.andNotExists(attributeType, value);
            }
        }
        return queryMethod.get();
    }

    public List<ArtifactToken> getArtifactTokensByAttribute(AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactTokens());
    }

    public List<ArtifactId> getArtifactIdsByAttribute(AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactIds());
    }

    public List<Map<String, Object>> getArtifactMaps(AttributeTypeToken attributeType, String representation, String value, boolean exists, ArtifactTypeToken artifactType, ArtifactId view) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch, view);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactMaps());
    }

    public List<ArtifactToken> getArtifactTokensByType(ArtifactTypeToken artifactType) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andTypeEquals(new ArtifactTypeToken[]{artifactType}).asArtifactTokens();
    }

    public List<ArtifactToken> expGetArtifactTokens(ArtifactTypeToken artifactType, ArtifactId parent, ArtifactId view) {
        this.orcsApi.getAdminOps().registerMissingOrcsTypeJoins();
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent).follow(CoreRelationTypes.SupportingRequirement_LowerLevelRequirement).asArtifacts();
        return Collections.cast((Collection)artifacts);
    }

    public List<ArtifactToken> getChangedArtifactTokens(ArtifactId view, AttributeTypeJoin typeJoin, String commentPattern) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andTxComment(commentPattern, typeJoin).asArtifactTokens();
    }

    public List<ArtifactId> getArtifactIdsByType(ArtifactTypeToken artifactType) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andTypeEquals(new ArtifactTypeToken[]{artifactType}).asArtifactIds();
    }

    public List<ArtifactToken> getArtifactTokensByApplicability(ApplicabilityId appId) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, appId).asArtifactTokens();
    }

    public List<ArtifactToken> createArtifacts(BranchId branch, ArtifactTypeToken artifactType, ArtifactId parent, List<String> names) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - create artifacts");
        List tokens = tx.createArtifacts(artifactType, parent, names);
        tx.commit();
        return tokens;
    }

    public ArtifactToken createArtifact(BranchId branch, ArtifactTypeToken artifactType, ArtifactId parent, String name) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - create artifact");
        ArtifactToken token = tx.createArtifact(parent, artifactType, name);
        tx.commit();
        return token;
    }

    public List<ArtifactToken> changeArtifactType(BranchId branch, ArtifactTypeToken oldType, ArtifactTypeToken newType, List<String> names) {
        OrcsAdmin adminOps = this.orcsApi.getAdminOps();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch);
        ArrayList<ArtifactToken> artifacts = new ArrayList<ArtifactToken>();
        for (String name : names) {
            try {
                artifacts.add(query.andTypeEquals(new ArtifactTypeToken[]{oldType}).andNameEquals(name).asArtifactToken());
            }
            catch (MultipleItemsExist ex) {
                throw new MultipleItemsExist(String.valueOf(ex.getLocalizedMessage()) + "  named " + name, new Object[0]);
            }
        }
        adminOps.changeArtifactTypeOutsideofHistory((ArtifactTypeId)newType, artifacts);
        return artifacts;
    }

    public TransactionToken deleteArtifact(BranchId branch, ArtifactId artifact) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - delete artifact");
        tx.deleteArtifact(artifact);
        return tx.commit();
    }

    public TransactionToken setSoleAttributeValue(BranchId branch, ArtifactId artifact, AttributeTypeToken attributeType, String value) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - setSoleAttributeValue");
        tx.setSoleAttributeFromString(artifact, attributeType, value);
        return tx.commit();
    }

    private QueryBuilder getQueryBuilder(ArtifactSearchOptions searchCriteria) {
        QueryBuilder fromBranch;
        QueryOption matchCase = QueryOption.getCaseType((boolean)searchCriteria.isCaseSensitive());
        QueryOption matchWordOrder = QueryOption.getTokenOrderType((boolean)searchCriteria.isMatchWordOrder());
        QueryOption matchExact = QueryOption.TOKEN_DELIMITER__ANY;
        if (searchCriteria.isExactMatch()) {
            matchCase = QueryOption.CASE__MATCH;
            matchWordOrder = QueryOption.TOKEN_MATCH_ORDER__MATCH;
            matchExact = QueryOption.TOKEN_DELIMITER__EXACT;
        }
        if (!searchCriteria.getArtIds().isEmpty()) {
            fromBranch = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIds((Collection)searchCriteria.getArtIds());
        } else {
            fromBranch = searchCriteria.getView().isValid() ? this.orcsApi.getQueryFactory().fromBranch(this.branch, searchCriteria.getView()) : (searchCriteria.getApplic().isValid() ? this.orcsApi.getQueryFactory().fromBranch(this.branch, searchCriteria.getApplic()) : this.orcsApi.getQueryFactory().fromBranch(this.branch));
            if (!searchCriteria.getArtTypeIds().isEmpty()) {
                fromBranch.andIsOfType((Collection)searchCriteria.getArtTypeIds());
            }
            if (Strings.isValid((String)searchCriteria.getSearchString())) {
                if (searchCriteria.getAttrTypeIds().isEmpty()) {
                    List attrs = searchCriteria.getAttrTypeIds();
                    attrs.add(QueryBuilder.ANY_ATTRIBUTE_TYPE);
                    searchCriteria.setAttrTypeIds(attrs);
                }
                fromBranch.and((Collection)searchCriteria.getAttrTypeIds(), searchCriteria.getSearchString(), new QueryOption[]{matchCase, matchWordOrder, matchExact});
            }
        }
        if (searchCriteria.getIncludeDeleted().areDeletedAllowed()) {
            fromBranch.includeDeletedArtifacts();
        }
        return fromBranch;
    }

    public List<ArtifactId> findArtifactIds(ArtifactSearchOptions searchOptions) {
        return this.getQueryBuilder(searchOptions).asArtifactIds();
    }

    public List<ArtifactToken> findArtifactTokens(ArtifactSearchOptions searchOptions) {
        return this.getQueryBuilder(searchOptions).asArtifactTokens();
    }

    public ArtifactTable getArtifactTable(AttributeTypeToken attributeType, List<AttributeTypeToken> attributeColumns, String value, boolean exists, ArtifactTypeToken artifactType, ArtifactId view) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch, view);
        query.setTableOptions(new ArtifactTableOptions(attributeColumns));
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactsTable());
    }

    public List<ArtifactReadable> getRelatedArtifactsTree(BranchId branch, ArtifactId artifact) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch);
        return query.andId(artifact).followAll().asArtifacts();
    }
}

