/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing.datarights;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.api.publishing.datarights.DataRight;
import org.eclipse.osee.define.api.publishing.datarights.DataRightAnchorSkinny;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class DataRightAnchor
implements ToMessage {
    private ArtifactId artifactId;
    private DataRight dataRight;
    private Boolean isContinuous = false;
    private Boolean newFooter;

    public DataRightAnchor() {
        this.artifactId = null;
        this.dataRight = null;
        this.newFooter = null;
        this.isContinuous = null;
    }

    public DataRightAnchor(ArtifactId artifactId, DataRight dataRight, Boolean isSetDataRightFooter) {
        this.artifactId = Objects.requireNonNull(artifactId, "DataRightAnchor::new, parameter \"artifactId\" cannot be null.");
        this.dataRight = Objects.requireNonNull(dataRight, "DataRightAnchor::new, parameter \"dataRight\" cannot be null.");
        this.newFooter = Objects.requireNonNull(isSetDataRightFooter, "DataRightAnchor::new, parameter \"newFooter\" cannot be null.");
        this.isContinuous = null;
    }

    public DataRightAnchor(DataRightAnchorSkinny dataRightAnchorSkinny, Map<String, DataRight> dataRights) {
        Objects.requireNonNull(dataRightAnchorSkinny, "DataRightAnchor::new, parameter \"dataRightAnchorSkinny\" cannot be null.");
        if (!dataRightAnchorSkinny.isValid()) {
            throw new IllegalArgumentException("DataRightAnchor::new, parameter \"dataRightAnchorSkinny\" is not valid.");
        }
        Objects.requireNonNull(dataRights, "DataRightAnchor::new, parameter \"dataRights\" cannot be null.");
        this.artifactId = dataRightAnchorSkinny.getArtifactId();
        this.newFooter = dataRightAnchorSkinny.getNewFooter();
        this.isContinuous = dataRightAnchorSkinny.getIsContinuous();
        this.dataRight = dataRights.get(dataRightAnchorSkinny.getClassification());
        Objects.requireNonNull(this.dataRight, "DataRightAnchor::new, the \"DataRight\" obtained from the parameter \"dataRights\" cannot be null.");
        if (!this.dataRight.isValid()) {
            throw new IllegalArgumentException("DataRightAnchor::new, the parameter \"dataRights\" contains an invalid \"DataRight\" object.");
        }
    }

    public ArtifactId getArtifactId() {
        if (Objects.isNull(this.artifactId)) {
            throw new IllegalStateException("DataRightAnchor::getArtifactId, the member \"artifactId\" has not been set.");
        }
        return this.artifactId;
    }

    public DataRight getDataRight() {
        if (Objects.isNull(this.dataRight)) {
            throw new IllegalStateException("DataRightAnchor::getDataRight, the member \"dataRight\" has not been set.");
        }
        return this.dataRight;
    }

    public Boolean getIsContinuous() {
        if (Objects.isNull(this.isContinuous)) {
            throw new IllegalStateException("DataRightAnchor::getIsContinuous, the member \"isContinuous\" has not been set.");
        }
        return this.isContinuous;
    }

    public Boolean getNewFooter() {
        if (Objects.isNull(this.newFooter)) {
            throw new IllegalStateException("DataRightAnchor::getNewFooter, the member \"newFooter\" has not been set.");
        }
        return this.newFooter;
    }

    public boolean isValid() {
        return Objects.nonNull(this.artifactId) && Objects.nonNull(this.dataRight) && this.dataRight.isValid() && Objects.nonNull(this.newFooter) && Objects.nonNull(this.isContinuous);
    }

    public void setArtifactId(ArtifactId artifactId) {
        if (Objects.nonNull(this.artifactId)) {
            throw new IllegalStateException("DataRightAnchor::setArtifactId, the member \"artifactId\" has already been set.");
        }
        this.artifactId = Objects.requireNonNull(artifactId, "DataRightAnchor::setArtifactId, parameter \"artifactId\" cannot be null.");
    }

    public void setDataRight(DataRight dataRight) {
        if (Objects.nonNull(this.dataRight)) {
            throw new IllegalStateException("DataRightAnchor::setDataRight, the member \"dataRight\" has already been set.");
        }
        this.dataRight = Objects.requireNonNull(dataRight, "DataRightAnchor::setDataRight, parameter \"dataRight\" cannot be null.");
    }

    public void setIsContinuous(Boolean isContinuous) {
        if (Objects.nonNull(this.isContinuous)) {
            throw new IllegalStateException("DataRightAnchor::setIsContinuous, the member \"isContinuous\" has already been set.");
        }
        this.isContinuous = Objects.requireNonNull(isContinuous, "DataRightAnchor::setIsContinuous, parameter \"isContinuous\" cannot be null.");
    }

    public void setNewFooter(Boolean newFooter) {
        if (Objects.nonNull(this.newFooter)) {
            throw new IllegalStateException("DataRightAnchor::setIsSetDataRightFooter, the member \"newFooter\" has already been set.");
        }
        this.newFooter = Objects.requireNonNull(newFooter, "DataRightAnchor::setIsSetDataRightFooter, parameter \"newFooter\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Data Right Anchor").indentInc().segment((CharSequence)"artifactId", (Object)this.artifactId).segment((CharSequence)"newFooter", (Object)this.newFooter).segment((CharSequence)"isContinuous", (Object)this.isContinuous).toMessage((ToMessage)this.dataRight).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

