/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceMessageToken
extends PLGenericDBObject {
    public static final InterfaceMessageToken SENTINEL = new InterfaceMessageToken();
    private String Name;
    private String InterfaceMessageNumber;
    private String InterfaceMessagePeriodicity;
    private String InterfaceMessageRate;
    private Boolean InterfaceMessageWriteAccess;
    private String InterfaceMessageType;
    private String Description;
    private List<InterfaceSubMessageToken> subMessages = new LinkedList<InterfaceSubMessageToken>();
    private ApplicabilityToken applicability;
    private InterfaceNode initiatingNode;
    private ArtifactReadable artifactReadable;

    public InterfaceMessageToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceMessageToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceMessageNumber((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber, (Object)""));
        this.setInterfaceMessagePeriodicity(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePeriodicity, ""));
        this.setInterfaceMessageRate(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, ""));
        this.setInterfaceMessageType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, ""));
        this.setInterfaceMessageWriteAccess((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess, (Object)false));
        this.setSubMessages(art.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceSubMessageToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.artifactReadable = art;
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceMessageToken(Long id, String name) {
        super(id, name);
    }

    public InterfaceMessageToken() {
    }

    public String getInterfaceMessageNumber() {
        return this.InterfaceMessageNumber;
    }

    public void setInterfaceMessageNumber(String interfaceMessageNumber) {
        this.InterfaceMessageNumber = interfaceMessageNumber;
    }

    public String getInterfaceMessagePeriodicity() {
        return this.InterfaceMessagePeriodicity;
    }

    public void setInterfaceMessagePeriodicity(String interfaceMessagePeriodicity) {
        this.InterfaceMessagePeriodicity = interfaceMessagePeriodicity;
    }

    public String getInterfaceMessageRate() {
        return this.InterfaceMessageRate;
    }

    public void setInterfaceMessageRate(String interfaceMessageRate) {
        this.InterfaceMessageRate = interfaceMessageRate;
    }

    public Boolean getInterfaceMessageWriteAccess() {
        return this.InterfaceMessageWriteAccess;
    }

    public void setInterfaceMessageWriteAccess(Boolean interfaceMessageWriteAccess) {
        this.InterfaceMessageWriteAccess = interfaceMessageWriteAccess;
    }

    public String getInterfaceMessageType() {
        return this.InterfaceMessageType;
    }

    public void setInterfaceMessageType(String interfaceMessageType) {
        this.InterfaceMessageType = interfaceMessageType;
    }

    public Collection<InterfaceSubMessageToken> getSubMessages() {
        return this.subMessages;
    }

    public void setSubMessages(List<InterfaceSubMessageToken> subMessages) {
        this.subMessages = subMessages;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public InterfaceNode getInitiatingNode() {
        return this.initiatingNode;
    }

    public void setInitiatingNode(InterfaceNode initiatingNode) {
        this.initiatingNode = initiatingNode;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

