/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.AffectedArtifactEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.ArtifactMatch;

public class AffectedArtifactEndpointImpl
implements AffectedArtifactEndpoint {
    private final BranchId branch;
    private final InterfaceConnectionViewApi connectionApi;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;
    private final InterfaceStructureApi structureApi;
    private final InterfaceElementApi elementApi;
    private final InterfacePlatformTypeApi typeApi;
    private final InterfaceEnumerationSetApi enumSetApi;
    private final InterfaceEnumerationApi enumApi;

    public AffectedArtifactEndpointImpl(BranchId branch, InterfaceConnectionViewApi interfaceConnectionApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfacePlatformTypeApi interfacePlatformTypeApi, InterfaceEnumerationSetApi enumSetApi, InterfaceEnumerationApi enumApi) {
        this.branch = branch;
        this.connectionApi = interfaceConnectionApi;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.structureApi = interfaceStructureApi;
        this.elementApi = interfaceElementApi;
        this.typeApi = interfacePlatformTypeApi;
        this.enumSetApi = enumSetApi;
        this.enumApi = enumApi;
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromType(ArtifactId affectedArtifactId) {
        return this.typeApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromElement(ArtifactId affectedArtifactId) {
        return this.elementApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromStructure(ArtifactId affectedArtifactId) {
        return this.structureApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromSubMessage(ArtifactId affectedArtifactId) {
        return this.subMessageApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromMessage(ArtifactId affectedArtifactId) {
        return this.messageApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromEnum(ArtifactId affectedArtifactId) {
        return this.enumApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromEnumSet(ArtifactId affectedArtifactId) {
        return this.enumSetApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedFromConnection(ArtifactId affectedArtifactId) {
        return this.connectionApi.getAffectedArtifacts(this.branch, affectedArtifactId);
    }
}

