/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.tagger;

import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.db.internal.search.tagger.StreamMatcher;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.TextStreamTagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.XmlTagger;
import org.eclipse.osee.orcs.db.internal.search.util.MatcherFactory;

public class TaggingEngine {
    private final TagProcessor tagProcessor;
    private final Tagger plainTextTagger;
    private final Tagger xmlTagger;

    public TaggingEngine(TagProcessor tagProcessor) {
        this.tagProcessor = tagProcessor;
        StreamMatcher matcher = MatcherFactory.createMatcher();
        this.plainTextTagger = new TextStreamTagger(tagProcessor, matcher);
        this.xmlTagger = new XmlTagger(tagProcessor, matcher);
    }

    public TagProcessor getTagProcessor() {
        return this.tagProcessor;
    }

    public Tagger getTagger(TaggerTypeToken taggerType) {
        if (taggerType.equals(TaggerTypeToken.PlainTextTagger)) {
            return this.plainTextTagger;
        }
        if (taggerType.equals(TaggerTypeToken.XmlTagger)) {
            return this.xmlTagger;
        }
        throw new OseeArgumentException("No tagger found for %s", new Object[]{taggerType});
    }
}

