/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class PublishingUtils {
    private final ThreadLocal<Cause> lastCause = new ThreadLocal<Cause>(){

        @Override
        protected Cause initialValue() {
            return Cause.OK;
        }
    };
    private final ThreadLocal<Exception> lastError = new ThreadLocal();
    private final OrcsTokenService orcsTokenService;
    private final QueryFactory queryFactory;

    public PublishingUtils(OrcsApi orcsApi) {
        this.queryFactory = Objects.requireNonNull(orcsApi.getQueryFactory());
        this.orcsTokenService = Objects.requireNonNull(orcsApi.tokenService());
    }

    public Optional<ArtifactReadable> getArtifactReadableByIdentifier(BranchId branchId, ArtifactId viewId, ArtifactId artifactId) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch(branchId, viewId).andId(artifactId).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeAndName(BranchId branchId, ArtifactId viewId, ArtifactTypeToken artifactTypeToken, String artifactName) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch(branchId, viewId).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeNameAndName(BranchId branchId, ArtifactId viewId, String artifactTypeName, String artifactName) {
        return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getArtifactReadableByTypeAndName(branchId, viewId, (ArtifactTypeToken)artifactTypeToken, artifactName));
    }

    public Optional<ArtifactTypeToken> getArtifactTypeTokenByName(String artifactTypeName) {
        this.startOperation();
        try {
            return Optional.of(this.orcsTokenService.getArtifactType(artifactTypeName));
        }
        catch (OseeTypeDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeAndName(BranchId branchId, ArtifactId viewId, ArtifactId parent, ArtifactTypeToken artifactTypeToken, String artifactName) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch(branchId, viewId).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, parent).getArtifact());
        }
        catch (MultipleItemsExist e) {
            this.lastCause.set(Cause.MORE_THAN_ONE);
            this.lastError.set((Exception)((Object)e));
        }
        catch (ItemDoesNotExist e) {
            this.lastCause.set(Cause.NOT_FOUND);
            this.lastError.set((Exception)((Object)e));
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
        }
        return Optional.empty();
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeNameAndName(BranchId branchId, ArtifactId viewId, ArtifactId parent, String artifactTypeName, String artifactName) {
        return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getChildArtifactReadableByTypeAndName(branchId, viewId, parent, (ArtifactTypeToken)artifactTypeToken, artifactName));
    }

    public Cause getLastCause() {
        return this.lastCause.get();
    }

    public Optional<Exception> getLastError() {
        return Optional.ofNullable(this.lastError.get());
    }

    public Optional<List<ArtifactReadable>> getRecursiveChildenArtifactReadablesByAttributeTypeAndAttributeValue(BranchId branchId, ArtifactId viewId, ArtifactId parent, AttributeTypeId attributeTypeId, String value) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch(branchId, viewId).andAttributeIs(attributeTypeId, value).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent).getResults().getList());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<List<ArtifactReadable>> getRecursiveChildenArtifactReadablesOfTypeByAttributeTypeAndAttributeValue(BranchId branchId, ArtifactId viewId, ArtifactId parent, ArtifactTypeToken artifactTypeToken, AttributeTypeId attributeTypeId, String value) {
        this.startOperation();
        try {
            return Optional.of(this.queryFactory.fromBranch(branchId, viewId).andAttributeIs(attributeTypeId, value).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).getResults().getList());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    private void startOperation() {
        this.lastCause.remove();
        this.lastError.remove();
    }

    public static enum Cause {
        ERROR,
        MORE_THAN_ONE,
        NOT_FOUND,
        OK;

    }
}

