/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.rest.internal.writers.reflection.GenericMethodInvoker;
import org.eclipse.osee.orcs.rest.model.GenericReport;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class TemplateReflector {
    Stack<GenericMethodInvoker<GenericReport>> realMethods = new Stack();
    private final GenericReport report;
    private final XResultData results;
    private final ArrayList<Class<?>> allowedReflectors = new ArrayList();

    public TemplateReflector(GenericReport report, XResultData results) {
        this.report = report;
        this.results = results;
    }

    public void pushMethod(GenericMethodInvoker<GenericReport> method) {
        this.realMethods.push(method);
    }

    public GenericReport invokeStack(GenericReport report) {
        while (!this.realMethods.empty()) {
            report = (GenericReport)this.realMethods.pop().invoke(report);
        }
        return report;
    }

    public Object getArgumentFromASTExpression(Expression expression, ListIterator<MethodInvocation> iterator) {
        int type = expression.getNodeType();
        Object toReturn = null;
        switch (type) {
            case 9: {
                toReturn = ((BooleanLiteral)expression).booleanValue();
                break;
            }
            case 34: {
                toReturn = ((NumberLiteral)expression).resolveConstantExpressionValue();
                break;
            }
            case 45: {
                toReturn = ((StringLiteral)expression).getLiteralValue();
                break;
            }
            case 40: {
                QualifiedName qname = (QualifiedName)expression;
                toReturn = this.getArgumentFromQualifiedName(qname);
                break;
            }
            case 32: {
                Object artIdArg;
                MethodInvocation queryMethod = (MethodInvocation)expression;
                String methodName = queryMethod.getName().getFullyQualifiedName();
                if (queryMethod.toString().startsWith("report.query")) {
                    MethodInvocation subQuery = iterator.next();
                    String subMethodName = subQuery.getName().getFullyQualifiedName();
                    this.results.logf("QueryMethodName: %s", new Object[]{subMethodName});
                    GenericMethodInvoker<QueryBuilder> invoker = new GenericMethodInvoker<QueryBuilder>(this.report.query());
                    List args = subQuery.arguments();
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    for (Expression arg : args) {
                        Object result = this.getArgumentFromASTExpression(arg, iterator);
                        this.results.logf("    Arg: %s: type %d", new Object[]{arg.toString(), arg.getNodeType()});
                        arguments.add(result);
                    }
                    if (invoker.set(subMethodName, arguments)) {
                        toReturn = invoker.invoke(this.report.query());
                        break;
                    }
                    this.results.logf("failed to set method for %s", new Object[]{methodName});
                    break;
                }
                if (!queryMethod.toString().startsWith("ArtifactId.valueOf") || !((artIdArg = ((NumberLiteral)queryMethod.arguments().get(0)).resolveConstantExpressionValue()) instanceof Number)) break;
                toReturn = ArtifactId.valueOf((Long)((Number)artIdArg).longValue());
                break;
            }
            default: {
                throw new OseeArgumentException("Invalid argument type %d in %s", new Object[]{type, "TemplateReflector"});
            }
        }
        return toReturn;
    }

    public void setAllowedReflectionClass(Class<?> clazz) {
        this.allowedReflectors.add(clazz);
    }

    private Object getArgumentFromQualifiedName(QualifiedName qname) {
        String qualifier = qname.getQualifier().toString();
        String name = qname.getName().toString();
        try {
            Class<?> clazz = this.getClassFromWhiteList(qualifier);
            Field field = clazz.getDeclaredField(name);
            return field.get(null);
        }
        catch (Exception ex) {
            this.results.errorf("Failed to get argument for %s, full error: %s", new Object[]{qname, ex.toString()});
            return null;
        }
    }

    private Class<?> getClassFromWhiteList(String className) {
        Class<?> toReturn = null;
        for (Class<?> clazz : this.allowedReflectors) {
            if (!clazz.getName().endsWith(className)) continue;
            toReturn = clazz;
        }
        return toReturn;
    }
}

