/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.define.api.OseeHierarchyComparator;
import org.eclipse.osee.define.api.ParagraphNumberComparator;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class PublishLowHighReqStreamingOutput
implements StreamingOutput {
    private final QueryFactory queryApi;
    private final OrcsTokenService tokenService;
    private final BranchToken branch;
    private final ActivityLog activityLog;
    private final Map<String, Integer> summarySubsystemCounter = new HashMap<String, Integer>();
    private final Map<String, Integer> summaryTraceCounter = new HashMap<String, Integer>();
    private ExcelXmlWriter writer;
    private final Collection<ArtifactTypeToken> includeOnlyArtifactTypes;
    private final String REQUIREMENT_TRACE_TYPE = "Requirement Trace";
    private final Map<String, ArtifactTypeToken> allTypesMap = new HashMap<String, ArtifactTypeToken>();
    private static final AttributeTypeToken SRSName = AttributeTypeToken.valueOf((Long)44074994010072549L, (String)"SRS Name");
    private OseeHierarchyComparator hierarchyComparator = null;

    public PublishLowHighReqStreamingOutput(ActivityLog activityLog, OrcsApi orcsApi, BranchId branch, String selectedTypes) {
        this.activityLog = activityLog;
        this.queryApi = orcsApi.getQueryFactory();
        BranchQuery query = orcsApi.getQueryFactory().branchQuery();
        this.branch = (BranchToken)((BranchQuery)query.andId(branch)).getResultsAsId().getExactlyOne();
        this.tokenService = orcsApi.tokenService();
        this.includeOnlyArtifactTypes = this.convertStringTypes(selectedTypes);
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeLowHighReqSheet();
            this.writeHighLowTraceSheet();
            this.writeSummarySheet();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeLowHighReqSheet() throws IOException {
        this.writer.startSheet("Low to High Level Req", new ExcelColumn[]{ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)400.0), ExcelColumn.newCol(null, (double)170.0), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)400.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)350.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)250.0, (String)"OseeWraped")});
        QueryBuilder query = this.queryApi.fromBranch((BranchId)this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.AbstractSoftwareRequirement});
        Object[] objectArray = new String[10];
        objectArray[0] = "Low Level Requirement";
        objectArray[5] = "High Level Requirement";
        Object[] row = objectArray;
        this.writer.writeRow(row);
        row[0] = "Paragraph #";
        row[1] = "Req Name";
        row[2] = "Requirement Type";
        row[3] = "Sw CI Level";
        row[4] = "Qualification Method";
        row[5] = "System Spec ID";
        row[6] = "Paragraph #";
        row[7] = "Req Name";
        row[8] = "Requirement Type";
        row[9] = "Subsystem";
        this.writer.writeRow(row);
        if (this.includeOnlyArtifactTypes == null) {
            this.writer.endSheet();
            return;
        }
        for (ArtifactReadable req : query.getResults().sort((Comparator)new ParagraphNumberComparator(this.activityLog))) {
            List qualificationMethods;
            boolean foundType = false;
            for (ArtifactTypeToken type : this.includeOnlyArtifactTypes) {
                if (!req.isTypeEqual((ArtifactTypeId)type)) continue;
                foundType = true;
                break;
            }
            if (!foundType) continue;
            int i = 0;
            while (i < 10) {
                row[i] = "";
                ++i;
            }
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                row[0] = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber);
            }
            row[1] = req.getName();
            row[2] = req.getArtifactType().getName();
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Category) > 0) {
                row[3] = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Category);
            }
            if ((qualificationMethods = req.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.QualificationMethod)).size() > 0) {
                Iterator iter = qualificationMethods.iterator();
                row[4] = (String)iter.next();
                while (iter.hasNext()) {
                    row[4] = String.valueOf(row[4]) + ", ";
                    row[4] = String.valueOf(row[4]) + (String)iter.next();
                }
            } else {
                row[4] = "";
            }
            ResultSet subSystemRequirements = req.getRelated(CoreRelationTypes.RequirementTrace_HigherLevelRequirement);
            if (subSystemRequirements.size() < 1) {
                int i2 = 0;
                while (i2 < 10) {
                    if (Strings.isInValid((String)row[i2])) {
                        row[i2] = " ";
                    }
                    ++i2;
                }
                this.writer.writeRow(row);
                continue;
            }
            for (ArtifactReadable subSysReq : subSystemRequirements) {
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.LegacyId) > 0) {
                    row[5] = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LegacyId);
                }
                try {
                    row[6] = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber);
                }
                catch (Exception exception) {
                    row[6] = "Paragraph # unavailable";
                }
                row[7] = subSysReq.getName();
                row[8] = subSysReq.getArtifactType().getName();
                String subsystem = "Not specified";
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Subsystem) > 0) {
                    subsystem = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem);
                }
                row[9] = subsystem;
                int i3 = 0;
                while (i3 < 10) {
                    if (Strings.isInValid((String)row[i3])) {
                        row[i3] = " ";
                    }
                    ++i3;
                }
                this.writer.writeRow(row);
                i3 = 0;
                while (i3 < 10) {
                    row[i3] = "";
                    ++i3;
                }
            }
        }
        this.writer.endSheet();
    }

    private void writeHighLowTraceSheet() throws IOException {
        this.writer.startSheet("High to Low Level Req", new ExcelColumn[]{ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0), ExcelColumn.newCol(null, (double)400.0), ExcelColumn.newCol(null, (double)150.0), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)120.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)400.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)85.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)350.0, (String)"OseeWraped"), ExcelColumn.newCol(null, (double)250.0, (String)"OseeWraped")});
        QueryBuilder query = this.queryApi.fromBranch((BranchId)this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.AbstractSystemRequirement});
        Object[] objectArray = new String[11];
        objectArray[0] = "Higher Level Requirement";
        objectArray[6] = "Low Level Requirement";
        Object[] row = objectArray;
        this.writer.writeRow(row);
        row[0] = "System Spec ID";
        row[1] = "Paragraph #";
        row[2] = "Req Name";
        row[3] = "Requirement Type";
        row[4] = "Subsystem";
        row[5] = "Relation Type";
        row[6] = "SwCI Level";
        row[7] = "Paragraph #";
        row[8] = "Req Name";
        row[9] = "Requirement Type";
        row[10] = "Qualification Method";
        this.writer.writeRow(row);
        for (ArtifactReadable req : query.getResults().sort((Comparator)new ParagraphNumberComparator(this.activityLog))) {
            int i = 0;
            while (i < 11) {
                row[i] = "";
                ++i;
            }
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.LegacyId) > 0) {
                row[0] = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LegacyId);
            }
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                row[1] = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber);
            }
            row[2] = req.getName();
            row[3] = req.getArtifactType().getName();
            String subsystem = "Not specified";
            if (req.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Subsystem) > 0) {
                subsystem = req.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem);
            }
            row[4] = subsystem;
            Integer counter = this.summarySubsystemCounter.get(subsystem);
            counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
            this.summarySubsystemCounter.put(subsystem, counter);
            ResultSet subSystemRequirements = req.getRelated(CoreRelationTypes.RequirementTrace_LowerLevelRequirement);
            if (subSystemRequirements.size() < 1) {
                int i2 = 0;
                while (i2 < 11) {
                    if (Strings.isInValid((String)row[i2])) {
                        row[i2] = " ";
                    }
                    ++i2;
                }
                this.writer.writeRow(row);
                continue;
            }
            boolean foundTrace = false;
            for (ArtifactReadable subSysReq : subSystemRequirements) {
                row[5] = "Requirement Trace";
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Category) > 0) {
                    row[6] = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Category);
                }
                if (subSysReq.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) > 0) {
                    row[7] = subSysReq.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber);
                }
                if (this.checkName(subSysReq.getArtifactType().getName())) {
                    this.fixupParagraphNumber((String[])row, subSysReq);
                    row[8] = subSysReq.getSoleAttributeAsString(SRSName);
                } else {
                    row[8] = subSysReq.getName();
                }
                row[9] = subSysReq.getArtifactType().getName();
                List qualificationMethods = subSysReq.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
                if (qualificationMethods.size() > 0) {
                    Iterator iter = qualificationMethods.iterator();
                    row[10] = (String)iter.next();
                    while (iter.hasNext()) {
                        row[10] = String.valueOf(row[10]) + ", ";
                        row[10] = String.valueOf(row[10]) + (String)iter.next();
                    }
                }
                foundTrace = true;
                int i3 = 0;
                while (i3 < 11) {
                    if (Strings.isInValid((String)row[i3])) {
                        row[i3] = " ";
                    }
                    ++i3;
                }
                this.writer.writeRow(row);
                i3 = 0;
                while (i3 < 11) {
                    row[i3] = "";
                    ++i3;
                }
            }
            if (!foundTrace) continue;
            counter = this.summaryTraceCounter.get(subsystem);
            counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
            this.summaryTraceCounter.put(subsystem, counter);
        }
        this.writer.endSheet();
    }

    private void fixupParagraphNumber(String[] row, ArtifactReadable subSysReq) {
        if (this.hierarchyComparator == null) {
            this.hierarchyComparator = new OseeHierarchyComparator(this.activityLog);
            ArtifactReadable grandParent = subSysReq.getParent().getParent();
            List children = this.queryApi.fromBranch((BranchId)this.branch).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)grandParent).getResults().getList();
            children.sort(this.hierarchyComparator);
        }
        if (Strings.isInValid((String)row[7])) {
            row[7] = this.convertParagraphNumber(this.hierarchyComparator.getHierarchyPosition(subSysReq));
        }
    }

    private String convertParagraphNumber(String given) {
        if (given.startsWith("6.9.2")) {
            return given.replaceFirst("6\\.9\\.2", "B\\.1");
        }
        if (given.startsWith("6.9.3")) {
            return given.replaceFirst("6\\.9\\.3", "B\\.2");
        }
        if (given.startsWith("6.9.4")) {
            return given.replaceFirst("6\\.9\\.4", "B\\.3");
        }
        return "";
    }

    private boolean checkName(String name) {
        if ("Warning".equals(name)) {
            return true;
        }
        if ("Caution".equals(name)) {
            return true;
        }
        if ("Advisory".equals(name)) {
            return true;
        }
        if ("Fault".equals(name)) {
            return true;
        }
        return "Exceedance".equals(name);
    }

    private void writeSummarySheet() throws IOException {
        Integer counter;
        this.writer.startSheet("Summary", new ExcelColumn[]{ExcelColumn.newCol(null, (double)300.0), ExcelColumn.newCol(null, (double)300.0, (String)"OseeWraped")});
        this.writer.writeRow(new Object[]{"Branch Name", this.branch.getName()});
        this.writer.writeRow(new Object[]{"Report Date", Calendar.getInstance().getTime()});
        this.writer.endRow();
        Object[] row = new String[]{"Subsystem", "Number of System requirements"};
        this.writer.writeRow(row);
        for (String subsystem : this.summarySubsystemCounter.keySet()) {
            row[0] = subsystem;
            counter = this.summarySubsystemCounter.get(subsystem);
            row[1] = counter.toString();
            this.writer.writeRow(row);
        }
        this.writer.endRow();
        row[0] = "Subsystem";
        row[1] = "Number of System requirements traced to software requirements";
        this.writer.writeRow(row);
        for (String subsystem : this.summaryTraceCounter.keySet()) {
            row[0] = subsystem;
            counter = this.summaryTraceCounter.get(subsystem);
            row[1] = counter.toString();
            this.writer.writeRow(row);
        }
        this.writer.endSheet();
    }

    private Collection<ArtifactTypeToken> convertStringTypes(String csvTypes) {
        if (this.allTypesMap.isEmpty()) {
            for (ArtifactTypeToken type : this.tokenService.getArtifactTypes()) {
                this.allTypesMap.put(type.getName(), type);
            }
        }
        StringTokenizer parser = new StringTokenizer(csvTypes, ",");
        ArrayList<ArtifactTypeToken> theReturn = new ArrayList<ArtifactTypeToken>();
        while (parser.hasMoreTokens()) {
            ArtifactTypeToken type = this.allTypesMap.get(parser.nextToken());
            if (type == null) continue;
            theReturn.add(type);
        }
        if (theReturn.isEmpty()) {
            return null;
        }
        return theReturn;
    }
}

