/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public final class JaxRsExceptions {
    private JaxRsExceptions() {
    }

    public static boolean isErrorResponse(Response response) {
        String header = response.getHeaderString("osee-jaxrs-error-response");
        return Boolean.valueOf(header);
    }

    public static OseeCoreException asOseeException(Response response) {
        String message = "";
        String httpStatus = "";
        if (response == null) {
            message = "Error mapping response exception - response was null";
        } else {
            block9: {
                if (response.getEntity() != null) {
                    if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                        return null;
                    }
                    Object entity = response.getEntity();
                    try {
                        if (JaxRsExceptions.isErrorResponse(response)) {
                            message = JaxRsExceptions.readEntity(response, String.class);
                            break block9;
                        }
                        if (entity instanceof InputStream) {
                            MediaType mediaType = response.getMediaType();
                            message = JaxRsExceptions.readStream((InputStream)entity, mediaType);
                            break block9;
                        }
                        message = String.format("%s [%s]", JaxRsExceptions.getResponseString(response), entity);
                    }
                    catch (Throwable th) {
                        message = String.format("Error processing reponse error - %s [%s]", JaxRsExceptions.getResponseString(response), th.getLocalizedMessage());
                    }
                } else {
                    message = JaxRsExceptions.getResponseString(response);
                }
            }
            message = String.valueOf(message) + ".  HTTP Reason: " + response.getStatusInfo().getReasonPhrase();
            httpStatus = response.getStatusInfo().getReasonPhrase();
        }
        return new OseeCoreException(String.valueOf(message) + ". HTTP Status: " + httpStatus, new Object[0]);
    }

    private static String getResponseString(Response response) {
        StringBuilder builder = new StringBuilder();
        builder.append("status[");
        int statusCode = response.getStatus();
        builder.append(statusCode);
        builder.append("]");
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (status != null) {
            builder.append(" reason[");
            builder.append(status.getReasonPhrase());
            builder.append("]");
        }
        return builder.toString();
    }

    private static <T> T readEntity(Response response, Class<T> clazz) {
        return (T)((ResponseImpl)response).doReadEntity(clazz, clazz, clazz.getAnnotations());
    }

    private static String readStream(InputStream inputStream, MediaType mediaType) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        return outputStream.toString("UTF-8");
    }
}

