/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.rest.metrics.DevProgressItemId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public final class DevProgressMetricsReport
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final String fileName;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final int dayOfWeek;
    private final int duration;
    private final boolean periodic;
    private final boolean nonPeriodic;
    private final boolean periodicTask;
    private final boolean nonPeriodicTask;
    private ExcelXmlWriter writer;
    private final QueryBuilder query;
    private final Calendar baseCalendar;
    private final Collection<String> stateList;
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    Pattern UI_DELETED = Pattern.compile("^\\(Deleted\\)$");
    private final DevProgressItemId[] actionColumns = new DevProgressItemId[]{DevProgressItemId.ACT, DevProgressItemId.ActionName, DevProgressItemId.Program, DevProgressItemId.Build, DevProgressItemId.Date, DevProgressItemId.Created, DevProgressItemId.WorkType, DevProgressItemId.TW, DevProgressItemId.State, DevProgressItemId.Analyze, DevProgressItemId.Authorize, DevProgressItemId.Implement, DevProgressItemId.Complete, DevProgressItemId.Cancelled, DevProgressItemId.TotalCount, DevProgressItemId.CompletedCount, DevProgressItemId.CancelledCount, DevProgressItemId.TotalAddModCount, DevProgressItemId.CompletedAddModCount, DevProgressItemId.CancelledAddModCount, DevProgressItemId.TotalDeletedCount, DevProgressItemId.CompletedDeletedCount, DevProgressItemId.CancelledDeletedCount};
    private final DevProgressItemId[] taskColumns = new DevProgressItemId[]{DevProgressItemId.ACT, DevProgressItemId.TW, DevProgressItemId.Program, DevProgressItemId.Build, DevProgressItemId.TW, DevProgressItemId.TSK, DevProgressItemId.TSKName, DevProgressItemId.TSKType, DevProgressItemId.Date, DevProgressItemId.Created, DevProgressItemId.State, DevProgressItemId.TSKEndorse, DevProgressItemId.TSKAnalyze, DevProgressItemId.TSKAuthorize, DevProgressItemId.TSKImplement, DevProgressItemId.TSKComplete, DevProgressItemId.TSKCancelled};

    public DevProgressMetricsReport(OrcsApi orcsApi, AtsApi atsApi, String fileName, String targetVersion, Date startDate, Date endDate, int dayOfWeek, int duration, boolean periodic, boolean nonPeriodic, boolean periodicTask, boolean nonPeriodicTask) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.fileName = fileName;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.dayOfWeek = dayOfWeek;
        this.duration = duration;
        this.periodic = periodic;
        this.nonPeriodic = nonPeriodic;
        this.periodicTask = periodicTask;
        this.nonPeriodicTask = nonPeriodicTask;
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)atsApi.getAtsBranch());
        this.baseCalendar = this.getBaseCalendar();
        this.stateList = List.of("Analyze", "Authorize", "Implement", "Completed", "Cancelled");
    }

    public void write(OutputStream output) {
        try {
            File file = OseeData.getFile((String)this.fileName);
            this.writer = new ExcelXmlWriter(file);
            this.writeReport();
            this.writer.endWorkbook();
            Desktop.getDesktop().open(file);
        }
        catch (Exception ex) {
            try {
                this.writer.endWorkbook();
            }
            catch (IOException ex1) {
                throw new WebApplicationException((Throwable)ex1);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        Collection<IAtsTeamWorkflow> workflows = this.getDatedWorkflows();
        if (!workflows.isEmpty()) {
            Set<IAtsAction> actionableItems = this.getDatedActions(workflows);
            if (this.periodic) {
                this.writer.startSheet("Periodic Data", this.actionColumns.length);
                this.fillActionableData(actionableItems, this.actionColumns.length);
            }
            if (this.nonPeriodic) {
                this.writer.startSheet("Non-Periodic Data", this.actionColumns.length);
                this.fillActionableData(actionableItems, this.actionColumns.length);
            }
            if (this.periodicTask) {
                this.writer.startSheet("Periodic Data", this.taskColumns.length);
                this.fillTaskData(workflows, this.taskColumns.length);
            }
            if (this.nonPeriodicTask) {
                this.writer.startSheet("Periodic Data", this.taskColumns.length);
                this.fillTaskData(workflows, this.taskColumns.length);
            }
        }
    }

    private Collection<IAtsTeamWorkflow> getDatedWorkflows() {
        ArtifactReadable versionId = this.query.andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.Name, this.targetVersion).asArtifact();
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsTeamWorkflow> datedWorkflowArts = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            if (!workflow.isWorkType(WorkType.Requirements) && !workflow.isWorkType(WorkType.Code) && !workflow.isWorkType(WorkType.Test) || !workflow.getCreatedDate().before(this.endDate) || workflow.isCompleted() && workflow.getCompletedDate() != null && workflow.getCompletedDate().before(this.startDate) || workflow.isCancelled() && workflow.getCancelledDate() != null && workflow.getCancelledDate().before(this.startDate)) continue;
            datedWorkflowArts.add(workflow);
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return datedWorkflowArts;
    }

    private Set<IAtsAction> getDatedActions(Collection<IAtsTeamWorkflow> workflows) {
        HashSet<IAtsAction> actionableItems = new HashSet<IAtsAction>();
        for (IAtsTeamWorkflow workflow : workflows) {
            actionableItems.add(workflow.getParentAction());
        }
        return actionableItems;
    }

    private void fillActionableData(Set<IAtsAction> actionableItems, int numColumns) throws IOException {
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.actionColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsAction actionItem : actionableItems) {
            buffer[0] = actionItem.getAtsId();
            buffer[1] = actionItem.getName();
            buffer[2] = this.programVersion;
            buffer[3] = this.targetVersion;
            Date createdDate = new Date();
            for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
                if (!teamWorkflow.getCreatedDate().before(createdDate)) continue;
                createdDate = teamWorkflow.getCreatedDate();
            }
            buffer[5] = createdDate;
            if (this.periodic) {
                GregorianCalendar incrementedCalendar = new GregorianCalendar();
                incrementedCalendar.setTime(this.baseCalendar.getTime());
                while (incrementedCalendar.getTime().before(this.endDate)) {
                    if (createdDate.before(incrementedCalendar.getTime())) {
                        this.fillTeamWfData(buffer, incrementedCalendar.getTime(), actionItem);
                    }
                    ((Calendar)incrementedCalendar).add(5, this.duration);
                }
                continue;
            }
            if (!this.nonPeriodic) continue;
            this.fillTeamWfData(buffer, this.endDate, actionItem);
        }
        this.writer.endSheet();
    }

    private void fillTeamWfData(Object[] buffer, Date rowDate, IAtsAction actionItem) {
        int tasksCancelled;
        int tasksCompleted;
        int i;
        int[] deletedCounts;
        Collection<IAtsTask> tasks;
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        buffer[4] = sdf.format(rowDate);
        IAtsTeamWorkflow requirementsWorkflow = IAtsTeamWorkflow.SENTINEL;
        IAtsTeamWorkflow codeWorkflow = IAtsTeamWorkflow.SENTINEL;
        IAtsTeamWorkflow testWorkflow = IAtsTeamWorkflow.SENTINEL;
        for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
            if (teamWorkflow.isWorkType(WorkType.Requirements)) {
                if (requirementsWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                    requirementsWorkflow = teamWorkflow;
                    continue;
                }
                if (!requirementsWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
                requirementsWorkflow = teamWorkflow;
                continue;
            }
            if (teamWorkflow.isWorkType(WorkType.Code)) {
                if (codeWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                    codeWorkflow = teamWorkflow;
                    continue;
                }
                if (!codeWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
                codeWorkflow = teamWorkflow;
                continue;
            }
            if (!teamWorkflow.isWorkType(WorkType.Test)) continue;
            if (testWorkflow.equals(IAtsTeamWorkflow.SENTINEL)) {
                testWorkflow = teamWorkflow;
                continue;
            }
            if (!testWorkflow.isCancelled() || teamWorkflow.isCancelled()) continue;
            testWorkflow = teamWorkflow;
        }
        int reqTasks = 0;
        int reqAddModTasks = 0;
        int reqDeletedTasks = 0;
        if (!codeWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)codeWorkflow, rowDate).isEmpty()) {
            tasks = this.getTaskList(codeWorkflow, rowDate);
            deletedCounts = this.getDeletedTaskCount(codeWorkflow, rowDate);
            buffer[6] = "Code";
            buffer[7] = codeWorkflow.getAtsId();
            buffer[8] = this.getStateAtDate((IAtsWorkItem)codeWorkflow, rowDate);
            i = 9;
            for (String state : this.stateList) {
                buffer[i++] = this.getStateStartDate((IAtsWorkItem)codeWorkflow, rowDate, state);
            }
            tasksCompleted = this.getTaskCompleted(codeWorkflow, rowDate, tasks);
            tasksCancelled = this.getTaskCancelled(codeWorkflow, rowDate, tasks);
            buffer[14] = tasks.size();
            buffer[15] = tasksCompleted;
            buffer[16] = tasksCancelled;
            buffer[17] = tasks.size() - deletedCounts[0];
            buffer[18] = tasksCompleted - deletedCounts[1];
            buffer[19] = tasksCancelled - deletedCounts[2];
            buffer[20] = deletedCounts[0];
            buffer[21] = deletedCounts[1];
            buffer[22] = deletedCounts[2];
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!testWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)testWorkflow, rowDate).isEmpty()) {
            tasks = this.getTaskList(testWorkflow, rowDate);
            deletedCounts = this.getDeletedTaskCount(testWorkflow, rowDate);
            buffer[6] = "Test";
            buffer[7] = testWorkflow.getAtsId();
            buffer[8] = this.getStateAtDate((IAtsWorkItem)testWorkflow, rowDate);
            i = 9;
            for (String state : this.stateList) {
                buffer[i++] = this.getStateStartDate((IAtsWorkItem)testWorkflow, rowDate, state);
            }
            reqTasks = tasks.size();
            reqAddModTasks = tasks.size() - deletedCounts[0];
            reqDeletedTasks = deletedCounts[0];
            tasksCompleted = this.getTaskCompleted(testWorkflow, rowDate, tasks);
            tasksCancelled = this.getTaskCancelled(testWorkflow, rowDate, tasks);
            buffer[14] = tasks.size();
            buffer[15] = tasksCompleted;
            buffer[16] = tasksCancelled;
            buffer[17] = tasks.size() - deletedCounts[0];
            buffer[18] = tasksCompleted - deletedCounts[1];
            buffer[19] = tasksCancelled - deletedCounts[2];
            buffer[20] = deletedCounts[0];
            buffer[21] = deletedCounts[1];
            buffer[22] = deletedCounts[2];
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!requirementsWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)requirementsWorkflow, rowDate).isEmpty()) {
            String stateAtDate = this.getStateAtDate((IAtsWorkItem)requirementsWorkflow, rowDate);
            buffer[6] = "Requirements";
            buffer[7] = requirementsWorkflow.getAtsId();
            buffer[8] = this.getStateAtDate((IAtsWorkItem)requirementsWorkflow, rowDate);
            int i2 = 9;
            for (String state : this.stateList) {
                buffer[i2++] = this.getStateStartDate((IAtsWorkItem)requirementsWorkflow, rowDate, state);
            }
            buffer[14] = reqTasks;
            buffer[17] = reqAddModTasks;
            buffer[20] = reqDeletedTasks;
            if (stateAtDate.contains("Complete")) {
                buffer[15] = reqTasks;
                buffer[16] = 0;
                buffer[18] = reqAddModTasks;
                buffer[19] = 0;
                buffer[21] = reqDeletedTasks;
                buffer[22] = 0;
            } else if (stateAtDate.equals("Cancelled")) {
                buffer[15] = 0;
                buffer[16] = reqTasks;
                buffer[18] = 0;
                buffer[19] = reqAddModTasks;
                buffer[21] = 0;
                buffer[22] = reqDeletedTasks;
            } else {
                buffer[15] = 0;
                buffer[16] = 0;
                buffer[18] = 0;
                buffer[19] = 0;
                buffer[21] = 0;
                buffer[22] = 0;
            }
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    private void fillTaskData(Collection<IAtsTeamWorkflow> workflows, int numColumns) throws IOException {
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.taskColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsTeamWorkflow workflow : workflows) {
            buffer[0] = workflow.getParentAction().getAtsId();
            buffer[1] = workflow.getAtsId();
            buffer[2] = this.programVersion;
            buffer[3] = this.targetVersion;
            Collection<IAtsTask> tasks = this.getTaskList(workflow, this.endDate);
            for (IAtsTask task : tasks) {
                buffer[4] = task.getAtsId();
                buffer[5] = task.getName();
                if (this.periodicTask) {
                    GregorianCalendar incrementedCalendar = new GregorianCalendar();
                    incrementedCalendar.setTime(this.baseCalendar.getTime());
                    while (incrementedCalendar.getTime().before(this.endDate)) {
                        if (workflow.getCreatedDate().before(incrementedCalendar.getTime()) && task.getCreatedDate().before(incrementedCalendar.getTime())) {
                            this.fillTaskStateData(buffer, incrementedCalendar.getTime(), task);
                        }
                        ((Calendar)incrementedCalendar).add(5, this.duration);
                    }
                    continue;
                }
                if (!this.nonPeriodicTask) continue;
                this.fillTaskStateData(buffer, this.endDate, task);
            }
        }
        this.writer.endSheet();
    }

    private void fillTaskStateData(Object[] buffer, Date rowDate, IAtsTask task) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        buffer[6] = sdf.format(rowDate);
        buffer[7] = task.getCreatedDate();
        buffer[8] = this.getStateAtDate((IAtsWorkItem)task, rowDate);
        int i = 9;
        for (String state : this.stateList) {
            buffer[i++] = this.getStateStartDate((IAtsWorkItem)task, rowDate, state);
        }
        try {
            this.writer.writeRow(buffer);
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private String getStateAtDate(IAtsWorkItem teamWorkflow, Date iterationDate) {
        String stateName = "";
        Date stateStartDate = new GregorianCalendar(1916, 7, 15).getTime();
        try {
            for (String visitedState : teamWorkflow.getStateMgr().getVisitedStateNames()) {
                Date newStateStartDate;
                if (!this.stateList.contains(visitedState) || !(newStateStartDate = teamWorkflow.getStateMgr().getStateStartedData(visitedState).getDate()).before(iterationDate) || !newStateStartDate.after(stateStartDate)) continue;
                stateName = visitedState;
                stateStartDate = newStateStartDate;
            }
        }
        catch (Exception exception) {}
        return stateName;
    }

    private String getStateStartDate(IAtsWorkItem teamWorkflow, Date iterationDate, String stateName) {
        try {
            IAtsLogItem stateStartedData = teamWorkflow.getStateMgr().getStateStartedData(stateName);
            if (stateStartedData.getDate().before(iterationDate)) {
                return stateStartedData.getDate("MM/dd/yyyy");
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Collection<IAtsTask> getTaskList(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        ArrayList<IAtsTask> tasks = new ArrayList<IAtsTask>();
        ArrayList<String> taskUINames = new ArrayList<String>();
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher m = this.UI_NAME.matcher(task.getName());
            if (!m.find()) continue;
            String taskUIName = m.group();
            if (!task.getCreatedDate().before(iterationDate) || taskUINames.contains(taskUIName)) continue;
            taskUINames.add(taskUIName);
            tasks.add(task);
        }
        return tasks;
    }

    private int[] getDeletedTaskCount(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        int[] deletedCounts = new int[3];
        int deletedCount = 0;
        int deletedCompleteCount = 0;
        int deletedCancelledCount = 0;
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher m = this.UI_DELETED.matcher(task.getName());
            if (!m.find()) continue;
            try {
                if (!task.getCreatedDate().before(iterationDate)) continue;
                ++deletedCount;
                if (task.isCompleted() && task.getCompletedDate().before(iterationDate)) {
                    ++deletedCompleteCount;
                    continue;
                }
                if (!task.isCancelled() || !task.getCancelledDate().before(iterationDate)) continue;
                ++deletedCancelledCount;
            }
            catch (Exception exception) {}
        }
        deletedCounts[0] = deletedCount;
        deletedCounts[1] = deletedCompleteCount;
        deletedCounts[2] = deletedCancelledCount;
        return deletedCounts;
    }

    private int getTaskCompleted(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        ArrayList<IAtsTask> iterationTasks = new ArrayList<IAtsTask>();
        for (IAtsTask task : tasks) {
            try {
                if ((!task.isCompleted() || !task.getCompletedDate().before(iterationDate)) && !task.getStateMgr().getCurrentState().getName().equals("No_Change")) continue;
                iterationTasks.add(task);
            }
            catch (Exception exception) {}
        }
        return iterationTasks.size();
    }

    private int getTaskCancelled(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        ArrayList<IAtsTask> iterationTasks = new ArrayList<IAtsTask>();
        for (IAtsTask task : tasks) {
            try {
                if (!task.isCancelled() || !task.getCancelledDate().before(iterationDate)) continue;
                iterationTasks.add(task);
            }
            catch (Exception exception) {}
        }
        return iterationTasks.size();
    }

    private Calendar getBaseCalendar() {
        GregorianCalendar calendarIncrement = new GregorianCalendar();
        calendarIncrement.setTime(this.startDate);
        int weekAdjustment = (this.dayOfWeek - calendarIncrement.get(7)) % 7;
        ((Calendar)calendarIncrement).add(5, weekAdjustment);
        return calendarIncrement;
    }
}

