/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.authorization;

import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.authorization.admin.Authority;
import org.eclipse.osee.authorization.admin.AuthorizationData;
import org.eclipse.osee.authorization.admin.AuthorizationProvider;
import org.eclipse.osee.authorization.admin.AuthorizationRequest;
import org.eclipse.osee.authorization.admin.AuthorizationUser;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class OseeAuthorizationProvider
implements AuthorizationProvider,
AuthorizationData,
Authority {
    private OrcsApi orcsApi;
    Principal principal;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public String getScheme() {
        return "OSEE";
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Authority getAuthority() {
        return this;
    }

    public AuthorizationData authorize(AuthorizationRequest request) {
        Set<String> rolesFromStore = this.getRolesFromStore(request.getIdentifier());
        this.principal = this.newAuthorization(rolesFromStore);
        return this;
    }

    private BranchId getAdminBranch() {
        return CoreBranches.COMMON;
    }

    private QueryFactory getQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private Set<String> getRolesFromStore(long identifier) {
        HashSet<String> roles = new HashSet<String>();
        ArtifactReadable oseeUser = (ArtifactReadable)this.getQuery().fromBranch(this.getAdminBranch()).andUuid(identifier).getResults().getExactlyOne();
        ResultSet groups = oseeUser.getRelated(CoreRelationTypes.UniversalGrouping_Group);
        for (ArtifactReadable group : groups) {
            roles.add(group.getName());
        }
        return roles;
    }

    public boolean isInRole(String role) {
        return true;
    }

    private AuthorizationUser newAuthorization(final Set<String> roles) {
        return new AuthorizationUser(){

            public Iterable<String> getRoles() {
                return roles;
            }

            public boolean isAuthenticated() {
                return true;
            }

            public String getName() {
                return null;
            }

            public Date getCreationDate() {
                return null;
            }

            public boolean isSecure() {
                return false;
            }

            public Principal getPrincipal() {
                return null;
            }

            public String getScheme() {
                return null;
            }

            public boolean isInRole(String role) {
                return false;
            }
        };
    }
}

