/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal;

import java.util.Map;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.Subscription;
import org.eclipse.osee.account.admin.SubscriptionAdmin;
import org.eclipse.osee.account.admin.SubscriptionGroup;
import org.eclipse.osee.account.admin.ds.SubscriptionStorage;
import org.eclipse.osee.account.admin.internal.validator.Validator;
import org.eclipse.osee.account.admin.internal.validator.Validators;
import org.eclipse.osee.account.rest.model.SubscriptionGroupId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;

public class SubscriptionAdminImpl
implements SubscriptionAdmin {
    private Log logger;
    private SubscriptionStorage storage;
    private Validator validator;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setSubscriptionStorage(SubscriptionStorage storage) {
        this.storage = storage;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting SubscriptionsAdminImpl...", new Object[0]);
        this.validator = Validators.newSubscriptionValidator(this.logger, this.storage);
        this.update(props);
    }

    public void stop() {
        this.logger.trace("Stopping SubscriptionsAdminImpl...", new Object[0]);
    }

    public void update(Map<String, Object> props) {
        this.validator.configure(props);
    }

    private SubscriptionStorage getStorage() {
        return this.storage;
    }

    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    public SubscriptionGroup getSubscriptionGroupById(SubscriptionGroupId subscriptionId) {
        return this.getStorage().getSubscriptionGroupById(subscriptionId);
    }

    @Override
    public ResultSet<Subscription> getSubscriptionsByAccountId(ArtifactId accountId) {
        return this.getStorage().getSubscriptionsByAccountId(accountId);
    }

    @Override
    public Subscription getSubscriptionsByEncodedId(String encodedId) {
        return this.getStorage().getSubscriptionByEncodedId(encodedId);
    }

    @Override
    public boolean setSubscriptionActive(Subscription subscription, boolean active) {
        boolean modified = false;
        if (subscription != null && subscription.isActive() != active) {
            this.getStorage().updateSubscription(subscription, active);
            modified = true;
        }
        return modified;
    }

    @Override
    public ResultSet<SubscriptionGroup> getSubscriptionGroups() {
        return this.getStorage().getSubscriptionGroups();
    }

    @Override
    public SubscriptionGroupId createSubscriptionGroup(String groupName) {
        Conditions.checkNotNull((Object)groupName, (String)"group name");
        Validator validator = this.getValidator();
        validator.validate(AccountField.SUBSCRIPTION_GROUP_NAME, groupName);
        return this.getStorage().createSubscriptionGroup(groupName);
    }

    @Override
    public boolean deleteSubscriptionById(SubscriptionGroupId subscriptionId) {
        return this.getStorage().deleteSubscriptionGroup(subscriptionId);
    }

    @Override
    public ResultSet<Account> getSubscriptionMembersOfSubscriptionById(SubscriptionGroupId subscriptionId) {
        return this.getStorage().getMembersOfSubscriptionGroupById(subscriptionId);
    }
}

