/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class MetadataOptions
implements ToMessage {
    @JsonProperty(value="Format")
    private String format;
    @JsonProperty(value="Label")
    private String label;
    @JsonProperty(value="Type")
    private String type;

    public MetadataOptions() {
        this.format = null;
        this.label = null;
        this.type = null;
    }

    public MetadataOptions(String type, String format, String label) {
        this.format = Objects.requireNonNull(format, "MetadataOptions::new, parameter \"format\" cannot be null.");
        this.label = Objects.requireNonNull(label, "MetadataOptions::new, parameter \"label\" cannot be null.");
        this.type = Objects.requireNonNull(type, "MetadataOptions::new, parameter \"type\" cannot be null.");
    }

    public void defaults() {
        if (Objects.isNull(this.format)) {
            this.format = "";
        }
        if (Objects.isNull(this.label)) {
            this.label = "";
        }
        if (Objects.isNull(this.type)) {
            this.type = "";
        }
    }

    public String getFormat() {
        if (Objects.isNull(this.format)) {
            throw new IllegalStateException("MetadataOptions::getFormat, member \"format\" has not been set.");
        }
        return this.format;
    }

    public String getLabel() {
        if (Objects.isNull(this.label)) {
            throw new IllegalStateException("MetadataOptions::getLabel, member \"label\" has not been set.");
        }
        return this.label;
    }

    public String getType() {
        if (Objects.isNull(this.type)) {
            throw new IllegalStateException("MetadataOptions::getType, member \"type\" has not been set.");
        }
        return this.type;
    }

    public boolean isValid() {
        return Objects.nonNull(this.format) && Objects.nonNull(this.label) && Objects.nonNull(this.type);
    }

    public void setFormat(String format) {
        if (Objects.nonNull(this.format)) {
            throw new IllegalStateException("MetadataOptions::setFormat, member \"format\" has already been set.");
        }
        this.format = Objects.requireNonNull(format, "MetadataOptions::new, parameter \"format\" cannot be null.");
    }

    public void setLabel(String label) {
        if (Objects.nonNull(this.label)) {
            throw new IllegalStateException("MetadataOptions::setLabel, member \"label\" has already been set.");
        }
        this.label = Objects.requireNonNull(label, "MetadataOptions::new, parameter \"label\" cannot be null.");
    }

    public void setType(String type) {
        if (Objects.nonNull(this.type)) {
            throw new IllegalStateException("MetadataOptions::setType, member \"type\" has already been set.");
        }
        this.type = Objects.requireNonNull(type, "MetadataOptions::new, parameter \"type\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"MetadataOptions").indentInc().segment((CharSequence)"Format", (Object)this.format).segment((CharSequence)"Label", (Object)this.label).segment((CharSequence)"Type", (Object)this.type).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

