/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.orcs.OseeDb;

public final class DatabaseCreation {
    private final JdbcClient jdbcClient;

    public DatabaseCreation(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public void createDataStore() {
        this.dropTables();
        if (this.jdbcClient.getDbType().equals((Object)JdbcDbType.hsql)) {
            this.jdbcClient.runPreparedUpdate("SET DATABASE SQL SYNTAX ORA TRUE;", new Object[0]);
        }
        this.jdbcClient.createTable(OseeDb.ARTIFACT_TABLE);
        this.jdbcClient.createTable(OseeDb.ATTRIBUTE_TABLE);
        this.jdbcClient.createTable(OseeDb.RELATION_TABLE);
        this.jdbcClient.createTable(OseeDb.RELATION_TABLE2);
        this.jdbcClient.createTable(OseeDb.BRANCH_TABLE);
        this.jdbcClient.createTable(OseeDb.TXS_TABLE);
        this.jdbcClient.createTable(OseeDb.TXS_ARCHIVED_TABLE);
        this.jdbcClient.createTable(OseeDb.TX_DETAILS_TABLE);
        this.jdbcClient.alterForeignKeyConstraint("PARENT_TX_ID_FK1", OseeDb.BRANCH_TABLE, OseeDb.BRANCH_PARENT_TRANSACTION_ID, OseeDb.TX_DETAILS_TABLE, OseeDb.TX_DETAILS_TRANSACTION_ID, "");
        this.jdbcClient.deferredForeignKeyConstraint("BASELINE_TX_ID_FK1", OseeDb.BRANCH_TABLE, OseeDb.BRANCH_BASELINE_TRANSACTION_ID, OseeDb.TX_DETAILS_TABLE, OseeDb.TX_DETAILS_TRANSACTION_ID);
        this.jdbcClient.createTable(OseeDb.OSEE_PERMISSION_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_ARTIFACT_ACL_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_BRANCH_ACL_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_SEARCH_TAGS_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_TAG_GAMMA_QUEUE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_SEQUENCE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_INFO_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_MERGE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_CONFLICT_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_EXPORT_IMPORT_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_IMPORT_SOURCE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_IMPORT_SAVE_POINT_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_IMPORT_MAP_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_IMPORT_INDEX_MAP_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_ARTIFACT_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_ID_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_CLEANUP_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_CHAR_ID_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_TRANSACTION_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_BRANCH_GROUP_TABLE);
        this.jdbcClient.createTable(OseeDb.LDAP_DETAILS_TABLE);
        this.jdbcClient.createTable(OseeDb.TUPLE2);
        this.jdbcClient.createTable(OseeDb.TUPLE3);
        this.jdbcClient.createTable(OseeDb.TUPLE4);
        this.jdbcClient.createTable(OseeDb.BRANCH_CATEGORY);
        this.jdbcClient.createTable(OseeDb.OSEE_KEY_VALUE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_SERVER_LOOKUP_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_SESSION_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_ACTIVITY_TYPE_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_ACTIVITY_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_OAUTH_AUTHORIZATION_TABLE);
        this.jdbcClient.createTable(OseeDb.OSEE_OAUTH_TOKEN_TABLE);
    }

    private void dropTables() {
        this.jdbcClient.dropConstraint(OseeDb.TX_DETAILS_TABLE, "BRANCH_ID_FK1");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_ARTIFACT_ACL_TABLE, "ARTIFACT_ACL_PERM_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_BRANCH_ACL_TABLE, "BRANCH_ACL_PERM_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_PERMISSION_TABLE, String.valueOf(OseeDb.OSEE_PERMISSION_TABLE.getName()) + "_PK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_MERGE_TABLE, "OSEE_MERGE__MBI_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_MERGE_TABLE, "OSEE_MERGE__DBI_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_BRANCH_ACL_TABLE, "BRANCH_ACL_FK");
        this.jdbcClient.dropConstraint(OseeDb.BRANCH_TABLE, String.valueOf(OseeDb.BRANCH_TABLE.getName()) + "_PK");
        this.jdbcClient.dropConstraint(OseeDb.TUPLE2, String.valueOf(OseeDb.TUPLE2.getName()) + "_PK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_IMPORT_SAVE_POINT_TABLE, "OSEE_IMP_SAVE_POINT_II_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_IMPORT_MAP_TABLE, "OSEE_IMPORT_MAP_II_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_IMPORT_INDEX_MAP_TABLE, "OSEE_IMPORT_INDEX_MAP_II_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_OAUTH_AUTHORIZATION_TABLE, "OSEE_OAUTH_AUTH__CI_FK");
        this.jdbcClient.dropConstraint(OseeDb.OSEE_OAUTH_TOKEN_TABLE, "OSEE_OAUTH_TOKEN__CI_FK");
        this.jdbcClient.dropTable(OseeDb.OSEE_ARTIFACT_ACL_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_BRANCH_ACL_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_CONFLICT_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_MERGE_TABLE);
        this.jdbcClient.dropTable(OseeDb.ARTIFACT_TABLE);
        this.jdbcClient.dropTable(OseeDb.ATTRIBUTE_TABLE);
        this.jdbcClient.dropTable(OseeDb.RELATION_TABLE);
        this.jdbcClient.dropTable(OseeDb.RELATION_TABLE2);
        this.jdbcClient.dropTable(OseeDb.BRANCH_TABLE);
        this.jdbcClient.dropTable(OseeDb.TXS_TABLE);
        this.jdbcClient.dropTable(OseeDb.TXS_ARCHIVED_TABLE);
        this.jdbcClient.dropTable(OseeDb.TX_DETAILS_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_PERMISSION_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_SEARCH_TAGS_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_TAG_GAMMA_QUEUE_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_SEQUENCE_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_INFO_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_EXPORT_IMPORT_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_IMPORT_SOURCE_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_IMPORT_SAVE_POINT_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_IMPORT_MAP_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_IMPORT_INDEX_MAP_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_ARTIFACT_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_ID_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_CLEANUP_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_CHAR_ID_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_TRANSACTION_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_BRANCH_GROUP_TABLE);
        this.jdbcClient.dropTable(OseeDb.LDAP_DETAILS_TABLE);
        this.jdbcClient.dropTable(OseeDb.TUPLE2);
        this.jdbcClient.dropTable(OseeDb.TUPLE3);
        this.jdbcClient.dropTable(OseeDb.TUPLE4);
        this.jdbcClient.dropTable(OseeDb.BRANCH_CATEGORY);
        this.jdbcClient.dropTable(OseeDb.OSEE_KEY_VALUE_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_SERVER_LOOKUP_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_SESSION_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_ACTIVITY_TYPE_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_ACTIVITY_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_OAUTH_AUTHORIZATION_TABLE);
        this.jdbcClient.dropTable(OseeDb.OSEE_OAUTH_TOKEN_TABLE);
    }
}

